/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class InputStreamCloner {
    private static final int COPY_SIZE = 1024;
    private boolean copied = false;
    private InputStream original = null;
    private byte[] bytes = null;
    private int hashcode = 0;

    public InputStreamCloner(InputStream inputStream) {
        this.original = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void copyStream() throws IOException {
        if (this.copied) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = this.original.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
            this.copied = true;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
    }

    public InputStream cloneStream() throws IOException {
        if (!this.copied) {
            this.copyStream();
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof InputStreamCloner)) {
            return false;
        }
        InputStreamCloner inputStreamCloner = (InputStreamCloner)object;
        if (this.original == inputStreamCloner.original) {
            return true;
        }
        try {
            this.copyStream();
            inputStreamCloner.copyStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return Arrays.equals(this.bytes, inputStreamCloner.bytes);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            try {
                this.copyStream();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.bytes == null) {
                return 0;
            }
            int n = 1;
            for (int i = 0; i < this.bytes.length; ++i) {
                n = n * 31 + this.bytes[i];
            }
            this.hashcode = n;
        }
        return this.hashcode;
    }
}

