/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.File;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConstants;
import weblogic.security.utils.KeyStoreInfo;

public class KeyStoreConfigurationHelper {
    private KeyStoreConfiguration config;
    private NetworkAccessPointMBean channel = null;

    private boolean isValid() {
        return this.config.getKeyStores() != null;
    }

    private boolean isDemoIdentity() {
        return "DemoIdentityAndDemoTrust".equals(this.config.getKeyStores());
    }

    private boolean isDemoTrust() {
        return "DemoIdentityAndDemoTrust".equals(this.config.getKeyStores());
    }

    private boolean isJavaStandardTrust() {
        return "CustomIdentityAndJavaStandardTrust".equals(this.config.getKeyStores());
    }

    private boolean isCustomTrust() {
        return "CustomIdentityAndCustomTrust".equals(this.config.getKeyStores());
    }

    private String emptyToNull(String string) {
        if (string != null && string.length() < 1) {
            return null;
        }
        return string;
    }

    private String getAbsolutePath(String string) {
        if (this.emptyToNull(string) == null) {
            return null;
        }
        return new File(string).getAbsolutePath();
    }

    public KeyStoreConfigurationHelper(KeyStoreConfiguration keyStoreConfiguration) {
        this.config = keyStoreConfiguration;
    }

    public KeyStoreConfigurationHelper(KeyStoreConfiguration keyStoreConfiguration, NetworkAccessPointMBean networkAccessPointMBean) {
        this.config = keyStoreConfiguration;
        this.channel = networkAccessPointMBean;
    }

    private KeyStoreInfo getDemoIdentityKeyStoreInfo() {
        return new KeyStoreInfo(KeyStoreConstants.getDemoIdentityKeyStoreFileName(), "jks", "DemoIdentityKeyStorePassPhrase");
    }

    private KeyStoreInfo getCustomIdentityKeyStoreInfo() {
        return new KeyStoreInfo(this.getAbsolutePath(this.config.getCustomIdentityKeyStoreFileName()), this.emptyToNull(this.config.getCustomIdentityKeyStoreType()), this.emptyToNull(this.config.getCustomIdentityKeyStorePassPhrase()));
    }

    private KeyStoreInfo getDemoTrustKeyStoreInfo() {
        return new KeyStoreInfo(KeyStoreConstants.getDemoTrustKeyStoreFileName(), "jks", "DemoTrustKeyStorePassPhrase");
    }

    private KeyStoreInfo getJavaStandardTrustKeyStoreInfo() {
        return new KeyStoreInfo(KeyStoreConstants.getJavaStandardTrustKeyStoreFileName(), "jks", this.emptyToNull(this.config.getJavaStandardTrustKeyStorePassPhrase()));
    }

    private KeyStoreInfo getCustomTrustKeyStoreInfo() {
        return new KeyStoreInfo(this.getAbsolutePath(this.config.getCustomTrustKeyStoreFileName()), this.emptyToNull(this.config.getCustomTrustKeyStoreType()), this.emptyToNull(this.config.getCustomTrustKeyStorePassPhrase()));
    }

    public KeyStoreInfo getIdentityKeyStore() {
        if (!this.isValid()) {
            return null;
        }
        return this.isDemoIdentity() ? this.getDemoIdentityKeyStoreInfo() : this.getCustomIdentityKeyStoreInfo();
    }

    public KeyStoreInfo[] getTrustKeyStores() {
        if (!this.isValid()) {
            return null;
        }
        KeyStoreInfo[] keyStoreInfoArray = null;
        keyStoreInfoArray = this.isDemoTrust() ? new KeyStoreInfo[]{this.getDemoTrustKeyStoreInfo(), this.getJavaStandardTrustKeyStoreInfo()} : (this.isJavaStandardTrust() ? new KeyStoreInfo[]{this.getJavaStandardTrustKeyStoreInfo()} : new KeyStoreInfo[]{this.getCustomTrustKeyStoreInfo()});
        return keyStoreInfoArray;
    }

    public String getIdentityAlias() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isDemoTrust()) {
            return "DemoIdentity";
        }
        if (this.channel != null) {
            return this.emptyToNull(this.channel.getPrivateKeyAlias());
        }
        return this.emptyToNull(this.config.getCustomIdentityAlias());
    }

    public char[] getIdentityPrivateKeyPassPhrase() {
        if (!this.isValid()) {
            return null;
        }
        String string = null;
        string = this.isDemoTrust() ? "DemoIdentityPassPhrase" : (this.channel != null ? this.emptyToNull(this.channel.getPrivateKeyPassPhrase()) : this.emptyToNull(this.config.getCustomIdentityPrivateKeyPassPhrase()));
        return string != null && string.length() > 0 ? string.toCharArray() : null;
    }

    public String getOutboundPrivateKeyAlias() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isDemoIdentity()) {
            return "DemoIdentity";
        }
        if (this.channel != null) {
            return this.emptyToNull(this.channel.getOutboundPrivateKeyAlias());
        }
        return this.emptyToNull(this.config.getOutboundPrivateKeyAlias());
    }

    public char[] getOutboundPrivateKeyPassPhrase() {
        if (!this.isValid()) {
            return null;
        }
        String string = this.isDemoIdentity() ? "DemoIdentityPassPhrase" : (this.channel != null ? this.emptyToNull(this.channel.getOutboundPrivateKeyPassPhrase()) : this.emptyToNull(this.config.getOutboundPrivateKeyPassPhrase()));
        return string != null && string.length() > 0 ? string.toCharArray() : null;
    }
}

