/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.KeyStore;
import java.util.Arrays;

public final class KeyStoreInfo {
    private String filename;
    private String type;
    private char[] passphrase;

    KeyStoreInfo(String string, String string2, String string3) {
        this.filename = string;
        this.type = string2 != null && string2.length() > 0 ? string2 : KeyStore.getDefaultType();
        this.passphrase = string3 != null && string3.length() > 0 ? string3.toCharArray() : null;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getType() {
        return this.type;
    }

    public char[] getPassPhrase() {
        return this.passphrase;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyStoreInfo)) {
            return false;
        }
        KeyStoreInfo keyStoreInfo = (KeyStoreInfo)object;
        return KeyStoreInfo.equals(this.filename, keyStoreInfo.filename) && KeyStoreInfo.equals(this.type, keyStoreInfo.type) && Arrays.equals(this.passphrase, keyStoreInfo.passphrase);
    }

    private static final boolean equals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public int hashCode() {
        int n = this.filename == null ? 1 : this.filename.hashCode();
        n = n * 31 + (this.type == null ? 1 : this.type.hashCode());
        n = n * 31 + Arrays.hashCode(this.passphrase);
        return n;
    }

    public String toString() {
        return "FileName=" + this.filename + ", Type=" + this.type + ", PassPhraseUsed=" + (this.passphrase != null);
    }
}

