/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;
import utils.CertGen;
import weblogic.management.bootstrap.BootStrap;

public final class KeyStoreInstall {
    public static void initDefaultKeyStore() throws Exception {
        KeyStoreInstall.initDefaultKeyStore(null);
    }

    public static void initDefaultKeyStore(String string) throws Exception {
        if (string == null) {
            string = InetAddress.getLocalHost().getHostName();
        }
        Properties properties = new Properties();
        properties.put("x500name.commonname", string);
        KeyStoreInstall.initDefaultKeyStore("DemoIdentity.jks", "DemoIdentityKeyStorePassPhrase", "DemoIdentity", "DemoIdentityPassPhrase", properties);
    }

    public static void initDefaultKeyStore(String string, String string2, String string3, String string4, Properties properties) throws Exception {
        CertGen certGen = new CertGen(true);
        certGen.generateCertificate(properties);
        Certificate[] certificateArray = new Certificate[]{certGen.getSubjectCertificate()};
        PrivateKey privateKey = certGen.getSubjectPrivateKey();
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, string2.toCharArray());
        keyStore.setKeyEntry(string3, privateKey, string4.toCharArray(), certificateArray);
        File file = new File(new File(BootStrap.getWebLogicHome(), "lib"), string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        keyStore.store(fileOutputStream, string2.toCharArray());
        fileOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : null;
        KeyStoreInstall.initDefaultKeyStore(string);
    }
}

