/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class KeyStoreUtils {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static File getFile(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(SecurityLogger.getLocationNullOrEmpty());
        }
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        file = new File(ManagementService.getRuntimeAccess(kernelId).getServer().getRootDirectory(), string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static KeyStore load(File file, String string, String string2) {
        char[] cArray = string == null || string.length() == 0 ? null : string.toCharArray();
        return KeyStoreUtils.load(file, cArray, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static KeyStore load(File file, char[] cArray, String string) {
        if (file == null) {
            throw new IllegalArgumentException(SecurityLogger.getNullFile());
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(string);
        }
        catch (KeyStoreException keyStoreException) {
            SecurityLogger.logLoadKeyStoreKeyStoreException((String)string, (String)keyStoreException.toString());
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SecurityLogger.logLoadKeyStoreFileNotFoundException((String)file.getAbsolutePath(), (String)fileNotFoundException.toString());
            return null;
        }
        try {
            try {
                keyStore.load(fileInputStream, cArray);
            }
            catch (CertificateException certificateException) {
                SecurityLogger.logLoadKeyStoreCertificateException((String)file.getAbsolutePath(), (String)string, (String)certificateException.toString());
                KeyStore keyStore2 = null;
                Object var8_13 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return keyStore2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SecurityLogger.logLoadKeyStoreNoSuchAlgorithmException((String)file.getAbsolutePath(), (String)string, (String)noSuchAlgorithmException.toString());
                KeyStore keyStore3 = null;
                Object var8_14 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return keyStore3;
            }
            catch (IOException iOException) {
                SecurityLogger.logLoadKeyStoreIOException((String)file.getAbsolutePath(), (String)string, (String)iOException.toString());
                KeyStore keyStore4 = null;
                Object var8_15 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return keyStore4;
            }
            Object var8_16 = null;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    public static KeyStore load(File file, String string, String string2, String string3) {
        char[] cArray = string == null || string.length() == 0 ? null : string.toCharArray();
        return KeyStoreUtils.load(file, cArray, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static KeyStore load(File file, char[] cArray, String string, String string2) {
        if (file == null) {
            throw new IllegalArgumentException(SecurityLogger.getNullFile());
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            SecurityLogger.logLoadKeyStoreException((String)string, (String)string2, (String)noSuchProviderException.toString());
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            SecurityLogger.logLoadKeyStoreException((String)string, (String)string2, (String)keyStoreException.toString());
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SecurityLogger.logLoadKeyStoreFileNotFoundException((String)file.getAbsolutePath(), (String)fileNotFoundException.toString());
            return null;
        }
        try {
            try {
                keyStore.load(fileInputStream, cArray);
            }
            catch (CertificateException certificateException) {
                SecurityLogger.logLoadKeyStoreCertificateException((String)file.getAbsolutePath(), (String)string, (String)certificateException.toString());
                KeyStore keyStore2 = null;
                Object var9_15 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return keyStore2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SecurityLogger.logLoadKeyStoreNoSuchAlgorithmException((String)file.getAbsolutePath(), (String)string, (String)noSuchAlgorithmException.toString());
                KeyStore keyStore3 = null;
                Object var9_16 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return keyStore3;
            }
            catch (IOException iOException) {
                SecurityLogger.logLoadKeyStoreIOException((String)file.getAbsolutePath(), (String)string, (String)iOException.toString());
                KeyStore keyStore4 = null;
                Object var9_17 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return keyStore4;
            }
            Object var9_18 = null;
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean store(KeyStore keyStore, File file, String string) {
        if (keyStore == null) {
            throw new IllegalArgumentException(SecurityLogger.getNullKeystore());
        }
        if (file == null) {
            throw new IllegalArgumentException(SecurityLogger.getNullFile());
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(SecurityLogger.getNullOrEmptyPassPhrase());
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SecurityLogger.logStoreKeyStoreFileNotFoundException((String)file.getAbsolutePath(), (String)fileNotFoundException.toString());
            return false;
        }
        try {
            Object var4_5 = null;
            try {
                keyStore.store(fileOutputStream, string.toCharArray());
            }
            catch (KeyStoreException keyStoreException) {
                SecurityLogger.logStoreKeyStoreKeyStoreException((String)file.getAbsolutePath(), (String)keyStore.getType(), (String)keyStoreException.toString());
                boolean bl = false;
                Object var8_14 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            catch (CertificateException certificateException) {
                SecurityLogger.logStoreKeyStoreCertificateException((String)file.getAbsolutePath(), (String)keyStore.getType(), (String)certificateException.toString());
                boolean bl = false;
                Object var8_15 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SecurityLogger.logStoreKeyStoreNoSuchAlgorithmException((String)file.getAbsolutePath(), (String)keyStore.getType(), (String)noSuchAlgorithmException.toString());
                boolean bl = false;
                Object var8_16 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException iOException) {
                SecurityLogger.logStoreKeyStoreIOException((String)file.getAbsolutePath(), (String)keyStore.getType(), (String)iOException.toString());
                boolean bl = false;
                Object var8_17 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return bl;
            }
            Object var8_18 = null;
        }
        catch (Throwable throwable) {
            Object var8_19 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        return true;
    }
}

