/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.Pool;

public final class LDAPConnectionHelper {
    private LDAPConnection conn;
    private Pool pool;
    private boolean isWrite;
    private static final String OBJECTCLASS_ATTR = "objectclass";
    private static LoggerWrapper log = LoggerWrapper.getInstance("DebugEmbeddedLDAP");

    private boolean isDebug() {
        return log.isDebugEnabled();
    }

    private void _debug(String string) {
        if (log.isDebugEnabled()) {
            log.debug(string);
        }
    }

    private void debug(String string, String string2) {
        this._debug("LDAPConnectionHelper." + string + ": " + string2);
    }

    public LDAPConnectionHelper(Pool pool, boolean bl, LoggerWrapper loggerWrapper) {
        String string = "constructor";
        if (loggerWrapper != null) {
            log = loggerWrapper;
        }
        this.pool = pool;
        this.isWrite = bl;
        try {
            this.conn = (LDAPConnection)pool.getInstance();
            if (this.isDebug()) {
                this.debug(string, "conn:" + this.conn);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public void setReadOnly() {
        this.isWrite = false;
    }

    public LDAPConnection getConnection() {
        return this.conn;
    }

    public void done() {
        LDAPCache lDAPCache;
        String string = "done";
        if (this.conn == null) {
            return;
        }
        if (this.isDebug()) {
            this.debug(string, "conn:" + this.conn);
        }
        if (this.isWrite && (lDAPCache = this.conn.getCache()) != null) {
            lDAPCache.flushEntries(null, 0);
        }
        this.pool.returnInstance((Object)this.conn);
        this.conn = null;
    }

    public void error() {
        String string = "error";
        if (this.conn == null) {
            return;
        }
        if (this.isDebug()) {
            this.debug(string, "conn:" + this.conn);
        }
        try {
            this.conn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn = null;
    }

    public boolean ensureDirectoryExists(String string, String string2, String string3, String string4) throws LDAPException {
        String string5 = "ensureDirectoryExists";
        if (this.isDebug()) {
            this.debug(string5, "dn=\"" + string + "\"" + ", objectClass=" + string2 + ", leafAttr=" + string3 + ", leafValue=" + string4);
        }
        try {
            String[] stringArray = new String[]{"1.1"};
            LDAPEntry lDAPEntry = this.conn.read(string, stringArray);
            if (this.isDebug()) {
                this.debug(string5, "directory already exists");
            }
            return false;
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                String[] stringArray = new String[]{"top", string2};
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute(OBJECTCLASS_ATTR, stringArray));
                lDAPAttributeSet.add(new LDAPAttribute(string3, string4));
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                try {
                    this.conn.add(lDAPEntry);
                }
                catch (LDAPException lDAPException2) {
                    if (lDAPException2.getLDAPResultCode() == 68) {
                        if (this.isDebug()) {
                            this.debug(string5, "directory already exists or just created by other component");
                        }
                        return false;
                    }
                    throw lDAPException2;
                }
                if (this.isDebug()) {
                    this.debug(string5, "created directory");
                }
                return true;
            }
            throw lDAPException;
        }
    }

    private static String escapeSearchFilterStringAttr(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    if (bl) {
                        stringBuffer.append("\\2a");
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    continue block7;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block7;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escapeSearchFilterLiteralStringAttr(String string) {
        return LDAPConnectionHelper.escapeSearchFilterStringAttr(string, true);
    }

    public static String escapeSearchFilterWildcardStringAttr(String string) {
        return LDAPConnectionHelper.escapeSearchFilterStringAttr(string, false);
    }

    public static String escapeDNAttr(String string) {
        return string;
    }

    public static byte[] getSingletonByteArrayValue(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute == null) {
            return null;
        }
        Enumeration enumeration = lDAPAttribute.getByteValues();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return (byte[])enumeration.nextElement();
    }

    public static String getSingletonStringValue(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute == null) {
            return null;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return (String)enumeration.nextElement();
    }
}

