/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.management.utils.LDAPServerMBean;

public final class LDAPServerInfo {
    private EmbeddedLDAPMBean embeddedMBean = null;
    private LDAPServerMBean serverMBean = null;
    private boolean embeddedLDAPInit = false;
    private boolean useLocalConnection;
    private String host;
    private int port;
    private boolean SSLEnabled;
    private String principal;
    private String credential;
    private boolean cacheEnabled;
    private int cacheSize;
    private int cacheTTL;
    private int connectionRetryLimit;

    public LDAPServerInfo(boolean bl, String string, int n, boolean bl2, String string2, String string3, boolean bl3, int n2, int n3, int n4) {
        this.useLocalConnection = bl;
        this.host = string;
        this.port = n;
        this.SSLEnabled = bl2;
        this.principal = string2;
        this.credential = string3;
        this.cacheEnabled = bl3;
        this.cacheSize = n2;
        this.cacheTTL = n3;
    }

    public LDAPServerInfo(boolean bl, LDAPServerMBean lDAPServerMBean) {
        this.useLocalConnection = bl;
        this.serverMBean = lDAPServerMBean;
    }

    public LDAPServerInfo(boolean bl, String string, int n, boolean bl2, String string2, int n2, EmbeddedLDAPMBean embeddedLDAPMBean) {
        this.useLocalConnection = bl;
        this.host = string;
        this.port = n;
        this.SSLEnabled = bl2;
        this.principal = string2;
        this.connectionRetryLimit = n2;
        this.embeddedMBean = embeddedLDAPMBean;
    }

    public boolean getUseLocalConnection() {
        return this.useLocalConnection;
    }

    public String getHost() {
        if (this.serverMBean != null) {
            return this.serverMBean.getHost();
        }
        return this.host;
    }

    public int getPort() {
        if (this.serverMBean != null) {
            return this.serverMBean.getPort();
        }
        return this.port;
    }

    public boolean isSSLEnabled() {
        if (this.serverMBean != null) {
            return this.serverMBean.isSSLEnabled();
        }
        return this.SSLEnabled;
    }

    public String getPrincipal() {
        if (this.serverMBean != null) {
            return this.serverMBean.getPrincipal();
        }
        return this.principal;
    }

    public String getCredential() {
        if (this.embeddedMBean != null) {
            return this.embeddedMBean.getCredential();
        }
        if (this.serverMBean != null) {
            return this.serverMBean.getCredential();
        }
        return this.credential;
    }

    public boolean getCacheEnabled() {
        if (this.embeddedMBean != null) {
            return this.embeddedMBean.isCacheEnabled();
        }
        if (this.serverMBean != null) {
            return this.serverMBean.isCacheEnabled();
        }
        return this.cacheEnabled;
    }

    public int getCacheSize() {
        if (this.embeddedMBean != null) {
            return this.embeddedMBean.getCacheSize();
        }
        if (this.serverMBean != null) {
            return this.serverMBean.getCacheSize();
        }
        return this.cacheSize;
    }

    public int getCacheTTL() {
        if (this.embeddedMBean != null) {
            return this.embeddedMBean.getCacheTTL();
        }
        if (this.serverMBean != null) {
            return this.serverMBean.getCacheTTL();
        }
        return this.cacheTTL;
    }

    public int getConnectionRetryLimit() {
        if (this.serverMBean != null) {
            return this.serverMBean.getConnectionRetryLimit();
        }
        return this.connectionRetryLimit;
    }
}

