/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.util.Iterator;
import java.util.Map;
import weblogic.security.utils.Cache;
import weblogic.security.utils.OrderedHashMap;

public class LRUCache
implements Cache {
    private int mMaxSize = 1024;
    private OrderedHashMap mCache = new OrderedHashMap(this.mMaxSize);

    public LRUCache() {
    }

    public LRUCache(int n) {
        this.setMaximumSize(n);
    }

    public int getMaximumSize() {
        return this.mMaxSize;
    }

    public void setMaximumSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Maximum size cannot be negative");
        }
        if (n == 0) {
            this.clear();
        } else {
            while (this.size() > n) {
                this.remove();
            }
        }
        this.mMaxSize = n;
    }

    public int size() {
        return this.mCache.size();
    }

    public Object put(Object object, Object object2) {
        if (this.mCache.size() >= this.mMaxSize) {
            if (this.mMaxSize == 0) {
                return null;
            }
            this.mCache.removeFirst();
        }
        return this.mCache.putLast(object, object2);
    }

    public Object get(Object object) {
        return this.mCache.moveToLast(object);
    }

    public Object lookup(Object object) {
        return this.mCache.get(object);
    }

    public void putOff(Object object) {
        this.mCache.moveToFirst(object);
    }

    public boolean containsKey(Object object) {
        return this.mCache.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mCache.containsValue(object);
    }

    public Map.Entry remove() {
        return this.mCache.removeFirst();
    }

    public Object remove(Object object) {
        return this.mCache.remove(object);
    }

    public void clear() {
        this.mCache.clear();
    }

    public Iterator iterator() {
        return this.mCache.iterator();
    }
}

