/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.AccessController;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.PreMBeanKeyStoreConfiguration;

public class MBeanKeyStoreConfiguration
implements KeyStoreConfiguration {
    private static LoggerWrapper logger = LoggerWrapper.getInstance("SecurityKeyStore");
    private static MBeanKeyStoreConfiguration theInstance;
    private ServerMBean server = ManagementService.getRuntimeAccess(kernelId).getServer();
    private SSLMBean ssl = this.server.getSSL();
    private boolean usePreCfg;
    private boolean valid = true;
    private static final AuthenticatedSubject kernelId;

    public static synchronized MBeanKeyStoreConfiguration getInstance() {
        if (theInstance == null) {
            theInstance = new MBeanKeyStoreConfiguration();
        }
        return theInstance;
    }

    private void debug(String string) {
        logger.debug("MBeanKeyStoreConfiguration: " + string);
    }

    private PreMBeanKeyStoreConfiguration getPreCfg() {
        return PreMBeanKeyStoreConfiguration.getInstance();
    }

    private MBeanKeyStoreConfiguration() {
        if ("CustomIdentityAndCommandLineTrust".equals(this.server.getKeyStores())) {
            this.usePreCfg = true;
            if (logger.isDebugEnabled()) {
                this.debug("constructor - using command line trust config");
            }
            if ("DemoIdentityAndDemoTrust".equals(this.getPreCfg().getKeyStores())) {
                this.valid = false;
                SecurityLogger.logServerDemoCommandLineTrust();
            }
        } else {
            this.usePreCfg = false;
            if (logger.isDebugEnabled()) {
                this.debug("constructor - using mbean trust config");
            }
            if (!this.MBeanAndCommandLineTrustEqual()) {
                this.valid = false;
                SecurityLogger.logServerTrustKeyStoreMisMatchError();
            }
        }
        if (logger.isDebugEnabled()) {
            KeyStoreInfo[] keyStoreInfoArray = new KeyStoreConfigurationHelper(this).getTrustKeyStores();
            for (int i = 0; keyStoreInfoArray != null && i < keyStoreInfoArray.length; ++i) {
                this.debug("constructor - TrustKeyStore[" + i + "]=" + keyStoreInfoArray[i]);
            }
        }
    }

    private boolean MBeanAndCommandLineTrustEqual() {
        PreMBeanKeyStoreConfiguration preMBeanKeyStoreConfiguration = this.getPreCfg();
        if (!preMBeanKeyStoreConfiguration.isExplicitlyConfigured()) {
            return true;
        }
        KeyStoreInfo[] keyStoreInfoArray = new KeyStoreConfigurationHelper(this).getTrustKeyStores();
        KeyStoreInfo[] keyStoreInfoArray2 = new KeyStoreConfigurationHelper(preMBeanKeyStoreConfiguration).getTrustKeyStores();
        if (keyStoreInfoArray == null && keyStoreInfoArray2 == null) {
            return true;
        }
        if (keyStoreInfoArray == null || keyStoreInfoArray2 == null) {
            return false;
        }
        if (keyStoreInfoArray.length != keyStoreInfoArray2.length) {
            return false;
        }
        for (int i = 0; i < keyStoreInfoArray.length; ++i) {
            if (keyStoreInfoArray[i].equals(keyStoreInfoArray2[i])) continue;
            return false;
        }
        return true;
    }

    public String getKeyStores() {
        if (!this.valid) {
            return null;
        }
        if (this.usePreCfg) {
            return this.getPreCfg().getKeyStores();
        }
        return this.server.getKeyStores();
    }

    public String getCustomIdentityKeyStoreFileName() {
        return this.server.getCustomIdentityKeyStoreFileName();
    }

    public String getCustomIdentityKeyStoreType() {
        return this.server.getCustomIdentityKeyStoreType();
    }

    public String getCustomIdentityKeyStorePassPhrase() {
        return this.server.getCustomIdentityKeyStorePassPhrase();
    }

    public String getCustomIdentityAlias() {
        return this.ssl.getServerPrivateKeyAlias();
    }

    public String getCustomIdentityPrivateKeyPassPhrase() {
        return this.ssl.getServerPrivateKeyPassPhrase();
    }

    public String getOutboundPrivateKeyAlias() {
        return this.ssl.getOutboundPrivateKeyAlias();
    }

    public String getOutboundPrivateKeyPassPhrase() {
        return this.ssl.getOutboundPrivateKeyPassPhrase();
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.usePreCfg ? this.getPreCfg().getCustomTrustKeyStoreFileName() : this.server.getCustomTrustKeyStoreFileName();
    }

    public String getCustomTrustKeyStoreType() {
        return this.usePreCfg ? this.getPreCfg().getCustomTrustKeyStoreType() : this.server.getCustomTrustKeyStoreType();
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.usePreCfg ? this.getPreCfg().getCustomTrustKeyStorePassPhrase() : this.server.getCustomTrustKeyStorePassPhrase();
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        return this.usePreCfg ? this.getPreCfg().getJavaStandardTrustKeyStorePassPhrase() : this.server.getJavaStandardTrustKeyStorePassPhrase();
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

