/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class PasswordDigestUtils {
    public static String UTF_8 = "UTF-8";

    private PasswordDigestUtils() {
    }

    public static byte[] passwordDigest(byte[] byArray, String string, byte[] byArray2) throws NoSuchAlgorithmException {
        if (byArray2 == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA-1");
        if (byArray != null) {
            messageDigest.update(byArray);
        }
        try {
            if (string != null) {
                messageDigest.update(string.getBytes(UTF_8));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NoSuchAlgorithmException("Unable to create password digest - UTF-8 encoding required but unavailable: " + unsupportedEncodingException.getMessage());
        }
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        return byArray3;
    }

    public static boolean verifyDigest(byte[] byArray, String string, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException {
        if (byArray2 == null || byArray3 == null) {
            return false;
        }
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA-1");
        if (byArray != null) {
            messageDigest.update(byArray);
        }
        try {
            if (string != null) {
                messageDigest.update(string.getBytes(UTF_8));
            }
            messageDigest.update(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NoSuchAlgorithmException("Unable to create password digest - UTF-8 encoding required but unavailable: " + unsupportedEncodingException.getMessage());
        }
        byte[] byArray4 = messageDigest.digest();
        return Arrays.equals(byArray4, byArray3);
    }

    public static byte[] derivedKey(byte[] byArray, int n, byte[] byArray2) throws NoSuchAlgorithmException {
        if (byArray2 == null) {
            return null;
        }
        if (byArray == null || n <= 0) {
            return null;
        }
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray2);
        messageDigest.update(byArray);
        byte[] byArray3 = messageDigest.digest();
        for (int i = 1; i != n; ++i) {
            messageDigest.update(byArray3);
            byArray3 = messageDigest.digest();
        }
        return byArray3;
    }
}

