/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import weblogic.security.SecurityLogger;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;

public class PreMBeanKeyStoreConfiguration
implements KeyStoreConfiguration {
    private static LoggerWrapper logger = LoggerWrapper.getInstance("SecurityKeyStore");
    private String keystores;
    private static PreMBeanKeyStoreConfiguration theInstance;
    private ClearOrEncryptedService ces;

    public static synchronized PreMBeanKeyStoreConfiguration getInstance() {
        if (theInstance == null) {
            theInstance = new PreMBeanKeyStoreConfiguration();
        }
        return theInstance;
    }

    private void debug(String string) {
        logger.debug("PreMBeanKeyStoreConfiguration: " + string);
    }

    private String getProperty(String string) {
        return System.getProperty(string);
    }

    private PreMBeanKeyStoreConfiguration() {
        KeyStoreInfo[] keyStoreInfoArray;
        boolean bl = false;
        String string = this.getProperty("weblogic.security.TrustKeyStore");
        String string2 = this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
        if ("DemoTrust".equals(string)) {
            this.keystores = "DemoIdentityAndDemoTrust";
        } else if ("JavaStandardTrust".equals(string)) {
            this.keystores = "CustomIdentityAndJavaStandardTrust";
        } else if ("CustomTrust".equals(string)) {
            keyStoreInfoArray = this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
            if (keyStoreInfoArray == null || keyStoreInfoArray.length() < 1) {
                bl = true;
            }
            this.keystores = "CustomIdentityAndCustomTrust";
        } else {
            if (string != null && string.length() > 0) {
                bl = true;
            }
            this.keystores = "DemoIdentityAndDemoTrust";
        }
        if (bl) {
            this.keystores = null;
            SecurityLogger.logServerTrustKeyStoreConfigError();
        }
        if (logger.isDebugEnabled()) {
            this.debug("constructor - explicitly configured=" + this.isExplicitlyConfigured());
            keyStoreInfoArray = new KeyStoreConfigurationHelper(this).getTrustKeyStores();
            for (int i = 0; keyStoreInfoArray != null && i < keyStoreInfoArray.length; ++i) {
                this.debug("constructor - TrustKeyStore[" + i + "]=" + keyStoreInfoArray[i]);
            }
        }
        this.ces = new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService());
    }

    public boolean isExplicitlyConfigured() {
        if (this.getProperty("weblogic.security.TrustKeyStore") != null) {
            return true;
        }
        if (this.getProperty("weblogic.security.CustomTrustKeyStoreFileName") != null) {
            return true;
        }
        if (this.getProperty("weblogic.security.CustomTrustKeyStoreType") != null) {
            return true;
        }
        if (this.getProperty("weblogic.security.CustomTrustKeyStorePassPhrase") != null) {
            return true;
        }
        return this.getProperty("weblogic.security.JavaStandardTrustKeyStorePassPhrase") != null;
    }

    public String getKeyStores() {
        return this.keystores;
    }

    public String getCustomIdentityKeyStoreFileName() {
        return null;
    }

    public String getCustomIdentityKeyStoreType() {
        return null;
    }

    public String getCustomIdentityKeyStorePassPhrase() {
        return null;
    }

    public String getCustomIdentityAlias() {
        return null;
    }

    public String getCustomIdentityPrivateKeyPassPhrase() {
        return null;
    }

    public String getOutboundPrivateKeyAlias() {
        return null;
    }

    public String getOutboundPrivateKeyPassPhrase() {
        return null;
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
    }

    public String getCustomTrustKeyStoreType() {
        return this.getProperty("weblogic.security.CustomTrustKeyStoreType");
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.decryptValue(this.getProperty("weblogic.security.CustomTrustKeyStorePassPhrase"));
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        return this.decryptValue(this.getProperty("weblogic.security.JavaStandardTrustKeyStorePassPhrase"));
    }

    private String decryptValue(String string) {
        return this.ces == null || string == null ? string : this.ces.decrypt(string);
    }
}

