/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import com.bea.common.security.SecurityLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Map;
import weblogic.management.security.ResourceIdInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.providers.utils.ResourceUtils;
import weblogic.security.spi.Resource;

public final class ResourceUtils {
    public static String[] listRegisteredResourceTypes() {
        return weblogic.security.providers.utils.ResourceUtils.listRegisteredResourceTypes();
    }

    public static void registerResourceType(AuthenticatedSubject authenticatedSubject, ResourceIdInfo resourceIdInfo) throws IllegalArgumentException {
        if (resourceIdInfo == null) {
            throw new IllegalArgumentException(SecurityLogger.getNoResourceType());
        }
        Class<weblogic.security.providers.utils.ResourceIdInfo> clazz = weblogic.security.providers.utils.ResourceIdInfo.class;
        weblogic.security.providers.utils.ResourceIdInfo resourceIdInfo2 = (weblogic.security.providers.utils.ResourceIdInfo)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{ResourceIdInfo.class, clazz}, (InvocationHandler)new InvocationHandlerImpl(resourceIdInfo));
        weblogic.security.providers.utils.ResourceUtils.registerResourceType((Principal)authenticatedSubject, (weblogic.security.providers.utils.ResourceIdInfo)resourceIdInfo2);
    }

    public static String getResourceIdFromMap(Map map) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getResourceIdFromMap((Map)map);
    }

    public static Map getMapFromResourceId(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getMapFromResourceId((String)string);
    }

    public static String[] getResourceKeyNames(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getResourceKeyNames((String)string);
    }

    public static String[] getParentResourceIds(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getParentResourceIds((String)string);
    }

    public static String getResourceTypeNameFilter(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getResourceTypeNameFilter((String)string);
    }

    public static SearchHelper getApplicationSearchHelper(String string) throws IllegalArgumentException {
        return (SearchHelper)Proxy.newProxyInstance(SearchHelper.class.getClassLoader(), new Class[]{ResourceUtils.SearchHelper.class, SearchHelper.class}, (InvocationHandler)new InvocationHandlerImpl(weblogic.security.providers.utils.ResourceUtils.getApplicationSearchHelper((String)string)));
    }

    public static SearchHelper getComponentSearchHelper(String string, String string2, String string3) throws IllegalArgumentException {
        return (SearchHelper)Proxy.newProxyInstance(SearchHelper.class.getClassLoader(), new Class[]{ResourceUtils.SearchHelper.class, SearchHelper.class}, (InvocationHandler)new InvocationHandlerImpl(weblogic.security.providers.utils.ResourceUtils.getComponentSearchHelper((String)string, (String)string2, (String)string3)));
    }

    public static SearchHelper getChildSearchHelper(String string) throws IllegalArgumentException {
        return (SearchHelper)Proxy.newProxyInstance(SearchHelper.class.getClassLoader(), new Class[]{ResourceUtils.SearchHelper.class, SearchHelper.class}, (InvocationHandler)new InvocationHandlerImpl(weblogic.security.providers.utils.ResourceUtils.getChildSearchHelper((String)string)));
    }

    public static ResourceIdInfo getResourceIdInfo(String string) {
        weblogic.security.providers.utils.ResourceIdInfo resourceIdInfo = weblogic.security.providers.utils.ResourceUtils.getResourceIdInfo((String)string);
        return resourceIdInfo == null ? null : (ResourceIdInfo)Proxy.newProxyInstance(ResourceIdInfo.class.getClassLoader(), new Class[]{weblogic.security.providers.utils.ResourceIdInfo.class, ResourceIdInfo.class}, (InvocationHandler)new InvocationHandlerImpl(resourceIdInfo));
    }

    public static SearchHelper getRepeatingActionsSearchHelper(String string) throws IllegalArgumentException {
        ResourceUtils.SearchHelper searchHelper = weblogic.security.providers.utils.ResourceUtils.getRepeatingActionsSearchHelper((String)string);
        return searchHelper == null ? null : (SearchHelper)Proxy.newProxyInstance(SearchHelper.class.getClassLoader(), new Class[]{ResourceUtils.SearchHelper.class, SearchHelper.class}, (InvocationHandler)new InvocationHandlerImpl(searchHelper));
    }

    public static String getResourceIdNameFilter(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getResourceIdNameFilter((String)string);
    }

    public static Resource getScopedResource(String string) throws IllegalArgumentException {
        return weblogic.security.providers.utils.ResourceUtils.getScopedResource((String)string);
    }

    public static String escapeSearchChars(String string) {
        return weblogic.security.providers.utils.ResourceUtils.escapeSearchChars((String)string);
    }

    public static String unescapeChars(String string) {
        return weblogic.security.providers.utils.ResourceUtils.unescapeChars((String)string);
    }

    public static interface SearchHelper {
        public String getNameFilter();

        public boolean isValid(String var1);
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private Object delegate;

        private InvocationHandlerImpl(Object object) {
            this.delegate = object;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            return method.invoke(this.delegate, objectArray);
        }
    }
}

