/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import weblogic.security.MessageDigest;
import weblogic.security.WLMessageDigest;
import weblogic.security.utils.InputStreamCloner;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLSetup;

public final class SSLCertUtility {
    public static X509Certificate toJavaX509(Certificate certificate) {
        try {
            return X509Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static X509Certificate[] toJavaX509(Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = SSLCertUtility.toJavaX509(certificateArray[i]);
            if (x509CertificateArray[i] != null) continue;
            return null;
        }
        return x509CertificateArray;
    }

    public static java.security.cert.X509Certificate[] toJavaX5092(Certificate[] certificateArray) throws IOException {
        if (certificateArray != null) {
            if (certificateArray instanceof java.security.cert.X509Certificate[]) {
                return (java.security.cert.X509Certificate[])certificateArray;
            }
            try {
                java.security.cert.X509Certificate[] x509CertificateArray = new java.security.cert.X509Certificate[certificateArray.length];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                for (int i = 0; i < certificateArray.length; ++i) {
                    x509CertificateArray[i] = (java.security.cert.X509Certificate)(certificateArray[i] instanceof java.security.cert.X509Certificate ? certificateArray[i] : certificateFactory.generateCertificate(new ByteArrayInputStream(certificateArray[i].getEncoded())));
                }
                return x509CertificateArray;
            }
            catch (java.security.cert.CertificateException certificateException) {
                SSLSetup.info(certificateException, "Exception processing certificates: " + certificateException.getMessage());
            }
        }
        return null;
    }

    public static java.security.cert.X509Certificate toX509(Certificate certificate) throws java.security.cert.CertificateException {
        if (certificate == null) {
            return null;
        }
        if (certificate instanceof java.security.cert.X509Certificate) {
            return (java.security.cert.X509Certificate)certificate;
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
    }

    public static java.security.cert.X509Certificate toJavaX509(X509Certificate x509Certificate) throws java.security.cert.CertificateException, IOException, CertificateEncodingException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate.getEncoded()));
    }

    public static java.security.cert.X509Certificate[] toJavaX509(X509Certificate[] x509CertificateArray) throws java.security.cert.CertificateException, IOException, CertificateEncodingException {
        java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < x509CertificateArray2.length; ++i) {
            x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
        }
        return x509CertificateArray2;
    }

    public static java.security.cert.X509Certificate getPeerLeafCert(SSLSocket sSLSocket) {
        return SSLCertUtility.getPeerLeafCert(sSLSocket.getSession());
    }

    public static java.security.cert.X509Certificate getPeerLeafCert(SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            return certificateArray == null || certificateArray.length == 0 ? null : SSLCertUtility.toX509(certificateArray[0]);
        }
        catch (java.security.cert.CertificateException certificateException) {
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        return null;
    }

    public static java.security.cert.X509Certificate[] getPeerCertChain(SSLSocket sSLSocket) {
        try {
            return SSLCertUtility.toJavaX5092(sSLSocket.getSession().getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static com.rsa.certj.cert.X509Certificate toCertJ(java.security.cert.X509Certificate x509Certificate) throws java.security.cert.CertificateEncodingException, com.rsa.certj.cert.CertificateException {
        return new com.rsa.certj.cert.X509Certificate(x509Certificate.getEncoded(), 0, 0);
    }

    public static X500Name getSubjectX500Name(java.security.cert.X509Certificate x509Certificate) throws java.security.cert.CertificateEncodingException, com.rsa.certj.cert.CertificateException {
        return SSLCertUtility.toCertJ(x509Certificate).getSubjectName();
    }

    public static String getSubjectDNValue(X500Name x500Name, int n) throws java.security.cert.CertificateEncodingException, com.rsa.certj.cert.CertificateException, NameException {
        AttributeValueAssertion attributeValueAssertion = x500Name.getAttribute(n);
        return attributeValueAssertion == null ? null : attributeValueAssertion.getStringAttribute();
    }

    public static String getSubjectDNValue(java.security.cert.X509Certificate x509Certificate, int n) throws java.security.cert.CertificateEncodingException, com.rsa.certj.cert.CertificateException, NameException {
        return SSLCertUtility.getSubjectDNValue(SSLCertUtility.getSubjectX500Name(x509Certificate), n);
    }

    public static String getSubjectDNCommonName(java.security.cert.X509Certificate x509Certificate) throws java.security.cert.CertificateEncodingException, com.rsa.certj.cert.CertificateException, NameException {
        return SSLCertUtility.getSubjectDNValue(x509Certificate, 0);
    }

    public static java.security.cert.X509Certificate[] inputCertificateChain(SSLContextWrapper sSLContextWrapper, InputStream inputStream) throws IOException, KeyManagementException {
        InputStreamCloner inputStreamCloner = new InputStreamCloner(inputStream);
        try {
            return sSLContextWrapper.inputCertChain(inputStreamCloner.cloneStream());
        }
        catch (IOException iOException) {
            throw new KeyManagementException(iOException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                java.security.cert.X509Certificate[] x509CertificateArray = new java.security.cert.X509Certificate[]{(java.security.cert.X509Certificate)certificateFactory.generateCertificate(inputStreamCloner.cloneStream())};
                return x509CertificateArray;
            }
            catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            }
            catch (java.security.cert.CertificateException certificateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw keyManagementException;
        }
    }

    public static Collection getX509Certificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof java.security.cert.X509Certificate)) continue;
            arrayList.add(certificate);
        }
        return arrayList;
    }

    public static byte[] getFingerprint(Certificate certificate) throws java.security.cert.CertificateEncodingException {
        MessageDigest messageDigest = WLMessageDigest.getInstance((String)"MD5");
        messageDigest.update(certificate.getEncoded());
        return messageDigest.digest();
    }

    public static String getCommonName(java.security.cert.X509Certificate x509Certificate) {
        String string;
        int n;
        String string2 = null;
        if (x509Certificate != null && (n = (string = x509Certificate.getSubjectX500Principal().getName()).indexOf("CN=")) >= 0) {
            boolean bl = false;
            int n2 = n + 3;
            int n3 = string.indexOf(44, n2);
            while (n3 > 0 && string.charAt(n3 - 1) == '\\') {
                bl = true;
                n3 = string.indexOf(",", n3 + 1);
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            string2 = string.substring(n2, n3);
            if (bl) {
                int n4 = string2.length();
                StringBuffer stringBuffer = new StringBuffer(n4);
                for (int i = 0; i < n4; ++i) {
                    char c = string2.charAt(i);
                    if (c == '\\') {
                        if (++i == n4) break;
                        c = string2.charAt(i);
                    }
                    stringBuffer.append(c);
                }
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    public static String getCommonName(SSLSession sSLSession) {
        return SSLCertUtility.getCommonName(SSLCertUtility.getPeerLeafCert(sSLSession));
    }

    public static Collection getDNSSubjAltNames(SSLSession sSLSession) {
        java.security.cert.X509Certificate x509Certificate = SSLCertUtility.getPeerLeafCert(sSLSession);
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            return collection;
        }
        if (collection == null) {
            return collection;
        }
        Vector<String> vector = new Vector<String>();
        Iterator<List<?>> iterator = collection.iterator();
        List<?> list = null;
        ListIterator<?> listIterator = null;
        Object var7_8 = null;
        Integer n = null;
        String string = null;
        while (iterator.hasNext()) {
            list = iterator.next();
            listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                var7_8 = listIterator.next();
                if (!(var7_8 instanceof Integer) || (n = (Integer)var7_8) != 2 || !listIterator.hasNext()) continue;
                string = (String)listIterator.next();
                vector.add(string);
            }
        }
        return vector;
    }
}

