/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.util.HashMap;
import java.util.Map;

public final class SSLCipherUtility {
    private static final Map cipherSuitesMap = SSLCipherUtility.initCipherSuites();

    public static int getKeySize(String string) {
        CipherSuite cipherSuite = SSLCipherUtility.getCipherSuite(string);
        return cipherSuite == null ? -1 : cipherSuite.getKeySize();
    }

    public static String[] removeNullCipherSuites(String[] stringArray) {
        int n = SSLCipherUtility.countNullCipherSuites(stringArray);
        if (n == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (SSLCipherUtility.isNullCipherSuite(stringArray[i])) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray2;
    }

    public static void normalizeNames(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = SSLCipherUtility.normalizeName(stringArray[i]);
            }
        }
    }

    private static final String normalizeName(String string) {
        if (!string.startsWith("TLS_")) {
            if (string.startsWith("SSL_")) {
                string = string.substring(4);
            }
            string = "TLS_" + string;
        }
        return string;
    }

    private static final boolean isNullCipherSuite(String string) {
        return string.equals("SSL_NULL_WITH_NULL_NULL") || string.equals("TLS_NULL_WITH_NULL_NULL");
    }

    private static final int countNullCipherSuites(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!SSLCipherUtility.isNullCipherSuite(stringArray[i])) continue;
                ++n;
            }
        }
        return n;
    }

    private static final CipherSuite getCipherSuite(String string) {
        return (CipherSuite)cipherSuitesMap.get(SSLCipherUtility.normalizeName(string));
    }

    private static final Map initCipherSuites() {
        CipherSuite[] cipherSuiteArray = new CipherSuite[]{new CipherSuite("TLS_NULL_WITH_NULL_NULL", 0, 0, true), new CipherSuite("TLS_RSA_WITH_NULL_MD5", 1, 0, true), new CipherSuite("TLS_RSA_WITH_NULL_SHA", 2, 0, true), new CipherSuite("TLS_RSA_WITH_RC4_128_MD5", 4, 128, false), new CipherSuite("TLS_RSA_WITH_RC4_128_SHA", 5, 128, false), new CipherSuite("TLS_RSA_WITH_DES_CBC_SHA", 9, 56, true), new CipherSuite("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10, 168, false), new CipherSuite("TLS_RSA_EXPORT_WITH_RC4_40_MD5", 3, 40, true), new CipherSuite("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, 40, true), new CipherSuite("TLS_RSA_EXPORT_WITH_DES_40_CBC_SHA", 8, 40, true), new CipherSuite("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA", 98, 56, true), new CipherSuite("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA", 100, 56, true), new CipherSuite("TLS_DHE_DSS_WITH_DES_CBC_SHA", 18, 56, false), new CipherSuite("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, 168, false), new CipherSuite("TLS_DHE_DSS_WITH_RC4_128_SHA", 102, 128, false), new CipherSuite("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, 40, true), new CipherSuite("TLS_DHE_DSS_EXPORT_WITH_DES_40_CBC_SHA", 17, 40, true), new CipherSuite("TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", 99, 56, true), new CipherSuite("TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", 101, 56, true), new CipherSuite("TLS_DH_anon_WITH_RC4_128_MD5", 24, 128, false), new CipherSuite("TLS_DH_anon_WITH_DES_CBC_SHA", 26, 56, false), new CipherSuite("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, 168, false), new CipherSuite("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, 40, true), new CipherSuite("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, 40, true), new CipherSuite("TLS_DH_anon_EXPORT_WITH_DES_40_CBC_SHA", 25, 40, true), new CipherSuite("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 72, 128, false), new CipherSuite("TLS_ECDH_ECDSA_WITH_DES_CBC_SHA", 73, 56, false), new CipherSuite("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 74, 168, false), new CipherSuite("TLS_ECDH_ECDSA_EXPORT_WITH_RC4_40_SHA", 65412, 40, true), new CipherSuite("TLS_ECDH_ECDSA_EXPORT_WITH_RC4_56_SHA", 65413, 56, true), new CipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA", 47, 128, false), new CipherSuite("TLS_RSA_WITH_AES_256_CBC_SHA", 53, 256, false)};
        HashMap<String, CipherSuite> hashMap = new HashMap<String, CipherSuite>(cipherSuiteArray.length);
        for (int i = 0; i < cipherSuiteArray.length; ++i) {
            hashMap.put(cipherSuiteArray[i].name, cipherSuiteArray[i]);
        }
        return hashMap;
    }

    private static final class CipherSuite {
        private String name;
        private int tag;
        private int keySize;
        private boolean exportable;

        public CipherSuite(String string, int n, int n2, boolean bl) {
            this.name = string;
            this.tag = n;
            this.keySize = n2;
            this.exportable = bl;
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public final int getKeySize() {
            return this.keySize;
        }

        public final boolean isExportable() {
            return this.exportable;
        }
    }
}

