/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.utils.SSLHostnameVerifier;
import weblogic.security.utils.SSLTruster;

public interface SSLContextDelegate {
    public static final int TLS1_ONLY = 0;
    public static final int SSL3_ONLY = 1;
    public static final int SSL3_TLS1 = 2;
    public static final int V2HELLO_SSL3_TLS1 = 3;
    public static final int V2HELLO_SSL3 = 4;
    public static final int CONSTRAINTS_OFF = 0;
    public static final int CONSTRAINTS_STRONG = 1;
    public static final int CONSTRAINTS_STRICT = 2;

    public void addTrustedCA(X509Certificate var1) throws CertificateException;

    public X509Certificate[] getTrustedCAs();

    public PrivateKey inputPrivateKey(InputStream var1, char[] var2) throws KeyManagementException;

    public X509Certificate[] inputCertChain(InputStream var1) throws KeyManagementException;

    public void loadLocalIdentity(InputStream var1, char[] var2) throws KeyManagementException;

    public void loadTrustedCerts(InputStream var1) throws CertificateException, KeyManagementException;

    public void addIdentity(X509Certificate[] var1, PrivateKey var2);

    public boolean doKeysMatch(PublicKey var1, PrivateKey var2) throws KeyManagementException;

    public void setExportRefreshCount(int var1);

    public void setProtocolVersion(int var1) throws IllegalArgumentException;

    public SSLServerSocketFactory getSSLServerSocketFactory();

    public SSLSocketFactory getSSLSocketFactory();

    public void setTrustManager(SSLTruster var1);

    public SSLTruster getTrustManager();

    public void setHostnameVerifier(SSLHostnameVerifier var1);

    public SSLHostnameVerifier getHostnameVerifier();

    public void enforceConstraints(int var1);
}

