/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import utils.ValidateCertChain;
import weblogic.kernel.T3SrvrLogger;
import weblogic.logging.Loggable;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.CommandLine;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.ServerChannel;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLEngineFactory;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SSL.jsseadapter.JaSSLEngineFactoryBuilder;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.KeyManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.KeyStoreUtils;
import weblogic.security.utils.MBeanKeyStoreConfiguration;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLTrustValidator;
import weblogic.server.channels.ServerChannelImpl;

public final class SSLContextManager {
    private static final int ONE_DAY = 86400000;
    private static final int WARNING_PERIOD = 30;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static SSLSocketFactory defaultFactory = null;
    private static SSLSocketFactory defaultNioFactory = null;
    private static SSLContextWrapper defaultContext = null;
    private static Map channelContexts = new HashMap();
    private static Map sslIdentities = new Hashtable();
    private static X509Certificate[] trustedCACerts = null;
    private static char[] keyFilePwd = null;
    private boolean debug = SSLSetup.isDebugEnabled(3);
    private RuntimeAccess runtimeAccess = null;

    public static SSLServerSocketFactory getSSLServerSocketFactory(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        return sSLContextWrapper.getSSLServerSocketFactory();
    }

    public static SSLServerSocketFactory getSSLNioServerSocketFactory(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        return sSLContextWrapper.getSSLNioServerSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        return sSLContextWrapper.getSSLSocketFactory();
    }

    public static SSLSocketFactory getSSLNioSocketFactory(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        return sSLContextWrapper.getSSLNioSocketFactory();
    }

    public static SSLClientInfo getChannelSSLClientInfo(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
        SSLIdentity sSLIdentity = sSLContextManager.getServerSSLIdentity(((ServerChannelImpl)serverChannel).getConfig(), sSLContextWrapper, true);
        SSLClientInfo sSLClientInfo = new SSLClientInfo();
        sSLClientInfo.loadLocalIdentity(sSLIdentity.certChain, sSLIdentity.key);
        return sSLClientInfo;
    }

    public static SSLClientInfo getNioChannelSSLClientInfo(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
        SSLIdentity sSLIdentity = sSLContextManager.getServerSSLIdentity(((ServerChannelImpl)serverChannel).getConfig(), sSLContextWrapper, true);
        SSLClientInfo sSLClientInfo = new SSLClientInfo(true);
        sSLClientInfo.loadLocalIdentity(sSLIdentity.certChain, sSLIdentity.key);
        return sSLClientInfo;
    }

    public static synchronized SSLSocketFactory getDefaultSSLSocketFactory(AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        if (defaultFactory == null) {
            SSLContextWrapper sSLContextWrapper = SSLContextManager.getDefaultServerSSLContext(authenticatedSubject);
            defaultFactory = sSLContextWrapper.getSSLSocketFactory();
        } else {
            ManagementService.getRuntimeAccess(authenticatedSubject);
        }
        return defaultFactory;
    }

    public static synchronized SSLSocketFactory getDefaultNioSSLSocketFactory(AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        if (defaultNioFactory == null) {
            SSLContextWrapper sSLContextWrapper = SSLContextManager.getDefaultServerSSLContext(authenticatedSubject);
            defaultNioFactory = sSLContextWrapper.getSSLNioSocketFactory();
        } else {
            ManagementService.getRuntimeAccess(authenticatedSubject);
        }
        return defaultNioFactory;
    }

    public static SSLSocketFactory getSSLSocketFactory(AuthenticatedSubject authenticatedSubject, TrustManager trustManager) throws ConfigurationException, CertificateException {
        SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
        SSLContextWrapper sSLContextWrapper = sSLContextManager.createServerSSLContext(null);
        sSLContextWrapper.getTrustManager().setTrustManager(trustManager);
        return sSLContextWrapper.getSSLSocketFactory();
    }

    public static SSLSocketFactory getSSLNioSocketFactory(AuthenticatedSubject authenticatedSubject, TrustManager trustManager) throws ConfigurationException, CertificateException {
        SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
        SSLContextWrapper sSLContextWrapper = sSLContextManager.createServerSSLContext(null);
        sSLContextWrapper.getTrustManager().setTrustManager(trustManager);
        return sSLContextWrapper.getSSLNioSocketFactory();
    }

    public static synchronized X509Certificate[] getServerTrustedCAs() throws ConfigurationException, CertificateException {
        if (trustedCACerts != null) {
            X509Certificate[] x509CertificateArray = new X509Certificate[trustedCACerts.length];
            System.arraycopy(trustedCACerts, 0, x509CertificateArray, 0, trustedCACerts.length);
            return x509CertificateArray;
        }
        return SSLContextManager.getDefaultServerSSLContext(kernelId).getTrustedCAs();
    }

    public static synchronized void clearSSLContextCache() {
        trustedCACerts = null;
        defaultFactory = null;
        defaultNioFactory = null;
        defaultContext = null;
        channelContexts.clear();
        sslIdentities.clear();
    }

    public static X509Certificate[] getTrustedCAs(KeyStoreInfo[] keyStoreInfoArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; keyStoreInfoArray != null && i < keyStoreInfoArray.length; ++i) {
            Collection collection = SSLContextManager.getTrustedCAs(keyStoreInfoArray[i].getFileName(), keyStoreInfoArray[i].getType(), keyStoreInfoArray[i].getPassPhrase());
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    public static final SSLEngineFactory getSSLEngineFactory(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        SSLContextWrapper sSLContextWrapper = SSLContextManager.getChannelSSLContext(serverChannel, authenticatedSubject);
        return JaSSLEngineFactoryBuilder.getFactoryInstance(sSLContextWrapper);
    }

    private static synchronized SSLContextWrapper getDefaultServerSSLContext(AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        if (defaultContext == null) {
            SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
            defaultContext = sSLContextManager.createServerSSLContext(null);
        } else {
            ManagementService.getRuntimeAccess(authenticatedSubject);
        }
        return defaultContext;
    }

    private static synchronized SSLContextWrapper getChannelSSLContext(ServerChannel serverChannel, AuthenticatedSubject authenticatedSubject) throws ConfigurationException, CertificateException {
        boolean bl = SSLSetup.isDebugEnabled(3);
        String string = ((ServerChannelImpl)serverChannel).getConfig().getName();
        SSLContextWrapper sSLContextWrapper = (SSLContextWrapper)channelContexts.get(string);
        if (sSLContextWrapper == null) {
            if (bl) {
                SSLSetup.info("SSLContextManager: initializing SSL context for channel " + string);
            }
            SSLContextManager sSLContextManager = new SSLContextManager(authenticatedSubject);
            sSLContextWrapper = sSLContextManager.createServerSSLContext(serverChannel);
            channelContexts.put(string, sSLContextWrapper);
        } else {
            if (bl) {
                SSLSetup.info("SSLContextManager: reusing SSL context of channel " + string);
            }
            ManagementService.getRuntimeAccess(authenticatedSubject);
        }
        return sSLContextWrapper;
    }

    private SSLContextManager(AuthenticatedSubject authenticatedSubject) {
        SSLContextManager.checkLicense();
        if (authenticatedSubject == null) {
            throw new NullPointerException("null privileged subject");
        }
        this.runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private SSLContextWrapper createServerSSLContext(ServerChannel serverChannel) throws ConfigurationException, CertificateException {
        boolean bl;
        X509Certificate[] x509CertificateArray;
        SSLIdentity sSLIdentity;
        NetworkAccessPointMBean networkAccessPointMBean;
        SSLMBean sSLMBean;
        SSLContextWrapper sSLContextWrapper;
        block12: {
            sSLContextWrapper = SSLContextWrapper.getInstance();
            sSLMBean = this.runtimeAccess.getServer().getSSL();
            if (sSLMBean != null) {
                boolean bl2 = sSLMBean.isAllowUnencryptedNullCipher();
                sSLContextWrapper.enableUnencryptedNullCipher(bl2);
            }
            networkAccessPointMBean = serverChannel == null ? null : ((ServerChannelImpl)serverChannel).getConfig();
            sSLIdentity = null;
            try {
                sSLIdentity = this.getServerSSLIdentity(networkAccessPointMBean, sSLContextWrapper, false);
            }
            catch (ConfigurationException configurationException) {
                if (this.debug) {
                    SSLSetup.info(configurationException, "SSLContextManager: couldnot get server SSL identity");
                }
                if (serverChannel == null) break block12;
                throw configurationException;
            }
        }
        if (sSLIdentity != null) {
            this.checkIdentity(sSLContextWrapper, sSLIdentity);
            sSLContextWrapper.addIdentity(sSLIdentity.certChain, sSLIdentity.key);
        }
        if ((x509CertificateArray = trustedCACerts) == null) {
            x509CertificateArray = this.getServerTrustedCAs(sSLContextWrapper);
            Object object = SSLContextManager.class;
            // MONITORENTER : weblogic.security.utils.SSLContextManager.class
            trustedCACerts = x509CertificateArray;
            // MONITOREXIT : object
            if (x509CertificateArray != null && x509CertificateArray.length > 0 && this.runtimeAccess.getDomain().isProductionModeEnabled() && (object = SSLContextManager.findDemoCert(x509CertificateArray)) != null) {
                SecurityLogger.logDemoTrustCertificateUsed((String)((Certificate)object).toString());
            }
        }
        boolean bl3 = bl = networkAccessPointMBean != null ? networkAccessPointMBean.isClientCertificateEnforced() : sSLMBean.isClientCertificateEnforced();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (bl) {
                SSLContextManager.fail(SecurityLogger.logClientCertEnforcedNoTrustedCALoggable(), null);
            }
            SecurityLogger.logNoTrustedCAsLoaded();
        }
        if (x509CertificateArray != null) {
            sSLContextWrapper.addTrustedCA(x509CertificateArray);
        }
        SSLTrustValidator sSLTrustValidator = sSLContextWrapper.getTrustManager();
        sSLTrustValidator.setPeerCertsRequired(bl);
        sSLTrustValidator.setAllowOverride(false);
        sSLContextWrapper.setTrustManager(sSLTrustValidator);
        int n = sSLMBean.getExportKeyLifespan();
        sSLContextWrapper.setExportRefreshCount(n);
        T3SrvrLogger.logExportableKeyMaxLifespan((int)n);
        return sSLContextWrapper;
    }

    private X509Certificate[] getServerTrustedCAs(SSLContextWrapper sSLContextWrapper) {
        if (this.usePerServerKeyStores()) {
            KeyStoreInfo[] keyStoreInfoArray = new KeyStoreConfigurationHelper(MBeanKeyStoreConfiguration.getInstance()).getTrustKeyStores();
            return SSLContextManager.getTrustedCAs(keyStoreInfoArray);
        }
        return this.getOldConfigServerTrustedCAs(sSLContextWrapper);
    }

    private static void checkLicense() {
        SSLSetup.getLicenseLevel();
    }

    private final boolean usePerServerKeyStores() {
        String string = this.runtimeAccess.getServer().getSSL().getIdentityAndTrustLocations();
        return "KeyStores".equals(string);
    }

    private static X509Certificate findDemoCert(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (!SSLContextManager.isDemoCertificate(x509CertificateArray[i])) continue;
                return x509CertificateArray[i];
            }
        }
        return null;
    }

    private static boolean isDemoCertificate(X509Certificate x509Certificate) {
        String string = x509Certificate.getIssuerDN().getName();
        int n = string.lastIndexOf("CN=CACERT");
        return n >= 0 && (n + "CN=CACERT".length() >= string.length() || !Character.isLetter(string.charAt(n + "CN=CACERT".length())));
    }

    private void checkIdentity(SSLContextWrapper sSLContextWrapper, SSLIdentity sSLIdentity) throws ConfigurationException {
        X509Certificate x509Certificate;
        X509Certificate[] x509CertificateArray = sSLIdentity.certChain;
        PrivateKey privateKey = sSLIdentity.key;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            String string = T3SrvrLogger.logNoCertificatesSpecified();
            throw new ConfigurationException(new Loggable(string, null).getMessageText());
        }
        Certificate certificate = null;
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                certificate = x509CertificateArray[i];
                ((X509Certificate)certificate).checkValidity();
                if (i + 1 < x509CertificateArray.length) {
                    certificate.verify(x509CertificateArray[i + 1].getPublicKey());
                } else if (((Object)((X509Certificate)certificate).getIssuerDN()).equals(((X509Certificate)certificate).getSubjectDN())) {
                    certificate.verify(certificate.getPublicKey());
                }
                long l = (((X509Certificate)certificate).getNotAfter().getTime() - System.currentTimeMillis()) / 86400000L;
                if (l > 30L) continue;
                T3SrvrLogger.logCertificateExpiresSoon((long)l, (String)certificate.toString());
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            SSLContextManager.fail(SecurityLogger.logIdentityCertificateExpiredLoggable((String)certificate.toString()), certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            SSLContextManager.fail(SecurityLogger.logIdentityCertificateNotYetValidLoggable((String)certificate.toString()), certificateNotYetValidException);
        }
        catch (SignatureException signatureException) {
            SSLContextManager.fail(SecurityLogger.logIdentityCertificateNotValidLoggable((String)certificate.toString()), signatureException);
        }
        catch (Exception exception) {
            SSLContextManager.fail(SecurityLogger.logUnableToVerifyIdentityCertificateLoggable((String)certificate.toString()), exception);
        }
        if (this.runtimeAccess.getDomain().isProductionModeEnabled() && (x509Certificate = SSLContextManager.findDemoCert(x509CertificateArray)) != null) {
            SecurityLogger.logDemoIdentityCertificateUsed((String)x509Certificate.toString());
        }
        try {
            if (!sSLContextWrapper.doKeysMatch(x509CertificateArray[0].getPublicKey(), privateKey)) {
                SSLContextManager.fail(SecurityLogger.logCertificateAndPrivateKeyMismatchedLoggable(), null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            if (this.debug) {
                SSLSetup.info(keyManagementException, "Key match check failed with exception, may not have access to private key data to perform this check");
            }
            SecurityLogger.logCantCheckKeyMatch();
        }
        if (!"RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            SecurityLogger.logUnsupportedKeyAlgorithm((String)privateKey.getAlgorithm());
        }
    }

    private static Collection getTrustedCAs(String string, String string2, char[] cArray) {
        File file;
        boolean bl = SSLSetup.isDebugEnabled(3);
        File file2 = file = string == null ? null : new File(string);
        if (file != null) {
            SecurityLogger.logLoadTrustedCAsFromKeyStore((String)file.getAbsolutePath(), (String)string2);
            KeyStore keyStore = KeyStoreUtils.load(file, cArray, string2);
            if (keyStore != null) {
                try {
                    Collection collection = SSLCertUtility.getX509Certificates(keyStore);
                    if (bl) {
                        SSLSetup.info("SSLContextManager: loaded " + collection.size() + " trusted CAs from " + file.getAbsolutePath());
                        SSLContextManager.debugCerts(collection);
                    }
                    return collection;
                }
                catch (KeyStoreException keyStoreException) {
                    SecurityLogger.logKeyStoreException((String)string, (String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
                }
            } else {
                SecurityLogger.logTrustedCAFromKeyStoreLoadFailed((String)file.getAbsolutePath(), (String)string2);
            }
        } else {
            SecurityLogger.logTrustedCAKeyStoreNotFound((String)string, (String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
        }
        return null;
    }

    private SSLIdentity getServerSSLIdentity(NetworkAccessPointMBean networkAccessPointMBean, SSLContextWrapper sSLContextWrapper, boolean bl) throws ConfigurationException {
        if (this.debug) {
            SSLSetup.info("SSLContextManager: loading server SSL identity, forOutboundSSL=" + bl);
        }
        if (this.usePerServerKeyStores()) {
            SSLIdentityKey sSLIdentityKey;
            SSLIdentity sSLIdentity;
            char[] cArray;
            String string;
            File file;
            KeyStoreConfigurationHelper keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(MBeanKeyStoreConfiguration.getInstance(), networkAccessPointMBean);
            KeyStoreInfo keyStoreInfo = keyStoreConfigurationHelper.getIdentityKeyStore();
            if (keyStoreInfo == null) {
                SSLContextManager.fail(SecurityLogger.logInvalidServerSSLConfigurationLoggable((String)this.getServerName()), null);
            }
            if ((file = this.findFile(keyStoreInfo.getFileName())) == null) {
                SSLContextManager.fail(SecurityLogger.logIdentityKeyStoreFileNotFoundLoggable((String)this.getServerName(), (String)keyStoreInfo.getFileName()), null);
            }
            String string2 = keyStoreInfo.getType();
            char[] cArray2 = keyStoreInfo.getPassPhrase();
            if (bl) {
                string = keyStoreConfigurationHelper.getOutboundPrivateKeyAlias();
                cArray = keyStoreConfigurationHelper.getOutboundPrivateKeyPassPhrase();
            } else {
                string = keyStoreConfigurationHelper.getIdentityAlias();
                cArray = keyStoreConfigurationHelper.getIdentityPrivateKeyPassPhrase();
            }
            if (this.debug) {
                SSLSetup.info("forOutboundSSL=" + bl + ", resolved alias=" + string);
            }
            if (string == null) {
                SSLContextManager.fail(SecurityLogger.logIdentityKeyStoreAliasNotSpecifiedLoggable((String)this.getServerName()), null);
            }
            if ((sSLIdentity = (SSLIdentity)sslIdentities.get(sSLIdentityKey = new SSLIdentityKey(file, string2, string))) != null && sSLIdentity.verify(cArray2, cArray)) {
                if (this.debug) {
                    SSLSetup.info("Reusing cached identity certs for keystore " + file.getAbsolutePath() + ", and alias " + string);
                }
                return sSLIdentity;
            }
            SecurityLogger.logLoadIdentityCertificateFromKeyStore((String)file.getAbsolutePath(), (String)string2, (String)string);
            KeyStore keyStore = KeyStoreUtils.load(file, cArray2, string2);
            if (keyStore == null) {
                SSLContextManager.fail(SecurityLogger.logIdentityKeyStoreLoadFailedLoggable((String)this.getServerName(), (String)file.getAbsolutePath(), (String)string2), null);
            }
            if (cArray == null) {
                SecurityLogger.logSSLDidNotFindPrivateKeyPassPhrase((String)this.getServerName(), (String)this.getRealmName());
            }
            Key key = null;
            Certificate[] certificateArray = null;
            try {
                key = keyStore.getKey(string, cArray);
                certificateArray = keyStore.getCertificateChain(string);
            }
            catch (Exception exception) {
                SSLContextManager.fail(SecurityLogger.logFailedReadingIdentityEntryLoggable((String)this.getServerName(), (String)file.getAbsolutePath(), (String)string), exception);
            }
            if (!(key instanceof PrivateKey) || !(certificateArray instanceof Certificate[])) {
                SSLContextManager.fail(SecurityLogger.logIdentityEntryNotFoundUnderAliasLoggable((String)this.getServerName(), (String)file.getAbsolutePath(), (String)string), null);
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            }
            if (this.debug) {
                SSLSetup.info("Loaded public identity certificate chain:");
                SSLContextManager.debugCerts(x509CertificateArray);
            }
            sSLIdentity = new SSLIdentity((PrivateKey)key, x509CertificateArray, cArray2, cArray);
            sslIdentities.put(sSLIdentityKey, sSLIdentity);
            return sSLIdentity;
        }
        return this.getOldConfigServerSSLIdentity(sSLContextWrapper);
    }

    private static void fail(Loggable loggable, Throwable throwable) throws ConfigurationException {
        loggable.log();
        ConfigurationException configurationException = new ConfigurationException(loggable.getMessageText());
        if (throwable != null) {
            configurationException.initCause(throwable);
        }
        throw configurationException;
    }

    private File findFile(String string) {
        File file = null;
        if (string != null && !(file = new File(string)).exists() && !(file = new File(this.runtimeAccess.getServer().getRootDirectory(), string)).exists()) {
            file = null;
        }
        return file;
    }

    private final String getServerName() {
        return this.runtimeAccess.getServer().getName();
    }

    private final String getRealmName() {
        return this.runtimeAccess.getDomain().getSecurity().getRealm().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLIdentity getOldConfigServerSSLIdentity(SSLContextWrapper sSLContextWrapper) throws ConfigurationException {
        Object object;
        Object object2;
        Object object3;
        Certificate[] certificateArray;
        PrivateKey privateKey;
        SSLMBean sSLMBean;
        block39: {
            block37: {
                block38: {
                    sSLMBean = this.runtimeAccess.getServer().getSSL();
                    privateKey = null;
                    KeyManager keyManager = SSLContextManager.getKeyManager();
                    if (keyManager == null) break block37;
                    certificateArray = sSLMBean.getServerPrivateKeyAlias();
                    if (this.debug) {
                        SSLSetup.info("SSLContextManager: key alias - " + (String)certificateArray);
                    }
                    if (certificateArray == null) break block38;
                    object3 = sSLMBean.getServerPrivateKeyPassPhrase();
                    if (this.debug) {
                        SSLSetup.info("SSLContextManager: key passphrase: " + (object3 != null ? "<non-null>" : "<null>"));
                    }
                    if (object3 == null) {
                        SecurityLogger.logSSLDidNotFindPrivateKeyPassPhrase((String)this.getServerName(), (String)this.getRealmName());
                    }
                    if ((object2 = keyManager.getPrivateKeyStore()) != null && ((KeyStore[])object2).length > 0) {
                        if (this.debug) {
                            SSLSetup.info("Looking for key in keystore");
                        }
                        object = object3 != null ? ((String)object3).toCharArray() : null;
                        try {
                            for (int i = 0; i < ((Object)object2).length; ++i) {
                                if (object2[i] == null || (privateKey = (PrivateKey)((KeyStore)object2[i]).getKey((String)certificateArray, (char[])object)) == null) continue;
                                SecurityLogger.logUsingPrivateKeyFromKeyStore((String)this.getServerName(), (String)certificateArray);
                                if (this.debug) {
                                    SSLSetup.info("Found private key in keystore");
                                }
                                break;
                            }
                        }
                        catch (Exception exception) {
                            SSLContextManager.fail(SecurityLogger.logUnexpectedExceptionPrivateKeyStoreLoggable((String)this.getServerName(), (String)this.getRealmName(), (String)certificateArray), exception);
                        }
                        if (privateKey == null) {
                            String[] stringArray = keyManager.getPrivateKeyStoreLocation();
                            String string = "<empty location>";
                            if (stringArray.length > 0) {
                                StringBuffer stringBuffer = new StringBuffer();
                                for (int i = 0; i < ((Object)object2).length; ++i) {
                                    if (i > 0) {
                                        stringBuffer.append(" or ");
                                    }
                                    stringBuffer.append(stringArray[i] != null && stringArray[i].length() > 0 ? stringArray[i] : "<empty location entry>");
                                }
                                string = stringBuffer.toString();
                            }
                            SecurityLogger.logPrivateKeyStoreNotFound((String)certificateArray, (String)string, (String)this.getServerName(), (String)this.getRealmName());
                            throw new ConfigurationException(SecurityLogger.getCanNotFindPrivateKeyWithAlias((String)certificateArray, (String)string));
                        }
                    }
                    break block39;
                }
                SecurityLogger.logSSLDidNotFindPrivateKeyAlias((String)this.getServerName(), (String)this.getRealmName());
                break block39;
            }
            SecurityLogger.logCannotFindKeyManager((String)this.getServerName(), (String)this.getRealmName());
        }
        if (privateKey == null) {
            if (this.debug) {
                SSLSetup.info("Assuming 6.x file based configuration for SSL Server Identity");
            }
            if ((object3 = this.findFile((String)(certificateArray = sSLMBean.getServerKeyFileName()))) == null) {
                SecurityLogger.logSSLKeyFileNameError((String)this.getServerName());
                throw new ConfigurationException(SecurityLogger.getCanNotFindPrivateKeyFile((String)this.getServerName(), (String)certificateArray));
            }
            object2 = null;
            try {
                try {
                    object2 = new FileInputStream((File)object3);
                    object = ManagementService.getPropertyService(kernelId).getTimestamp3();
                    if (keyFilePwd == null) {
                        if (object == null) {
                            object = sSLMBean.getServerPrivateKeyPassPhrase();
                        }
                        keyFilePwd = object == null ? new char[1] : ((String)object).toCharArray();
                        ManagementService.getPropertyService(kernelId).updateTimestamp3();
                    }
                    privateKey = sSLContextWrapper.inputPrivateKey((InputStream)object2, keyFilePwd);
                    SecurityLogger.logFoundPrivateKeyInSSLConfig((String)this.getServerName());
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(SecurityLogger.getCanNotPrivateKeyFile((String)((File)object3).getAbsolutePath(), (String)iOException.getMessage()));
                }
                catch (KeyManagementException keyManagementException) {
                    CommandLine commandLine = CommandLine.getCommandLine();
                    throw new ConfigurationException(SecurityLogger.getCanNotReadPrivateKeyFile((String)((File)object3).getAbsolutePath(), (String)commandLine.getAdminPKPasswordProp(), (String)keyManagementException.getMessage()));
                }
                Object var14_19 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                try {
                    if (object2 == null) throw throwable;
                    ((FileInputStream)object2).close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (object2 != null) {
                ((FileInputStream)object2).close();
            }
        }
        certificateArray = null;
        object3 = sSLMBean.getServerCertificateFileName();
        object2 = this.findFile((String)object3);
        if (object2 == null) {
            SecurityLogger.logSSLCertificateFileNameError((String)this.getServerName(), (String)"ServerCertificateFileName");
            throw new ConfigurationException(SecurityLogger.getUnableToFindServerCertFile((String)this.getServerName(), (String)object3));
        }
        object = null;
        try {
            try {
                object = new FileInputStream((File)object2);
                certificateArray = SSLCertUtility.inputCertificateChain(sSLContextWrapper, (InputStream)object);
                ValidateCertChain.validateServerCertChain(certificateArray);
            }
            catch (Exception exception) {
                throw (ConfigurationException)new ConfigurationException(exception.getMessage()).initCause((Throwable)exception);
            }
            Object var17_24 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var17_25 = null;
            try {
                if (object == null) throw throwable;
                ((FileInputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (object != null) {
            ((FileInputStream)object).close();
        }
        if (!this.debug) return new SSLIdentity(privateKey, (X509Certificate[])certificateArray);
        SSLSetup.info("Loaded public identity certificate chain using old SSL configuration:");
        SSLContextManager.debugCerts((X509Certificate[])certificateArray);
        return new SSLIdentity(privateKey, (X509Certificate[])certificateArray);
    }

    private X509Certificate[] getOldConfigServerTrustedCAs(SSLContextWrapper sSLContextWrapper) {
        Collection collection;
        Object object;
        X509Certificate[] x509CertificateArray = null;
        String string = CommandLine.getCommandLine().getKeyStoreFileName();
        if (string != null) {
            File file;
            Collection collection2;
            if (this.debug) {
                SSLSetup.info("SSLContextManager, loading trusted CAs from cmd line keystore: " + string);
            }
            if ((collection2 = SSLContextManager.getTrustedCAs((file = this.findFile(string)) == null ? string : file.getAbsolutePath(), "jks", null)) != null) {
                x509CertificateArray = collection2.toArray(new X509Certificate[collection2.size()]);
            }
            String string2 = x509CertificateArray == null ? "0" : String.valueOf(x509CertificateArray.length);
            SecurityLogger.logTrustedCAsLoadedFromCmdLnKeyStore((String)string2, (String)string);
            if (this.debug) {
                SSLContextManager.debugCerts(x509CertificateArray);
            }
            return x509CertificateArray;
        }
        KeyManager keyManager = SSLContextManager.getKeyManager();
        if (keyManager != null) {
            object = keyManager.getRootCAKeyStore();
            boolean bl = false;
            if (object != null) {
                for (int i = 0; i < ((KeyStore[])object).length && !bl; ++i) {
                    if (object[i] == null) continue;
                    bl = true;
                }
            }
            if (bl) {
                if (this.debug) {
                    SSLSetup.info("SSLContextManager, loading trusted CAs from RootCAKeyStore");
                }
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < ((KeyStore[])object).length; ++i) {
                    if (object[i] == null) continue;
                    try {
                        arrayList.addAll(SSLCertUtility.getX509Certificates(object[i]));
                        continue;
                    }
                    catch (KeyStoreException keyStoreException) {
                        SSLSetup.debug(2, keyStoreException, "Unable to load trusted CAs KeyStore file (" + i + ")");
                    }
                }
                x509CertificateArray = arrayList.toArray(new X509Certificate[arrayList.size()]);
                SecurityLogger.logTrustedCAsLoadedFromKeyStore((String)String.valueOf(x509CertificateArray.length));
                if (this.debug) {
                    SSLContextManager.debugCerts(x509CertificateArray);
                }
                return x509CertificateArray;
            }
        } else {
            SecurityLogger.logCannotFindKeyManager((String)this.getServerName(), (String)this.getRealmName());
        }
        object = this.runtimeAccess.getServer().getSSL().getTrustedCAFileName();
        if (object != null) {
            File file;
            if (this.debug) {
                SSLSetup.info("SSLContextManager, loading trusted CAs from TrustedCAFile: " + (String)object);
            }
            if ((file = this.findFile((String)object)) != null) {
                Object object2;
                block28: {
                    try {
                        object2 = new FileInputStream(file);
                        x509CertificateArray = SSLCertUtility.inputCertificateChain(sSLContextWrapper, (InputStream)object2);
                        ((FileInputStream)object2).close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        SecurityLogger.logTrustedCAFileNotFound((String)object, (String)this.getServerName());
                        if (this.debug) {
                            SSLSetup.info("Cannot find the specified trusted CA file " + (String)object);
                        }
                    }
                    catch (IOException iOException) {
                        SecurityLogger.logCannotAccessTrustedCAFile((String)object, (String)this.getServerName());
                        if (this.debug) {
                            SSLSetup.info(iOException, "The Server was not able to read trusted CA file " + (String)object);
                        }
                    }
                    catch (KeyManagementException keyManagementException) {
                        SecurityLogger.logInvalidTrustedCAFileFormat((String)object, (String)this.getServerName());
                        if (!this.debug) break block28;
                        SSLSetup.info(keyManagementException, "The Server was not able to read certificate from trusted CA file " + (String)object);
                    }
                }
                object2 = x509CertificateArray == null ? "0" : String.valueOf(x509CertificateArray.length);
                SecurityLogger.logTrustedCAsLoadedFromTrustedCAFile((String)object2);
                if (this.debug) {
                    SSLContextManager.debugCerts(x509CertificateArray);
                }
                return x509CertificateArray;
            }
            SecurityLogger.logTrustedCAFileNotFound((String)object, (String)this.getServerName());
            if (this.debug) {
                SSLSetup.info("Cannot find the specified trusted CA file " + (String)object);
            }
        }
        String string3 = BootStrap.getWebLogicHome() + File.separator + "lib" + File.separator + "cacerts";
        if (this.debug) {
            SSLSetup.info("SSLContextManager, loading trusted CAs from default key store: " + string3);
        }
        if ((collection = SSLContextManager.getTrustedCAs(string3, "jks", null)) != null) {
            x509CertificateArray = collection.toArray(new X509Certificate[collection.size()]);
        }
        String string4 = x509CertificateArray == null ? "0" : String.valueOf(x509CertificateArray.length);
        SecurityLogger.logTrustedCAsLoadedFromDefaultKeyStore((String)string4, (String)string3);
        if (this.debug) {
            SSLContextManager.debugCerts(x509CertificateArray);
        }
        return x509CertificateArray;
    }

    private static KeyManager getKeyManager() {
        try {
            return (KeyManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.KEYMANAGER);
        }
        catch (Exception exception) {
            SSLSetup.debug(1, exception, "Failed to get key manager");
            SecurityLogger.logSSLCouldNotGetSecurityService();
            return null;
        }
    }

    private static void debugCerts(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SSLSetup.info(SSLContextManager.toString((X509Certificate)iterator.next()));
        }
    }

    private static void debugCerts(X509Certificate[] x509CertificateArray) {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            SSLSetup.info(SSLContextManager.toString(x509CertificateArray[i]));
        }
    }

    private static String toString(X509Certificate x509Certificate) {
        return "Subject: " + x509Certificate.getSubjectDN() + "; Issuer: " + x509Certificate.getIssuerDN();
    }

    private static class SSLIdentityKey {
        public File ksFile;
        public String ksType;
        public String alias;

        public SSLIdentityKey(File file, String string, String string2) {
            assert (file != null) : "null keystore file";
            assert (string != null) : "null keystore type";
            assert (string2 != null) : "null key alias";
            this.ksFile = file;
            this.ksType = string.toUpperCase(Locale.ENGLISH);
            this.alias = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SSLIdentityKey)) {
                return false;
            }
            SSLIdentityKey sSLIdentityKey = (SSLIdentityKey)object;
            return this.alias.equals(sSLIdentityKey.alias) && this.ksType.equals(sSLIdentityKey.ksType) && this.ksFile.equals(sSLIdentityKey.ksFile);
        }

        public int hashCode() {
            int n = this.ksFile.hashCode();
            n = 31 * n + this.ksType.hashCode();
            n = 31 * n + this.alias.hashCode();
            return n;
        }
    }

    private static class SSLIdentity {
        public PrivateKey key;
        public X509Certificate[] certChain;
        private char[] ksPwd;
        private char[] keyPwd;

        public SSLIdentity(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this(privateKey, x509CertificateArray, null, null);
        }

        public SSLIdentity(PrivateKey privateKey, X509Certificate[] x509CertificateArray, char[] cArray, char[] cArray2) {
            this.key = privateKey;
            this.certChain = x509CertificateArray;
            this.ksPwd = cArray;
            this.keyPwd = cArray2;
        }

        public boolean verify(char[] cArray, char[] cArray2) {
            return Arrays.equals(this.ksPwd, cArray) && Arrays.equals(this.keyPwd, cArray2);
        }
    }
}

