/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.SSLContextDelegate;
import weblogic.security.utils.SSLContextDelegate2;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLTrustValidator;
import weblogic.security.utils.SSLWLSHostnameVerifier;

public class SSLContextWrapper {
    private static final String GET_ENABLENULLCIPHER_METHOD = "enableUnencryptedNullCipher";
    private static final String GET_ISNULLCIPHER_METHOD = "isUnencryptedNullCipherEnabled";
    private static final String GET_SSL_NIO_SSF_METHOD = "getSSLNioServerSocketFactory";
    private static final String GET_SSL_NIO_SOCK_METHOD = "getSSLNioSocketFactory";
    private boolean b1stCall_EnableNullCipher = true;
    private Method mtd_EnableNullCipher = null;
    private boolean b1stCall_isEnableNullCipher = true;
    private Method mtd_isEnableNullCipher = null;
    private boolean b1stCall_getNioServerFact = true;
    private Method mtd_getNioServerFact = null;
    private boolean b1stCall_getNioSockFact = true;
    private Method mtd_getNioSockFact = null;
    private SSLContextDelegate sslContext = SSLSetup.getSSLDelegateInstance();
    private ConcurrentMap<String, Long> unsupportedCerts;
    private static final int LOG_PERIOD = 300000;

    public static final SSLContextWrapper getInstance() {
        return new SSLContextWrapper();
    }

    private SSLContextWrapper() {
        if (!SSLSetup.isJSSEEnabled()) {
            this.sslContext.setProtocolVersion(SSLSetup.getProtocolVersion());
        }
        this.sslContext.setTrustManager(new SSLTrustValidator());
        this.sslContext.setHostnameVerifier(new SSLWLSHostnameVerifier());
        this.sslContext.enforceConstraints(SSLSetup.getEnforceConstraints());
        this.unsupportedCerts = new ConcurrentHashMap<String, Long>();
    }

    private void logCertError(X509Certificate x509Certificate, Exception exception) {
        if (x509Certificate != null) {
            boolean bl = false;
            boolean bl2 = Boolean.getBoolean("weblogic.security.suppressUnsupportedCANotice");
            String string = x509Certificate.getIssuerX500Principal().getName() + x509Certificate.getSerialNumber().toString();
            long l = System.currentTimeMillis();
            if (this.unsupportedCerts.containsKey(string)) {
                Long l2 = (Long)this.unsupportedCerts.get(string);
                if (l - l2 >= 300000L) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl && !bl2) {
                this.unsupportedCerts.put(string, new Long(l));
                SecurityLogger.logFailedToAddaCA2Server((String)x509Certificate.getSubjectX500Principal().getName(), (String)exception.getMessage());
            }
        }
    }

    public void addTrustedCA(X509Certificate x509Certificate) throws CertificateException {
        this.sslContext.addTrustedCA(x509Certificate);
    }

    public void addTrustedCA(X509Certificate[] x509CertificateArray) throws CertificateException {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            try {
                this.sslContext.addTrustedCA(x509CertificateArray[i]);
                continue;
            }
            catch (CertificateParsingException certificateParsingException) {
                this.logCertError(x509CertificateArray[i], certificateParsingException);
            }
        }
    }

    public X509Certificate[] getTrustedCAs() {
        return this.sslContext.getTrustedCAs();
    }

    public PrivateKey inputPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        return this.sslContext.inputPrivateKey(inputStream, cArray);
    }

    public X509Certificate[] inputCertChain(InputStream inputStream) throws KeyManagementException {
        return this.sslContext.inputCertChain(inputStream);
    }

    public void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        this.sslContext.loadLocalIdentity(inputStream, cArray);
    }

    public void loadTrustedCerts(InputStream inputStream) throws CertificateException, KeyManagementException {
        this.sslContext.loadTrustedCerts(inputStream);
    }

    public void addIdentity(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.sslContext.addIdentity(x509CertificateArray, privateKey);
    }

    public boolean doKeysMatch(PublicKey publicKey, PrivateKey privateKey) throws KeyManagementException {
        return this.sslContext.doKeysMatch(publicKey, privateKey);
    }

    public void setExportRefreshCount(int n) {
        this.sslContext.setExportRefreshCount(n);
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.sslContext.getSSLServerSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslContext.getSSLSocketFactory();
    }

    public void setTrustManager(SSLTrustValidator sSLTrustValidator) {
        this.sslContext.setTrustManager(sSLTrustValidator);
    }

    public SSLTrustValidator getTrustManager() {
        return (SSLTrustValidator)this.sslContext.getTrustManager();
    }

    public void setHostnameVerifier(SSLWLSHostnameVerifier sSLWLSHostnameVerifier) {
        this.sslContext.setHostnameVerifier(sSLWLSHostnameVerifier);
    }

    public SSLWLSHostnameVerifier getHostnameVerifier() {
        return (SSLWLSHostnameVerifier)this.sslContext.getHostnameVerifier();
    }

    public void enableUnencryptedNullCipher(boolean bl) {
        if (this.b1stCall_EnableNullCipher) {
            Class<?> clazz = this.sslContext.getClass();
            try {
                this.mtd_EnableNullCipher = clazz.getMethod(GET_ENABLENULLCIPHER_METHOD, Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SSLSetup.info(noSuchMethodException, "Method enableUnencryptedNullCipher() does not exist for class " + clazz.getName());
            }
        }
        try {
            if (this.mtd_EnableNullCipher != null) {
                this.mtd_EnableNullCipher.invoke((Object)this.sslContext, new Boolean(bl));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Method enableUnencryptedNullCipher() can not be accessed; detail: " + illegalAccessException.getMessage();
            if (this.b1stCall_EnableNullCipher) {
                SSLSetup.info(illegalAccessException, string);
            }
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method enableUnencryptedNullCipher() can not be involked with object " + this.sslContext.toString() + " detail: " + invocationTargetException.getMessage();
            if (this.b1stCall_EnableNullCipher) {
                SSLSetup.info(invocationTargetException, string);
            }
            throw new RuntimeException(string, invocationTargetException);
        }
        if (this.b1stCall_EnableNullCipher) {
            this.b1stCall_EnableNullCipher = false;
        }
    }

    public boolean isUnencryptedNullCipherEnabled() {
        Object object = null;
        if (this.b1stCall_isEnableNullCipher) {
            Class<?> clazz = this.sslContext.getClass();
            try {
                this.mtd_isEnableNullCipher = clazz.getMethod(GET_ISNULLCIPHER_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SSLSetup.info(noSuchMethodException, "Method isUnencryptedNullCipher() does not exist for class " + clazz.getName());
            }
        }
        try {
            if (this.mtd_isEnableNullCipher != null) {
                object = this.mtd_isEnableNullCipher.invoke((Object)this.sslContext, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Method isUnencryptedNullCipher() can not be accessed; detail: " + illegalAccessException.getMessage();
            if (this.b1stCall_isEnableNullCipher) {
                SSLSetup.info(illegalAccessException, string);
            }
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method isUnencryptedNullCipher() can not be involked with object " + this.sslContext.toString() + " detail: " + invocationTargetException.getMessage();
            if (this.b1stCall_isEnableNullCipher) {
                SSLSetup.info(invocationTargetException, string);
            }
            throw new RuntimeException(string, invocationTargetException);
        }
        if (this.b1stCall_isEnableNullCipher) {
            this.b1stCall_isEnableNullCipher = false;
        }
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    public SSLServerSocketFactory getSSLNioServerSocketFactory() {
        Object object = null;
        if (this.b1stCall_getNioServerFact) {
            Class<?> clazz = this.sslContext.getClass();
            try {
                this.mtd_getNioServerFact = clazz.getMethod(GET_SSL_NIO_SSF_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SSLSetup.info(noSuchMethodException, "Method getSSLNioServerSocketFactory() does not exist for class " + clazz.getName());
            }
        }
        try {
            if (this.mtd_getNioServerFact != null) {
                object = this.mtd_getNioServerFact.invoke((Object)this.sslContext, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Method getSSLNioServerSocketFactory() can not be accessed; detail: " + illegalAccessException.getMessage();
            if (this.b1stCall_getNioServerFact) {
                SSLSetup.info(illegalAccessException, string);
            }
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method getSSLNioServerSocketFactory() can not be involked with object " + this.sslContext.toString() + " detail: " + invocationTargetException.getMessage();
            if (this.b1stCall_getNioServerFact) {
                SSLSetup.info(invocationTargetException, string);
            }
            throw new RuntimeException(string, invocationTargetException);
        }
        if (this.b1stCall_getNioServerFact) {
            this.b1stCall_getNioServerFact = false;
        }
        if (object != null) {
            if (this.b1stCall_getNioServerFact) {
                SSLSetup.info("SSL Nio version of SSLServerSocketFactory is created");
            }
            return (SSLServerSocketFactory)object;
        }
        throw new UnsupportedOperationException("Method of getSSLNioServerSocketFactory() is not supported");
    }

    public SSLSocketFactory getSSLNioSocketFactory() {
        Object object = null;
        if (this.b1stCall_getNioSockFact) {
            Class<?> clazz = this.sslContext.getClass();
            try {
                this.mtd_getNioSockFact = clazz.getMethod(GET_SSL_NIO_SOCK_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SSLSetup.info(noSuchMethodException, "Method getSSLNioServerSocketFactory() does not exist for class " + clazz.getName());
            }
        }
        try {
            if (this.mtd_getNioSockFact != null) {
                object = this.mtd_getNioSockFact.invoke((Object)this.sslContext, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Method getSSLNioSocketFactory() can not be accessed; detail: " + illegalAccessException.getMessage();
            if (this.b1stCall_getNioSockFact) {
                SSLSetup.info(illegalAccessException, string);
            }
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method getSSLNioSocketFactory() can not be involked with object " + this.sslContext.toString() + " detail: " + invocationTargetException.getMessage();
            if (this.b1stCall_getNioSockFact) {
                SSLSetup.info(invocationTargetException, string);
            }
            throw new RuntimeException(string, invocationTargetException);
        }
        if (this.b1stCall_getNioSockFact) {
            this.b1stCall_getNioSockFact = false;
        }
        if (object != null) {
            if (this.b1stCall_getNioServerFact) {
                SSLSetup.info("SSL Nio version of SSLSocketFactory is created");
            }
            return (SSLSocketFactory)object;
        }
        throw new UnsupportedOperationException("Method of getSSLNioSocketFactory() is not supported");
    }

    public WeblogicSSLEngine createSSLEngine() throws SSLException {
        if (this.sslContext instanceof SSLContextDelegate2) {
            SSLContextDelegate2 sSLContextDelegate2 = (SSLContextDelegate2)this.sslContext;
            return sSLContextDelegate2.createSSLEngine();
        }
        throw new UnsupportedOperationException("createSSLEngine is not supported by selected SSL implementation.");
    }

    public WeblogicSSLEngine createSSLEngine(String string, int n) throws SSLException {
        if (this.sslContext instanceof SSLContextDelegate2) {
            SSLContextDelegate2 sSLContextDelegate2 = (SSLContextDelegate2)this.sslContext;
            return sSLContextDelegate2.createSSLEngine(string, n);
        }
        throw new UnsupportedOperationException("createSSLEngine is not supported by selected SSL implementation.");
    }

    public String[] getDefaultCipherSuites() {
        if (this.sslContext instanceof SSLContextDelegate2) {
            SSLContextDelegate2 sSLContextDelegate2 = (SSLContextDelegate2)this.sslContext;
            return sSLContextDelegate2.getDefaultCipherSuites();
        }
        throw new UnsupportedOperationException("getDefaultCipherSuites is not supported by selected SSL implementation.");
    }

    public String[] getSupportedCipherSuites() {
        if (this.sslContext instanceof SSLContextDelegate2) {
            SSLContextDelegate2 sSLContextDelegate2 = (SSLContextDelegate2)this.sslContext;
            return sSLContextDelegate2.getSupportedCipherSuites();
        }
        throw new UnsupportedOperationException("getSupportedCipherSuites is not supported by selected SSL implementation.");
    }
}

