/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.socket.SSLFilter;
import weblogic.socket.SSLFilterImpl;
import weblogic.utils.io.ChunkedInputStream;

public final class SSLIOContext {
    private static final boolean DEBUG = SSLSetupLogging.isDebugEnabled(3);
    private SSLSocket sslSocket;
    private SSLFilter muxerFilter;
    private ChunkedInputStream muxerIS;
    private OutputStream outputStream;
    private InputStream rawInputStream;

    public SSLIOContext(InputStream inputStream, OutputStream outputStream, SSLSocket sSLSocket) throws IOException {
        this.rawInputStream = inputStream;
        this.outputStream = outputStream;
        this.sslSocket = sSLSocket;
        this.muxerFilter = new SSLFilterImpl(inputStream, sSLSocket);
        this.muxerIS = this.muxerFilter.getInputStream();
    }

    public SSLIOContext(InputStream inputStream, OutputStream outputStream, SSLSocket sSLSocket, SSLFilter sSLFilter) throws IOException {
        this.rawInputStream = inputStream;
        this.outputStream = outputStream;
        this.sslSocket = sSLSocket;
        this.muxerFilter = sSLFilter;
        this.muxerIS = this.muxerFilter.getInputStream();
    }

    public boolean isMuxerActivated() {
        if (DEBUG) {
            SSLSetupLogging.info("isMuxerActivated: " + this.muxerFilter.isActivated());
        }
        return this.muxerFilter.isActivated();
    }

    public synchronized boolean hasSSLRecord() {
        boolean bl;
        if (DEBUG) {
            SSLSetupLogging.info("hasSSLRecord()");
        }
        int n = this.muxerIS.peek(3);
        int n2 = this.muxerIS.peek(4);
        if (n == -1 || n2 == -1) {
            if (DEBUG) {
                SSLSetupLogging.info("hasSSLRecord returns false 1");
            }
            return false;
        }
        int n3 = (n & 0xFF) << 8 | n2 & 0xFF;
        boolean bl2 = bl = n3 + 5 <= this.muxerIS.available();
        if (DEBUG) {
            SSLSetupLogging.info("hasSSLRecord returns " + bl);
        }
        return bl;
    }

    public InputStream getMuxerIS() {
        return this.muxerIS;
    }

    public SSLSocket getSSLSocket() {
        return this.sslSocket;
    }

    public Object getFilter() {
        return this.muxerFilter;
    }

    public InputStream getRawInputStream() {
        return this.rawInputStream;
    }
}

