/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.net.ssl.SSLSocket;
import weblogic.security.SecurityEnvironment;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLSetupLogging;

public final class SSLIOContextTable {
    private static HashMap registeredContextsStream = new HashMap();
    private static HashMap registeredContextsSocket = new HashMap();
    private static HashSet throttledSockets = new HashSet();

    public static synchronized void addContext(SSLIOContext sSLIOContext) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.addContext(ctx): " + sSLIOContext.hashCode());
        registeredContextsStream.put(sSLIOContext.getRawInputStream(), sSLIOContext);
        registeredContextsSocket.put(sSLIOContext.getSSLSocket(), sSLIOContext);
    }

    public static synchronized void removeContext(SSLIOContext sSLIOContext) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.removeContext(ctx): " + sSLIOContext.hashCode());
        registeredContextsStream.remove(sSLIOContext.getRawInputStream());
        registeredContextsSocket.remove(sSLIOContext.getSSLSocket());
        SSLIOContextTable.unregisterThrottled(sSLIOContext.getSSLSocket());
    }

    public static synchronized void removeContext(InputStream inputStream) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.removeContext(is): " + inputStream.hashCode());
        SSLIOContext sSLIOContext = (SSLIOContext)registeredContextsStream.remove(inputStream);
        if (sSLIOContext != null) {
            registeredContextsSocket.remove(sSLIOContext.getSSLSocket());
            SSLIOContextTable.unregisterThrottled(sSLIOContext.getSSLSocket());
        }
    }

    public static synchronized void removeContext(SSLSocket sSLSocket) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.removeContext(sock): " + sSLSocket.hashCode());
        SSLIOContext sSLIOContext = (SSLIOContext)registeredContextsSocket.remove(sSLSocket);
        if (sSLIOContext != null) {
            registeredContextsStream.remove(sSLIOContext.getRawInputStream());
            SSLIOContextTable.unregisterThrottled(sSLSocket);
        }
    }

    public static synchronized SSLIOContext findContext(InputStream inputStream) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.findContext(is): " + inputStream.hashCode());
        return (SSLIOContext)registeredContextsStream.get(inputStream);
    }

    public static synchronized SSLIOContext findContext(SSLSocket sSLSocket) {
        SSLSetupLogging.debug(3, "SSLIOContextTable.findContext(sock): " + sSLSocket.hashCode());
        return (SSLIOContext)registeredContextsSocket.get(sSLSocket);
    }

    public static synchronized void registerForThrottling(SSLSocket sSLSocket) {
        if (!throttledSockets.contains(sSLSocket) && registeredContextsSocket.containsKey(sSLSocket)) {
            throttledSockets.add(sSLSocket);
        }
    }

    private static void unregisterThrottled(SSLSocket sSLSocket) {
        if (throttledSockets.remove(sSLSocket)) {
            SecurityEnvironment.getSecurityEnvironment().decrementOpenSocketCount(sSLSocket);
        }
    }
}

