/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import com.certicom.tls.interfaceimpl.TLSSystem;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.CommandLine;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SSL.SSLEnabledProtocolVersions;
import weblogic.security.SSL.SSLEnabledProtocolVersionsLogging;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.utils.BasicConstraintsSSLContextDelegate;
import weblogic.security.utils.ClientKeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.PreMBeanKeyStoreConfiguration;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextDelegate;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.security.utils.SecurityUtils;

public final class SSLSetup
extends SSLSetupLogging {
    public static final int STANDARD_IO = 0;
    public static final int MUXING_IO = 1;
    public static final int LICENSE_NOT_CHECKED = -1;
    public static final int LICENSE_NONE = 0;
    public static final int LICENSE_DOMESTIC = 1;
    public static final int LICENSE_EXPORT = 2;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String FAILURE_DETAILS = "weblogic.security.ssl.failureDetails";
    private static boolean ioModelAccessed = false;
    private static int ioModel = 0;
    private static volatile int licenseLevel = -1;
    private static int debugLevel = 0;
    private static volatile boolean protocolVersionChecked = false;
    private static volatile int protocolVersion = 3;
    private static boolean enforceConstraintsChecked = false;
    private static int enforceConstraints = 1;
    private static final String ENABLE_JSSE_PROPNAME = "weblogic.security.SSL.enableJSSE";
    private static volatile boolean jsseEnabled = false;
    private static final String CERTICOM_DELEGATE = "com.bea.sslplus.CerticomSSLContext";
    private static final String RSA_DELEGATE = "com.rsa.ssl.WeblogicContextWrapper";
    private static final String JSSE_DELEGATE = "weblogic.security.SSL.jsseadapter.JaSSLContextImpl";
    private static Class sslDelegateClass = null;

    public static synchronized int getLicenseLevel() {
        String string;
        if (licenseLevel > -1) {
            return licenseLevel;
        }
        boolean bl = true;
        try {
            if (!SSLSetup.isFatClient()) {
                RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                if (null == runtimeAccess) {
                    SSLSetup.debug(2, "Failure determining whether to enable JSSE, server RuntimeAccess is null for kernelId=" + kernelId + ".");
                    bl = false;
                } else {
                    ServerMBean serverMBean = runtimeAccess.getServer();
                    if (null == serverMBean) {
                        SSLSetup.debug(2, "Failure determining whether to enable JSSE, server ServerMBean is null for kernelId=" + kernelId + ".");
                    } else {
                        SSLMBean sSLMBean = serverMBean.getSSL();
                        if (null == sSLMBean) {
                            SSLSetup.debug(2, "Failure determining whether to enable JSSE, server SSLMBean is null for kernelId=" + kernelId + ".");
                        } else {
                            jsseEnabled = sSLMBean.isJSSEEnabled();
                        }
                    }
                }
            } else {
                jsseEnabled = Boolean.getBoolean(ENABLE_JSSE_PROPNAME);
            }
        }
        catch (RuntimeException runtimeException) {
            SSLSetup.debug(2, runtimeException, "Failure determining whether to enable JSSE.");
            throw runtimeException;
        }
        try {
            if (CryptoJ.getMode() == 0) {
                CryptoJ.setMode((int)2);
            }
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            SSLSetup.debug(2, jSAFE_InvalidUseException, "Failure switching from CryptoJ's FIPS140_MODE to FIPS140_SSL_MODE");
        }
        if (jsseEnabled) {
            string = JSSE_DELEGATE;
            SSLSetup.info("Use JSSE SSL (default strength)");
        } else {
            string = CERTICOM_DELEGATE;
            SSLSetup.info("Use Certicom SSL with Domestic strength");
        }
        SSLSetup.setSSLDelegate(string);
        if (bl) {
            licenseLevel = 1;
        }
        return licenseLevel;
    }

    public static synchronized void initForServer() {
        SSLSetup.setIOModel(1);
        SSLSetup.info("Enabled muxing IO for SSL in server");
    }

    public static boolean isJSSEEnabled() {
        SSLSetup.getLicenseLevel();
        return jsseEnabled;
    }

    private static void setSSLDelegate(String string) {
        try {
            sslDelegateClass = Class.forName(string);
            if (!SSLContextDelegate.class.isAssignableFrom(sslDelegateClass)) {
                String string2 = "Cannot initialize SSL implementation. " + string + " does not implement " + SSLContextDelegate.class.getName();
                throw new IllegalArgumentException(string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = SecurityLogger.getClassNotFound((String)string);
            throw new IllegalArgumentException(string3, classNotFoundException);
        }
        boolean bl = Boolean.getBoolean("weblogic.security.SSL.sendEmptyCAList");
        SSLSetup.info("Empty CA List is enabled :" + bl);
        if (bl) {
            TLSSystem.setSendEmptyCertRequest(bl);
        }
    }

    static SSLContextDelegate getSSLDelegateInstance() {
        if (licenseLevel == -1) {
            SSLSetup.getLicenseLevel();
        }
        try {
            return (SSLContextDelegate)sslDelegateClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = SecurityLogger.getIllegalAccessOnContextWrapper((String)sslDelegateClass.getName());
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            String string = SecurityLogger.getInstantiationExcOnContextWrapper((String)sslDelegateClass.getName());
            throw new RuntimeException(string, instantiationException);
        }
    }

    public static int getIOModel() {
        ioModelAccessed = true;
        return ioModel;
    }

    public static boolean logSSLRejections() {
        if (Kernel.isApplet()) {
            return false;
        }
        if (!Kernel.isServer()) {
            return true;
        }
        try {
            return ManagementService.getRuntimeAccess(kernelId).getServer().getSSL().isSSLRejectionLoggingEnabled();
        }
        catch (Exception exception) {
            SSLSetup.info(exception, "Caught exception in SSLSetup.logSSLRejections");
            return false;
        }
    }

    public static void setIOModel(int n) {
        if (n != 0 && n != 1) {
            SSLSetup.debug(2, "Attempt to change SSL IO model to invalid setting");
            return;
        }
        if (ioModelAccessed) {
            SSLSetup.debug(2, "Attempt to change SSL IO model after access");
            return;
        }
        ioModel = n;
    }

    public static int getProtocolVersion() {
        if (!protocolVersionChecked) {
            try {
                String string = CommandLine.getCommandLine().getSSLMinimumProtocolVersion();
                if (null != string) {
                    SSLEnabledProtocolVersionsLogging sSLEnabledProtocolVersionsLogging = new SSLEnabledProtocolVersionsLogging();
                    protocolVersion = SSLEnabledProtocolVersions.getSSLContextDelegateProtocolVersions(string, sSLEnabledProtocolVersionsLogging);
                } else {
                    String string2 = CommandLine.getCommandLine().getSSLVersion();
                    if (string2 != null) {
                        if (string2.equalsIgnoreCase("SSL3")) {
                            protocolVersion = 1;
                        } else if (string2.equalsIgnoreCase("TLS1")) {
                            protocolVersion = 0;
                        } else if (string2.equalsIgnoreCase("ALL")) {
                            protocolVersion = 3;
                        }
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            protocolVersionChecked = true;
        }
        return protocolVersion;
    }

    public static int getEnforceConstraints() {
        if (!enforceConstraintsChecked) {
            try {
                String string = CommandLine.getCommandLine().getSSLEnforcementConstraint();
                if (string != null) {
                    if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
                        enforceConstraints = 0;
                    } else if (string.equalsIgnoreCase("strong") || string.equalsIgnoreCase("true")) {
                        enforceConstraints = 1;
                    } else if (string.equalsIgnoreCase("strict")) {
                        enforceConstraints = 2;
                    } else if (BasicConstraintsSSLContextDelegate.class.isAssignableFrom(sslDelegateClass)) {
                        if (string.equalsIgnoreCase("strong_nov1cas")) {
                            enforceConstraints = 4;
                        } else if (string.equalsIgnoreCase("strict_nov1cas")) {
                            enforceConstraints = 3;
                        }
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            enforceConstraintsChecked = true;
        }
        return enforceConstraints;
    }

    public static SSLContextWrapper getSSLContext() throws SocketException {
        return SSLSetup.getSSLContext(null);
    }

    public static SSLContextWrapper getSSLContext(SSLClientInfo sSLClientInfo) throws SocketException {
        X509Certificate[] x509CertificateArray;
        SSLContextWrapper sSLContextWrapper = SSLContextWrapper.getInstance();
        if (!Kernel.isApplet() && (x509CertificateArray = SSLSetup.getTrustedCAs(sSLContextWrapper)) != null) {
            try {
                sSLContextWrapper.addTrustedCA(x509CertificateArray);
            }
            catch (Exception exception) {
                SSLSetup.debug(2, exception, "Failure loading trusted CA list");
            }
        }
        if (sSLClientInfo != null) {
            SSLSetup.applyInfo(sSLContextWrapper, sSLClientInfo);
        }
        return sSLContextWrapper;
    }

    private static void applyInfo(SSLContextWrapper sSLContextWrapper, SSLClientInfo sSLClientInfo) throws SocketException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        InputStream[] inputStreamArray = sSLClientInfo.getSSLClientCertificate();
        if (inputStreamArray != null && inputStreamArray.length >= 2) {
            SSLSetup.info("clientInfo has old style certificate and key");
            try {
                object5 = sSLClientInfo.getSSLClientKeyPassword();
                object4 = null;
                if (object5 != null) {
                    object4 = ((String)object5).toCharArray();
                }
                object3 = sSLContextWrapper.inputPrivateKey(inputStreamArray[0], (char[])object4);
                object2 = new X509Certificate[inputStreamArray.length - 1];
                object = CertificateFactory.getInstance("X.509");
                for (int i = 1; i < inputStreamArray.length; ++i) {
                    object2[i - 1] = (byte[])((X509Certificate)((CertificateFactory)object).generateCertificate(inputStreamArray[i]));
                }
                sSLContextWrapper.addIdentity((X509Certificate[])object2, (PrivateKey)object3);
                SSLSetup.info("client identity added");
            }
            catch (KeyManagementException keyManagementException) {
                SSLSetup.info(keyManagementException, "Problem accessing private key");
                throw new SocketException(SecurityLogger.getProblemAccessingPrivateKey());
            }
            catch (CertificateException certificateException) {
                SSLSetup.info(certificateException, "Problem with certificate chain");
                throw new SocketException(SecurityLogger.getProblemWithCertificateChain((String)certificateException.getMessage()));
            }
        }
        object5 = sSLClientInfo.getClientLocalIdentityCert();
        object4 = sSLClientInfo.getClientLocalIdentityKey();
        if (object5 != null && object4 != null) {
            SSLSetup.info("clientInfo has new style certificate and key");
            sSLContextWrapper.addIdentity((X509Certificate[])object5, (PrivateKey)object4);
        }
        if ((object3 = sSLClientInfo.getTrustManager()) != null) {
            SSLSetup.info("clientInfo has programmatic TrustManager");
            sSLContextWrapper.getTrustManager().setTrustManager((TrustManager)object3);
        }
        if ((object2 = sSLClientInfo.getRootCAfingerprints()) != null) {
            SSLSetup.info("Adding legacy rootCA fingerprints");
            sSLContextWrapper.getTrustManager().setRootCAFingerPrints((byte[][])object2);
        }
        if ((object = sSLClientInfo.getHostnameVerifier()) != null) {
            SSLSetup.info("clientInfo has HostnameVerifier");
            sSLContextWrapper.getHostnameVerifier().setHostnameVerifier((HostnameVerifier)object);
        }
        if ((string = sSLClientInfo.getExpectedName()) != null) {
            SSLSetup.info("clientInfo has expectedName");
            sSLContextWrapper.getHostnameVerifier().setExpectedName(string);
        }
    }

    private static X509Certificate[] getTrustedCAs(SSLContextWrapper sSLContextWrapper) {
        X509Certificate[] x509CertificateArray = null;
        if (!Kernel.isServer()) {
            KeyStoreInfo[] keyStoreInfoArray;
            String string = CommandLine.getCommandLine().getSSLTrustCA();
            if (string != null) {
                KeyStoreInfo[] keyStoreInfoArray2 = new KeyStoreInfo[1];
                keyStoreInfoArray = keyStoreInfoArray2;
                keyStoreInfoArray2[0] = new KeyStoreInfo(string, "jks", null);
            } else {
                keyStoreInfoArray = new KeyStoreConfigurationHelper(ClientKeyStoreConfiguration.getInstance()).getTrustKeyStores();
            }
            KeyStoreInfo[] keyStoreInfoArray3 = keyStoreInfoArray;
            ArrayList arrayList = new ArrayList();
            for (int i = 0; keyStoreInfoArray3 != null && i < keyStoreInfoArray3.length; ++i) {
                SSLSetup.info("Trusted CA keystore: " + keyStoreInfoArray3[i].getFileName());
                try {
                    KeyStore keyStore = KeyStore.getInstance(keyStoreInfoArray3[i].getType());
                    FileInputStream fileInputStream = new FileInputStream(keyStoreInfoArray3[i].getFileName());
                    keyStore.load(fileInputStream, null);
                    arrayList.addAll(SSLCertUtility.getX509Certificates(keyStore));
                    fileInputStream.close();
                    continue;
                }
                catch (Exception exception) {
                    SSLSetup.debug(2, exception, "Failure loading trusted CA list from: " + keyStoreInfoArray3[i].getFileName());
                }
            }
            x509CertificateArray = arrayList.toArray(new X509Certificate[arrayList.size()]);
        } else {
            SSLSetup.info("SSLSetup: loading trusted CA certificates");
            if (SecurityServiceManager.isSecurityServiceInitialized()) {
                try {
                    x509CertificateArray = SSLContextManager.getServerTrustedCAs();
                }
                catch (Exception exception) {
                    SSLSetup.debug("Failed to load server trusted CAs", exception);
                }
            } else {
                KeyStoreInfo[] keyStoreInfoArray;
                SSLSetup.debug(2, "SSLSetup: using pre-mbean command line configuration for SSL trust");
                String string = CommandLine.getCommandLine().getSSLTrustCA();
                if (string != null) {
                    KeyStoreInfo[] keyStoreInfoArray4 = new KeyStoreInfo[1];
                    keyStoreInfoArray = keyStoreInfoArray4;
                    keyStoreInfoArray4[0] = new KeyStoreInfo(string, "jks", null);
                } else {
                    keyStoreInfoArray = new KeyStoreConfigurationHelper(PreMBeanKeyStoreConfiguration.getInstance()).getTrustKeyStores();
                }
                KeyStoreInfo[] keyStoreInfoArray5 = keyStoreInfoArray;
                x509CertificateArray = SSLContextManager.getTrustedCAs(keyStoreInfoArray5);
            }
        }
        return x509CertificateArray == null || x509CertificateArray.length == 0 ? null : x509CertificateArray;
    }

    public static void setFailureDetails(SSLSession sSLSession, String string) {
        sSLSession.putValue(FAILURE_DETAILS, string);
    }

    public static String getFailureDetails(SSLSession sSLSession) {
        return (String)sSLSession.getValue(FAILURE_DETAILS);
    }

    public static void logPlaintextProtocolClientError(SSLSocket sSLSocket, String string) {
        String string2 = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "Connection to SSL port was made from " + string2 + " using plaintext protocol: " + string);
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logPlaintextProtocolClientErrorLoggable((String)string, (String)string2);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logProtocolVersionError(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "Connection to SSL port from " + string + " appears to be either unknown SSL version or maybe is plaintext");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logProtocolVersionErrorLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainConstraintsStrictNonCriticalFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which had basic constraints which were not marked critical, " + "this is being rejected due to the strict enforcement of basic constraints.");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainConstraintsStrictNonCriticalFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainMissingConstraintsFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which was missing the basic constraints extension");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainMissingConstraintsFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainNotACaConstraintsFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which didn't indicate it really is a CA");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainNotACaConstraintsFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainNoV1CAFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V1 CA certificate which cannot be a CA");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainNoV1CAFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainPathLenExceededConstraintsFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which indicated a certificate chain path length in the basic constraints that was exceeded");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainPathLenExceededConstraintsFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainConstraintsConversionFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which couldn't be converted to be checked for basic constraints.");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainConstraintsConversionFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainUnrecognizedExtensionFailure(SSLSocket sSLSocket, String string) {
        String string2 = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string2 + " contained a V3 certificate with unrecognized critical extension: " + string);
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainUnrecognizedExtensionFailureLoggable((String)string2, (String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainAlgKeyUsageFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 certificate which key usage constraints indicate" + " its key cannot be used in quality required by the key agreement algorithm");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainAlgKeyUsageFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainCheckKeyUsageFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "Cannot check key usage constraints of certificate recieved from " + string + " because of the failure to determine the key agreement algorithm");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainCheckKeyUsageFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificateChainCertSignKeyUsageFailure(SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "The certificate chain received from " + string + " contained a V3 CA certificate which key usage constraints indicate" + " its key cannot be used to sign certificates");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificateChainCertSignKeyUsageFailureLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logCertificatePolicyIdDoesntExistIntheList(SSLSocket sSLSocket, String string) {
        String string2 = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "Certificate Policies Extension Processing Failed,PolicyId: " + string + " doesn't Exist in the allowed list");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logCertificatePolicyIdDoesntExistIntheListLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static void logPolicyQualifierIdNotCPS(SSLSocket sSLSocket, String string) {
        String string2 = SSLSetup.getPeerName(sSLSocket);
        SSLSetup.debug(2, "PolicyQualifier Id Found in the Certificate" + string + " doesn't match with CPS Qualifier Id");
        if (SSLSetup.logSSLRejections()) {
            Loggable loggable = SecurityLogger.logPolicyQualifierIdNotCPSLoggable((String)string);
            loggable.log();
            SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
        }
    }

    public static String getPeerName(SSLSocket sSLSocket) {
        InetAddress inetAddress;
        String string = "unknown";
        if (sSLSocket != null && (inetAddress = sSLSocket.getInetAddress()) != null) {
            try {
                string = inetAddress.getHostName() + " - " + inetAddress.getHostAddress();
            }
            catch (SecurityException securityException) {
                string = inetAddress.getHostAddress();
            }
            if (string == null) {
                string = inetAddress.toString();
            }
        }
        return string;
    }

    public static void logAlertReceivedFromPeer(SSLSocket sSLSocket, int n) {
        if (!SSLSetup.logSSLRejections() || n == 0 || n == 90) {
            return;
        }
        String string = SSLSetup.getPeerName(sSLSocket);
        Loggable loggable = null;
        switch (n) {
            case 10: {
                loggable = SecurityLogger.logUnexpectedMessageAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 20: {
                loggable = SecurityLogger.logBadRecordMacAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 21: {
                loggable = SecurityLogger.logDecryptionFailedAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 22: {
                loggable = SecurityLogger.logRecordOverFlowAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 30: {
                loggable = SecurityLogger.logDecompressionFailureAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 40: {
                loggable = SecurityLogger.logHandshakeFailureAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 47: {
                loggable = SecurityLogger.logIllegalParameterAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 50: {
                loggable = SecurityLogger.logDecodeErrorAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 51: {
                loggable = SecurityLogger.logDecryptErrorAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 60: {
                loggable = SecurityLogger.logExportRestrictionAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 80: {
                loggable = SecurityLogger.logInternalErrorAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 49: {
                loggable = SecurityLogger.logAccessDeniedAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 71: {
                loggable = SecurityLogger.logInsufficientSecurityAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 41: {
                loggable = SecurityLogger.logNoCertificateAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 42: {
                loggable = SecurityLogger.logBadCertificateAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 43: {
                loggable = SecurityLogger.logUnsupportedCertificateAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 44: {
                loggable = SecurityLogger.logCertificateRevokedAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 45: {
                loggable = SecurityLogger.logCertificateExpiredAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 46: {
                loggable = SecurityLogger.logCertificateUnknownAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 48: {
                loggable = SecurityLogger.logUnknownCAAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 70: {
                loggable = SecurityLogger.logProtocolVersionAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            case 100: {
                loggable = SecurityLogger.logNoRenegotiationAlertReceivedFromPeerLoggable((String)string);
                break;
            }
            default: {
                loggable = SecurityLogger.logAlertReceivedFromPeerLoggable((String)string, (String)Integer.toString(n));
            }
        }
        loggable.log();
        SSLSetup.setFailureDetails(sSLSocket.getSession(), loggable.getMessage());
    }

    public static Properties getSSLTrustProperties(ServerMBean serverMBean) {
        Properties properties = new Properties();
        String string = serverMBean.getKeyStores();
        if ("DemoIdentityAndDemoTrust".equals(string)) {
            SSLSetup.add(properties, "TrustKeyStore", "DemoTrust");
            SSLSetup.add(properties, "JavaStandardTrustKeyStorePassPhrase", serverMBean.getJavaStandardTrustKeyStorePassPhrase());
        } else if ("CustomIdentityAndJavaStandardTrust".equals(string)) {
            SSLSetup.add(properties, "TrustKeyStore", "JavaStandardTrust");
            SSLSetup.add(properties, "JavaStandardTrustKeyStorePassPhrase", serverMBean.getJavaStandardTrustKeyStorePassPhrase());
        } else if ("CustomIdentityAndCustomTrust".equals(string)) {
            SSLSetup.add(properties, "TrustKeyStore", "CustomTrust");
            SSLSetup.add(properties, "CustomTrustKeyStoreFileName", serverMBean.getCustomTrustKeyStoreFileName());
            SSLSetup.add(properties, "CustomTrustKeyStoreType", serverMBean.getCustomTrustKeyStoreType());
            SSLSetup.add(properties, "CustomTrustKeyStorePassPhrase", serverMBean.getCustomTrustKeyStorePassPhrase());
        } else if (!"CustomIdentityAndCommandLineTrust".equals(string)) {
            throw new RuntimeException(SecurityLogger.getAssertionIllegalKeystoresValue((String)string));
        }
        return properties;
    }

    static boolean isFatClient() {
        return !Kernel.isServer();
    }

    public static void logSSLUsingNullCipher() {
        SecurityLogger.logSSLUsingNullCipher();
    }

    private static void add(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    static {
        if (!Kernel.isServer()) {
            SecurityUtils.turnOffCryptoJDefaultJCEVerification();
            SecurityUtils.changeCryptoJDefaultPRNG();
        }
    }
}

