/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import weblogic.security.shared.LoggerWrapper;

public class SSLSetupLogging {
    public static final int DEBUG_FATAL = 0;
    public static final int DEBUG_ERROR = 1;
    public static final int DEBUG_WARN = 2;
    public static final int DEBUG_INFO = 3;
    private static LoggerWrapper LOGGER = LoggerWrapper.getInstance("SecuritySSL");
    private static LoggerWrapper EATENLOGGER = LoggerWrapper.getInstance("SecuritySSLEaten");
    private static int debugLevel = 0;

    public static boolean getDebugEaten() {
        return EATENLOGGER.isDebugEnabled();
    }

    public static final boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    public static final boolean isDebugEnabled(int n) {
        return LOGGER.isDebugEnabled();
    }

    public static final void info(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string);
        }
    }

    public static final void info(Throwable throwable, String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string, throwable);
        }
    }

    public static final void debug(int n, String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string);
        }
    }

    public static final void debug(int n, boolean bl, String string) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        if (bl) {
            Throwable throwable = new Throwable("Stack trace");
            LOGGER.debug(string, throwable);
        } else {
            LOGGER.debug(string);
        }
    }

    public static final void debug(int n, Throwable throwable, String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string, throwable);
        }
    }

    protected static synchronized void debug(String string, Throwable throwable) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string, throwable);
        }
    }

    public static boolean logSSLRejections() {
        return true;
    }

    public static void debugPrivateKey(PrivateKey privateKey) {
        if (SSLSetupLogging.isDebugEnabled()) {
            String string = "Private key dump\n   Key info: " + privateKey;
            if (privateKey instanceof RSAPrivateCrtKey) {
                string = string + "   is a java.security.interfaces.RSAPrivateCrtKey";
            } else if (privateKey instanceof RSAPrivateKey) {
                string = string + "   is a java.security.interfaces.RSAPrivateKey";
            }
            SSLSetupLogging.debug(3, string);
        }
    }
}

