/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.net.InetAddress;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.security.SSL.CertPathTrustManager;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLTruster;
import weblogic.security.utils.TrustManagerEnvironment;

public class SSLTrustValidator
implements SSLTruster {
    private boolean peerCertsRequired = false;
    private boolean overrideAllowed = true;
    private TrustManager trustManager = null;
    private byte[][] rootCAFingerPrints = null;
    private String proxyHostName = null;
    private String urlHostName = null;

    public SSLTrustValidator() {
        if (Kernel.isServer()) {
            this.setTrustManager(new CertPathTrustManager());
        }
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setRootCAFingerPrints(byte[][] byArray) {
        this.rootCAFingerPrints = byArray;
    }

    public void setPeerCertsRequired(boolean bl) {
        this.peerCertsRequired = bl;
    }

    public boolean isPeerCertsRequired() {
        return this.peerCertsRequired;
    }

    public void setAllowOverride(boolean bl) {
        this.overrideAllowed = bl;
    }

    public void setProxyMapping(String string, String string2) {
        this.urlHostName = string2;
        this.proxyHostName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validationCallback(X509Certificate[] x509CertificateArray, int n, SSLSocket sSLSocket, X509Certificate[] x509CertificateArray2) {
        int n2;
        boolean bl = SSLSetup.isDebugEnabled();
        int n3 = n;
        if (bl) {
            SSLSetup.info("validationCallback: validateErr = " + n3);
            if (x509CertificateArray != null) {
                for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                    SSLSetup.info("  cert[" + n2 + "] = " + x509CertificateArray[n2]);
                }
            }
        }
        if ((n3 & 0x10) != 0 && this.rootCAFingerPrints != null && x509CertificateArray != null && x509CertificateArray.length > 0) {
            try {
                byte[] byArray = SSLCertUtility.getFingerprint(x509CertificateArray[x509CertificateArray.length - 1]);
                for (int i = 0; i < this.rootCAFingerPrints.length; ++i) {
                    if (!Arrays.equals(byArray, this.rootCAFingerPrints[i])) continue;
                    n3 &= 0xFFFFFFEB;
                    if (bl) {
                        SSLSetup.info("Untrusted cert now trusted by legacy check");
                    }
                    break;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                SSLSetup.debug(1, certificateEncodingException, "Error while getting encoded certificate during trust validation");
            }
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (this.peerCertsRequired) {
                if (bl) {
                    SSLSetup.info("Required peer certificates not supplied by peer");
                }
                n3 |= 4;
            } else {
                if (bl) {
                    SSLSetup.info("Peer certificates are not required and were not supplied by peer");
                }
                n3 = 0;
            }
        }
        if (this.trustManager != null) {
            TrustManagerEnvironment.push(x509CertificateArray2, sSLSocket);
            n2 = 0;
            try {
                n2 = this.trustManager.certificateCallback(x509CertificateArray, n3) ? 1 : 0;
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                TrustManagerEnvironment.pop();
                throw throwable;
            }
            TrustManagerEnvironment.pop();
            if (n2 == 0 && n3 == 0) {
                n3 |= 0x20;
            }
            if (bl) {
                SSLSetup.info("weblogic user specified trustmanager validation status " + n3);
            }
        }
        if (n3 != 0) {
            this.logValidationError(n3, sSLSocket);
            if (!this.overrideAllowed) {
                if (bl) {
                    SSLSetup.info("User defined JSSE trustmanagers not allowed to override");
                }
                n3 |= 0x40;
            }
        }
        if (bl) {
            SSLSetup.info("SSLTrustValidator returns: " + n3);
        }
        return n3;
    }

    private String getTrustManagerClassName() {
        return this.trustManager != null ? this.trustManager.getClass().getName() : null;
    }

    private String getPeerName(SSLSocket sSLSocket) {
        InetAddress inetAddress;
        String string = SSLSetup.getPeerName(sSLSocket);
        if (this.proxyHostName != null && this.urlHostName != null && (inetAddress = sSLSocket.getInetAddress()) != null && (this.proxyHostName.equals(inetAddress.getHostName()) || this.proxyHostName.equals(inetAddress.getHostAddress()))) {
            string = string + " --> " + this.urlHostName;
        }
        return string;
    }

    private void logValidationError(int n, SSLSocket sSLSocket) {
        if (SSLSetup.logSSLRejections()) {
            String string = this.getPeerName(sSLSocket);
            Loggable[] loggableArray = new Loggable[5];
            int n2 = 0;
            if ((n & 1) != 0) {
                loggableArray[n2++] = SecurityLogger.logHandshakeCertInvalidErrorLoggable((String)string);
            }
            if ((n & 2) != 0) {
                loggableArray[n2++] = SecurityLogger.logHandshakeCertExpiredErrorLoggable((String)string);
            }
            if ((n & 4) != 0) {
                Loggable loggable = loggableArray[n2++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertIncompleteErrorLoggable((String)string) : SecurityLogger.logHandshakeCertIncompleteErrorLoggable((String)string);
            }
            if ((n & 0x10) != 0) {
                Loggable loggable = loggableArray[n2++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertUntrustedErrorLoggable((String)string) : SecurityLogger.logHandshakeCertUntrustedErrorLoggable((String)string);
            }
            if ((n & 0x20) != 0) {
                Loggable loggable = loggableArray[n2++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertValidationErrorLoggable((String)string, (String)this.getTrustManagerClassName()) : SecurityLogger.logHandshakeCertValidationErrorLoggable((String)string, (String)this.getTrustManagerClassName());
            }
            if (n2 > 0) {
                StringBuffer stringBuffer = null;
                if (sSLSocket != null) {
                    stringBuffer = new StringBuffer();
                }
                for (int i = 0; i < n2; ++i) {
                    loggableArray[i].log();
                    if (sSLSocket == null) continue;
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(loggableArray[i].getMessage());
                }
                if (sSLSocket != null) {
                    SSLSetup.setFailureDetails(sSLSocket.getSession(), stringBuffer.toString());
                }
            }
        }
        if (SSLSetup.isDebugEnabled()) {
            SSLSetup.info("Validation error = " + n);
            if ((n & 1) != 0) {
                SSLSetup.info("Certificate chain is invalid");
            }
            if ((n & 2) != 0) {
                SSLSetup.info("Expired certificate");
            }
            if ((n & 4) != 0) {
                SSLSetup.info("Certificate chain is incomplete");
            }
            if ((n & 0x10) != 0) {
                SSLSetup.info("Certificate chain is untrusted");
            }
            if ((n & 0x20) != 0) {
                SSLSetup.info("Certificate chain was not validated by the custom trust manager even though built-in SSL validated it.");
            }
        }
    }
}

