/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Locale;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.SSL.HostnameVerifierJSSE;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLHostnameVerifier;
import weblogic.security.utils.SSLSetup;
import weblogic.utils.NestedRuntimeException;

public class SSLWLSHostnameVerifier
implements SSLHostnameVerifier {
    private static final String IGNORE_VERIFICATION_PROP = "weblogic.security.SSL.ignoreHostnameVerification";
    private static final String IGNORE_VERIFICATION2_PROP = "weblogic.security.SSL.ignoreHostnameVerify";
    private static final String VERIFIER_CLASS_PROP = "weblogic.security.SSL.hostnameVerifier";
    private static final String REVERSE_DNS_ALLOWED_PROP = "weblogic.ReverseDNSAllowed";
    private String urlHostName = null;
    private String proxyHostName = null;
    private static HostnameVerifier defaultVerifier = null;
    private HostnameVerifier verifier = SSLWLSHostnameVerifier.getDefaultVerifer();
    private String expectedName = null;

    public boolean hostnameValidationCallback(String string, SSLSocket sSLSocket) {
        SSLSession sSLSession = sSLSocket.getSession();
        boolean bl = this.isProxying(string, sSLSocket);
        if (bl) {
            string = this.urlHostName;
        }
        try {
            boolean bl2;
            boolean bl3 = SSLSetup.isDebugEnabled(3);
            if (bl3) {
                SSLSetup.info("Performing hostname validation checks: " + string);
                if (bl) {
                    SSLSetup.info("Proxying through " + this.proxyHostName);
                }
            }
            if (!(bl2 = this.verifier.verify(string, sSLSession))) {
                if (SSLSetup.logSSLRejections()) {
                    String string2 = this.getPeerName(bl, sSLSocket);
                    Loggable loggable = SecurityLogger.logHostnameVerificationErrorLoggable((String)string2, (String)SSLCertUtility.getCommonName(sSLSession), (String)string);
                    loggable.log();
                    SSLSetup.setFailureDetails(sSLSession, loggable.getMessage());
                }
                if (bl3) {
                    SSLSetup.info("Hostname Verification failed for certificate with CommonName '" + SSLCertUtility.getCommonName(sSLSession) + "' against hostname: " + string);
                }
                return false;
            }
            if (this.expectedName != null) {
                X509Certificate x509Certificate = SSLCertUtility.getPeerLeafCert(sSLSocket);
                if (x509Certificate == null) {
                    if (SSLSetup.logSSLRejections()) {
                        String string3 = this.getPeerName(bl, sSLSocket);
                        Loggable loggable = SecurityLogger.logHostnameVerificationNoCertificateErrorLoggable((String)string3);
                        loggable.log();
                        SSLSetup.setFailureDetails(sSLSession, loggable.getMessage());
                    }
                    if (bl3) {
                        SSLSetup.info("No identity certificate, cannot verify expected name: " + this.expectedName);
                    }
                    return false;
                }
                String string4 = SSLCertUtility.getCommonName(sSLSession);
                if (!this.expectedName.equals(string4)) {
                    if (SSLSetup.logSSLRejections()) {
                        String string5 = this.getPeerName(bl, sSLSocket);
                        Loggable loggable = SecurityLogger.logHostnameVerificationErrorLoggable((String)string5, (String)string4, (String)this.expectedName);
                        loggable.log();
                        SSLSetup.setFailureDetails(sSLSession, loggable.getMessage());
                    }
                    if (bl3) {
                        SSLSetup.info("Hostname Verification failed since certificate CommonName '" + string4 + "' does not match expected name: " + this.expectedName);
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            if (SSLSetup.logSSLRejections()) {
                String string6 = this.getPeerName(bl, sSLSocket);
                Loggable loggable = SecurityLogger.logHostnameVerificationExceptionErrorLoggable((String)string6);
                loggable.log();
                SSLSetup.setFailureDetails(sSLSession, loggable.getMessage());
            }
            SSLSetup.debug(1, exception, "Hostname Verification error");
            return false;
        }
    }

    private boolean isProxying(String string, SSLSocket sSLSocket) {
        if (this.proxyHostName != null && this.urlHostName != null) {
            if (this.proxyHostName.equals(string)) {
                return true;
            }
            InetAddress inetAddress = sSLSocket.getInetAddress();
            if (inetAddress != null && (this.proxyHostName.equals(inetAddress.getHostAddress()) || this.proxyHostName.equals(inetAddress.getHostName()))) {
                return true;
            }
        }
        return false;
    }

    private String getPeerName(boolean bl, SSLSocket sSLSocket) {
        String string = SSLSetup.getPeerName(sSLSocket);
        if (bl) {
            string = string + " --> " + this.urlHostName;
        }
        return string;
    }

    public void setExpectedName(String string) {
        this.expectedName = string;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.verifier = hostnameVerifier != null ? hostnameVerifier : defaultVerifier;
    }

    private static synchronized HostnameVerifier getDefaultVerifer() {
        if (defaultVerifier == null) {
            HostnameVerifier hostnameVerifier = null;
            KernelMBean kernelMBean = Kernel.getConfig();
            SSLMBean sSLMBean = null;
            if (kernelMBean != null) {
                sSLMBean = kernelMBean.getSSL();
            }
            if (SSLWLSHostnameVerifier.isHostnameVerificationIgnored(sSLMBean)) {
                hostnameVerifier = new NullHostnameVerifier();
            } else {
                String string = SSLWLSHostnameVerifier.getHostnameVerifierClassName(sSLMBean);
                if (string == null) {
                    if (SSLSetup.isDebugEnabled(3)) {
                        SSLSetup.info("HostnameVerifier: using default hostnameverifier");
                    }
                    hostnameVerifier = new DefaultHostnameVerifier();
                    Loggable loggable = SecurityLogger.logUsingDefaultHVLoggable();
                    loggable.log();
                } else {
                    Object var4_5 = null;
                    try {
                        var4_5 = Class.forName(string).newInstance();
                    }
                    catch (Exception exception) {
                        Loggable loggable = SecurityLogger.logHostnameVerifierInitErrorLoggable((String)string);
                        loggable.log();
                        throw new NestedRuntimeException(loggable.getMessage(), (Throwable)exception);
                    }
                    if (var4_5 instanceof HostnameVerifier) {
                        hostnameVerifier = var4_5;
                        if (SSLSetup.isDebugEnabled(3)) {
                            SSLSetup.info("HostnameVerifier: using configured hostnameverifier: " + hostnameVerifier.getClass().getName());
                        }
                        Loggable loggable = SecurityLogger.logUsingConfiguredHVLoggable((String)hostnameVerifier.getClass().getName());
                        loggable.log();
                    } else if (var4_5 instanceof HostnameVerifierJSSE) {
                        final HostnameVerifierJSSE hostnameVerifierJSSE = var4_5;
                        hostnameVerifier = new HostnameVerifier(){

                            public boolean verify(String string, SSLSession sSLSession) {
                                return hostnameVerifierJSSE.verify(string, SSLCertUtility.getCommonName(sSLSession));
                            }
                        };
                        Loggable loggable = SecurityLogger.logUsingConfiguredHVLoggable((String)hostnameVerifier.getClass().getName());
                        loggable.log();
                        if (SSLSetup.isDebugEnabled(3)) {
                            SSLSetup.info("HostnameVerifier: using configured hostnameverifier: " + hostnameVerifier.getClass().getName());
                        }
                    } else {
                        Loggable loggable = SecurityLogger.logHostnameVerifierInvalidErrorLoggable((String)string);
                        loggable.log();
                        throw new NestedRuntimeException(loggable.getMessage());
                    }
                }
            }
            if (sSLMBean == null && Kernel.isServer()) {
                return hostnameVerifier;
            }
            defaultVerifier = hostnameVerifier;
        }
        return defaultVerifier;
    }

    private static boolean isHostnameVerificationIgnored(SSLMBean sSLMBean) {
        boolean bl = false;
        try {
            bl = sSLMBean != null && sSLMBean.isHostnameVerificationIgnored() || Boolean.getBoolean(IGNORE_VERIFICATION_PROP) || Boolean.getBoolean(IGNORE_VERIFICATION2_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bl;
    }

    public void setProxyMapping(String string, String string2) {
        this.urlHostName = string2;
        this.proxyHostName = string;
    }

    private static String getHostnameVerifierClassName(SSLMBean sSLMBean) {
        String string = null;
        try {
            string = System.getProperty(VERIFIER_CLASS_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null && sSLMBean != null) {
            string = sSLMBean.getHostnameVerifier();
        }
        return string;
    }

    public static class NullHostnameVerifier
    implements HostnameVerifier {
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    public static class DefaultHostnameVerifier
    implements HostnameVerifier {
        private static final String LOCALHOST_HOSTNAME = "localhost";
        private static final String LOCALHOST_IPADDRESS = "127.0.0.1";
        private boolean allowReverseDNS = false;

        public DefaultHostnameVerifier() {
            if (!Kernel.isApplet() && System.getProperty(SSLWLSHostnameVerifier.REVERSE_DNS_ALLOWED_PROP) != null) {
                this.allowReverseDNS = Boolean.getBoolean(SSLWLSHostnameVerifier.REVERSE_DNS_ALLOWED_PROP);
            } else if (Kernel.getConfig() != null) {
                this.allowReverseDNS = Kernel.getConfig().isReverseDNSAllowed();
            }
            if (SSLSetup.isDebugEnabled(3)) {
                SSLSetup.info("HostnameVerifier: allowReverseDNS=" + this.allowReverseDNS);
            }
        }

        public boolean verify(String string, SSLSession sSLSession) {
            if (string == null || string.length() == 0) {
                return false;
            }
            String string2 = SSLCertUtility.getCommonName(sSLSession);
            if (this.doVerify(string, sSLSession, string2)) {
                return true;
            }
            Collection collection = SSLCertUtility.getDNSSubjAltNames(sSLSession);
            return this.doDNSSubjAltNamesVerify(string, collection);
        }

        private boolean doVerify(String string, SSLSession sSLSession, String string2) {
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            Serializable serializable = SSLCertUtility.getPeerLeafCert(sSLSession);
            if (DefaultHostnameVerifier.isDemoCert((X509Certificate)serializable) && string.toLowerCase(Locale.ENGLISH).startsWith(string2.toLowerCase(Locale.ENGLISH) + ".")) {
                return true;
            }
            try {
                serializable = InetAddress.getLocalHost();
                String string3 = ((InetAddress)serializable).getHostName();
                if (string3.equalsIgnoreCase(string2)) {
                    InetAddress inetAddress;
                    if (((InetAddress)serializable).getHostAddress().equalsIgnoreCase(string)) {
                        return true;
                    }
                    if (this.allowReverseDNS ? (inetAddress = InetAddress.getByName(string)).isLoopbackAddress() : LOCALHOST_HOSTNAME.equalsIgnoreCase(string) || LOCALHOST_IPADDRESS.equalsIgnoreCase(string)) {
                        return true;
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                SSLSetup.info("HostnameVerifier: unknown host");
            }
            return false;
        }

        private boolean doDNSSubjAltNamesVerify(String string, Collection collection) {
            if (collection != null && !collection.isEmpty()) {
                for (String string2 : collection) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isDemoCert(X509Certificate x509Certificate) {
            String string = x509Certificate.getIssuerDN().getName();
            String string2 = x509Certificate.getSubjectDN().getName();
            return "C=US, ST=MyState, L=MyTown, O=MyOrganization, OU=FOR TESTING ONLY, CN=CertGenCAB".equalsIgnoreCase(string) && string2.startsWith("C=US, ST=MyState, L=MyTown, O=MyOrganization, OU=FOR TESTING ONLY");
        }
    }
}

