/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import javax.net.ssl.SSLSession;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLWLSHostnameVerifier;

public class SSLWLSWildcardHostnameVerifier
extends SSLWLSHostnameVerifier.DefaultHostnameVerifier {
    public SSLWLSWildcardHostnameVerifier() {
        if (SSLSetup.isDebugEnabled(3)) {
            SSLSetup.info("HostnameVerifier: allowing wildcarded certificates");
        }
    }

    public boolean verify(String string, SSLSession sSLSession) {
        if (string == null || sSLSession == null) {
            return false;
        }
        String string2 = SSLCertUtility.getCommonName(sSLSession);
        if (string2 == null || string2.length() == 0) {
            return super.verify(string, sSLSession);
        }
        if (SSLWLSWildcardHostnameVerifier.isLegalWildcarded(string, string2)) {
            return true;
        }
        return super.verify(string, sSLSession);
    }

    private static boolean isLegalWildcarded(String string, String string2) {
        if (string2.indexOf("*") == -1) {
            if (SSLSetup.isDebugEnabled(3)) {
                SSLSetup.info("HostnameVerifier: no wildcard present, wildcard validation not performed.");
            }
            return false;
        }
        return string2.indexOf(".") != string2.lastIndexOf(".") && string2.startsWith("*.") && string2.indexOf("*") == string2.lastIndexOf("*") && SSLWLSWildcardHostnameVerifier.domainMatchesDomain(string2, string);
    }

    private static boolean domainMatchesDomain(String string, String string2) {
        int n = string.indexOf("*");
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(n + 1).toLowerCase();
        String string4 = string2.toLowerCase();
        if (!string4.endsWith(string3)) {
            return false;
        }
        if (string4.lastIndexOf(string3) == -1) {
            return false;
        }
        String string5 = string4.substring(0, string4.length() - string3.length());
        if (string5.length() <= 0) {
            return false;
        }
        return string5.indexOf(".") == -1;
    }
}

