/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.Security;
import weblogic.security.SecurityLogger;
import weblogic.security.service.ContextHandler;
import weblogic.security.shared.LoggerWrapper;

public abstract class SecurityUtils {
    private static final boolean DUMP_CTX = Boolean.getBoolean("weblogic.security.DumpContextHandler");

    public static boolean logContextHandlerEnabled() {
        return DUMP_CTX;
    }

    public static void logContextHandler(String string, LoggerWrapper loggerWrapper, ContextHandler contextHandler) {
        if (loggerWrapper == null) {
            return;
        }
        if (contextHandler == null) {
            if (loggerWrapper.isDebugEnabled()) {
                loggerWrapper.debug("ContextHandler for " + string + "is null.");
            }
            return;
        }
        if (loggerWrapper.isDebugEnabled()) {
            String[] stringArray = contextHandler.getNames();
            loggerWrapper.debug("Logging ContextHandler for " + string);
            for (int i = 0; i < stringArray.length; ++i) {
                loggerWrapper.debug("\t" + stringArray[i] + "=" + contextHandler.getValue(stringArray[i]).toString());
            }
        }
    }

    private static boolean setCryptoJSecurityProperty(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = Security.getProperty(string);
        if (!(string4 != null && string4.trim().length() != 0 || Boolean.getBoolean(string3))) {
            Security.setProperty(string, string2);
            bl = true;
        }
        return bl;
    }

    public static void turnOffCryptoJDefaultJCEVerification() {
        String string = "com.rsa.cryptoj.jce.no.verify.jar";
        String string2 = "weblogic.security.allowCryptoJDefaultJCEVerification";
        if (SecurityUtils.setCryptoJSecurityProperty(string, "true", string2)) {
            SecurityLogger.logDisallowingCryptoJDefaultJCEVerification((String)string2);
        }
    }

    public static void changeCryptoJDefaultPRNG() {
        String string = "weblogic.security.allowCryptoJDefaultPRNG";
        String string2 = "com.rsa.crypto.default.random";
        String string3 = "ECDRBG";
        String string4 = "FIPS186PRNG";
        if (SecurityUtils.setCryptoJSecurityProperty(string2, string4, string)) {
            SecurityLogger.logChangingCryptoJDefaultPRNG((String)string, (String)string3, (String)string4);
        }
    }
}

