/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;

public final class TrustManagerEnvironment {
    private static ThreadLocal threadInstance = new ThreadLocal();
    private TrustManagerEnvironment parentEnv;
    private X509Certificate[] trustedCAs;
    private SSLSocket sslSocket;

    public static void push(X509Certificate[] x509CertificateArray, SSLSocket sSLSocket) {
        TrustManagerEnvironment trustManagerEnvironment = new TrustManagerEnvironment(TrustManagerEnvironment.getInstance(), x509CertificateArray, sSLSocket);
        threadInstance.set(trustManagerEnvironment);
    }

    public static void pop() {
        TrustManagerEnvironment trustManagerEnvironment = TrustManagerEnvironment.getInstance();
        if (trustManagerEnvironment == null) {
            return;
        }
        threadInstance.set(trustManagerEnvironment._getParentEnv());
    }

    public static X509Certificate[] getTrustedCAs() {
        TrustManagerEnvironment trustManagerEnvironment = TrustManagerEnvironment.getInstance();
        return trustManagerEnvironment == null ? null : trustManagerEnvironment._getTrustedCAs();
    }

    public static SSLSocket getSSLSocket() {
        TrustManagerEnvironment trustManagerEnvironment = TrustManagerEnvironment.getInstance();
        return trustManagerEnvironment == null ? null : trustManagerEnvironment._getSSLSocket();
    }

    private static TrustManagerEnvironment getInstance() {
        return (TrustManagerEnvironment)threadInstance.get();
    }

    private TrustManagerEnvironment(TrustManagerEnvironment trustManagerEnvironment, X509Certificate[] x509CertificateArray, SSLSocket sSLSocket) {
        this.parentEnv = trustManagerEnvironment;
        this.trustedCAs = x509CertificateArray;
        this.sslSocket = sSLSocket;
    }

    private TrustManagerEnvironment _getParentEnv() {
        return this.parentEnv;
    }

    private X509Certificate[] _getTrustedCAs() {
        return this.trustedCAs;
    }

    private SSLSocket _getSSLSocket() {
        return this.sslSocket;
    }
}

