/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import weblogic.security.SecurityMessagesTextFormatter;

public class X509Utils {
    private static SecurityMessagesTextFormatter formatter = SecurityMessagesTextFormatter.getInstance();

    public static boolean isEmpty(CertPath certPath) {
        List<? extends Certificate> list;
        return certPath == null || (list = certPath.getCertificates()) == null || list.size() <= 0;
    }

    public static boolean containsNonX509Certificate(CertPath certPath) {
        if (X509Utils.isEmpty(certPath)) {
            return false;
        }
        List<? extends Certificate> list = certPath.getCertificates();
        for (int i = 0; i < list.size(); ++i) {
            Certificate certificate = list.get(i);
            if (certificate instanceof X509Certificate) continue;
            return true;
        }
        return false;
    }

    public static X509Certificate[] getCertificates(CertPath certPath) {
        if (X509Utils.isEmpty(certPath)) {
            return new X509Certificate[0];
        }
        List<? extends Certificate> list = certPath.getCertificates();
        return list.toArray(new X509Certificate[list.size()]);
    }

    public static void validateOrdered(CertPath certPath) throws CertificateException {
        if (X509Utils.isEmpty(certPath)) {
            return;
        }
        if (X509Utils.containsNonX509Certificate(certPath)) {
            throw new AssertionError((Object)"Received a cert path containing a non-X509 certificate");
        }
        X509Certificate[] x509CertificateArray = X509Utils.getCertificates(certPath);
        if (x509CertificateArray == null || x509CertificateArray.length < 2) {
            return;
        }
        for (int i = 0; i < x509CertificateArray.length - 1; ++i) {
            if (X509Utils.isSelfSigned(x509CertificateArray[i])) {
                throw new CertificateException(formatter.getSelfSignedCertificateInChainError(x509CertificateArray[i].toString()));
            }
            X509Utils.validateIssuedBy(x509CertificateArray[i], x509CertificateArray[i + 1]);
        }
    }

    public static boolean isOrdered(CertPath certPath) {
        try {
            X509Utils.validateOrdered(certPath);
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public static String getName(X500Principal x500Principal) {
        return x500Principal != null ? x500Principal.getName("RFC2253") : null;
    }

    public static boolean sameX500Principal(X500Principal x500Principal, X500Principal x500Principal2) {
        String string;
        if (x500Principal == null && x500Principal2 == null) {
            return true;
        }
        if (x500Principal != null && x500Principal2 == null) {
            return false;
        }
        if (x500Principal == null && x500Principal2 != null) {
            return false;
        }
        String string2 = X509Utils.getName(x500Principal);
        return string2.equals(string = X509Utils.getName(x500Principal2));
    }

    public static String getSubjectDN(X509Certificate x509Certificate) {
        return X509Utils.getName(x509Certificate.getSubjectX500Principal());
    }

    public static String getIssuerDN(X509Certificate x509Certificate) {
        return X509Utils.getName(x509Certificate.getIssuerX500Principal());
    }

    public static void validateIssuedBy(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertificateException {
        if (!X509Utils.getIssuerDN(x509Certificate).equals(X509Utils.getSubjectDN(x509Certificate2))) {
            throw new CertificateException(formatter.getIssuerDNMismatchError(x509Certificate.toString(), x509Certificate2.toString()));
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        catch (Exception exception) {
            throw new CertificateException(formatter.getCertificateNotSignedByIssuerError(x509Certificate.toString(), x509Certificate2.toString()));
        }
    }

    public static boolean isIssuedBy(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            X509Utils.validateIssuedBy(x509Certificate, x509Certificate2);
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public static boolean isSelfSigned(X509Certificate x509Certificate) {
        return X509Utils.isIssuedBy(x509Certificate, x509Certificate);
    }
}

