/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.AdminServerListener;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class AdminServerListenerService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean started;

    public void start() throws ServiceFailureException {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            this.initializeAdminServerListener();
            started = true;
        }
    }

    private void initializeAdminServerListener() throws ServiceFailureException {
        try {
            AdminServerListener.start((boolean)ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable());
        }
        catch (Exception exception) {
            throw new ServiceFailureException(exception.getMessage(), (Throwable)exception);
        }
    }

    public static boolean isAdminServerAvailable() {
        if (!started) {
            throw new IllegalStateException("AdminServerListenerService is not yet started !");
        }
        return AdminServerListener.isAdminServerAvailable();
    }
}

