/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CoherenceServerMBean;
import weblogic.management.configuration.CoherenceServerStartMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.runtime.CoherenceServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.CoherenceServerLifeCycleTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.server.CoherenceServerLifeCycleTaskRuntime;
import weblogic.server.ServerLifecycleException;
import weblogic.work.ContextWrap;
import weblogic.work.WorkManagerFactory;

public class CoherenceServerLifeCycleRuntime
extends DomainRuntimeMBeanDelegate
implements CoherenceServerLifeCycleRuntimeMBean {
    private static final int TASK_AFTERLIFE_TIME_MILLIS = 1800000;
    private final Set<CoherenceServerLifeCycleTaskRuntime> tasks;
    private final String serverName;
    private final CoherenceServerMBean serverMBean;
    private String oldState;
    private String currentState;
    private int startCount;

    CoherenceServerLifeCycleRuntime(CoherenceServerMBean coherenceServerMBean) throws ManagementException {
        super(coherenceServerMBean.getName());
        this.serverMBean = coherenceServerMBean;
        this.tasks = Collections.synchronizedSet(new HashSet());
        this.serverName = coherenceServerMBean.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldServerLifeCycleTaskRuntimes() {
        Set<CoherenceServerLifeCycleTaskRuntime> set = this.tasks;
        synchronized (set) {
            Iterator<CoherenceServerLifeCycleTaskRuntime> iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime = iterator.next();
                if (coherenceServerLifeCycleTaskRuntime.getEndTime() <= 0L || System.currentTimeMillis() - coherenceServerLifeCycleTaskRuntime.getEndTime() <= 1800000L) continue;
                try {
                    coherenceServerLifeCycleTaskRuntime.unregister();
                }
                catch (ManagementException managementException) {
                    // empty catch block
                }
                iterator.remove();
            }
        }
    }

    public CoherenceServerLifeCycleTaskRuntimeMBean forceShutdown() throws ServerLifecycleException {
        try {
            if (this.getState() == "SHUTDOWN") {
                throw new ServerLifecycleException("Can not get to the relevant ServerRuntimeMBean for server " + this.serverName + ". Server is in SHUTDOWN state and cannot be reached.");
            }
            CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime = new CoherenceServerLifeCycleTaskRuntime(this, "Forcefully shutting down " + this.serverName + " server ...", "forceShutdown");
            this.tasks.add(coherenceServerLifeCycleTaskRuntime);
            ShutdownRequest shutdownRequest = new ShutdownRequest(coherenceServerLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(shutdownRequest)));
            CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime2 = coherenceServerLifeCycleTaskRuntime;
            Object var5_5 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return coherenceServerLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public int getNodeManagerRestartCount() {
        return this.startCount > 0 ? this.startCount - 1 : 0;
    }

    public String getState() {
        String string = this.getStateNodeManager();
        if (string == null || "UNKNOWN".equalsIgnoreCase(string)) {
            string = "UNKNOWN";
        }
        this.clearOldServerLifeCycleTaskRuntimes();
        return string;
    }

    private String getStateNodeManager() {
        MachineMBean machineMBean = this.serverMBean.getMachine();
        if (machineMBean == null) {
            return null;
        }
        try {
            return NodeManagerRuntime.getInstance(machineMBean).getState(this.serverMBean);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getStateVal() {
        String string = this.getState().intern();
        if (string == "STARTING" || string == "FAILED_RESTARTING") {
            return 1;
        }
        if (string == "SHUTTING_DOWN") {
            return 7;
        }
        if (string == "FORCE_SHUTTING_DOWN") {
            return 18;
        }
        if (string == "STANDBY") {
            return 3;
        }
        if (string == "ADMIN") {
            return 17;
        }
        if (string == "SUSPENDING") {
            return 4;
        }
        if (string == "RESUMING") {
            return 6;
        }
        if (string == "RUNNING") {
            return 2;
        }
        if (string == "SHUTDOWN") {
            return 0;
        }
        if (string == "FAILED") {
            return 8;
        }
        if (string == "ACTIVATE_LATER") {
            return 13;
        }
        if (string == "FAILED_NOT_RESTARTABLE") {
            return 14;
        }
        if (string == "FAILED_MIGRATABLE") {
            return 15;
        }
        return 9;
    }

    public CoherenceServerLifeCycleTaskRuntimeMBean[] getTasks() {
        return this.tasks.toArray(new CoherenceServerLifeCycleTaskRuntimeMBean[this.tasks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String string) {
        CoherenceServerLifeCycleRuntime coherenceServerLifeCycleRuntime = this;
        synchronized (coherenceServerLifeCycleRuntime) {
            if (string == null || string.equalsIgnoreCase(this.currentState)) {
                return;
            }
            this.oldState = this.currentState;
            this.currentState = string;
            if ("SHUTTING_DOWN".equals(string) || "FORCE_SHUTTING_DOWN".equals(string) || "STARTING".equals(string) || "RESUMING".equals(string) || "RUNNING".equals(string)) {
                // empty if block
            }
        }
        this._postSet("State", this.oldState, this.currentState);
    }

    public CoherenceServerLifeCycleTaskRuntimeMBean start() throws ServerLifecycleException {
        try {
            CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime = new CoherenceServerLifeCycleTaskRuntime(this, "Starting " + this.serverName + " server ...", "start");
            this.tasks.add(coherenceServerLifeCycleTaskRuntime);
            this.startServer(coherenceServerLifeCycleTaskRuntime);
            CoherenceServerLifeCycleRuntime.updateTaskMBeanOnCompletion(coherenceServerLifeCycleTaskRuntime);
            CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime2 = coherenceServerLifeCycleTaskRuntime;
            Object var4_4 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return coherenceServerLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    private void startServer(CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime) {
        try {
            NodeManagerRuntime nodeManagerRuntime = null;
            nodeManagerRuntime = NodeManagerRuntime.getInstance(this.serverMBean);
            NodeManagerTask nodeManagerTask = nodeManagerRuntime.start(this.serverMBean);
            ++this.startCount;
            coherenceServerLifeCycleTaskRuntime.setNMTask(nodeManagerTask);
        }
        catch (SecurityException securityException) {
            coherenceServerLifeCycleTaskRuntime.setError(securityException);
        }
        catch (IOException iOException) {
            coherenceServerLifeCycleTaskRuntime.setError(iOException);
        }
    }

    void cleanup() {
    }

    private boolean useNodeManagerToShutdown() throws IOException {
        CoherenceServerStartMBean coherenceServerStartMBean = this.serverMBean.getCoherenceServerStart();
        if (coherenceServerStartMBean == null) {
            return false;
        }
        MachineMBean machineMBean = this.serverMBean.getMachine();
        if (machineMBean == null) {
            return false;
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
        if (nodeManagerRuntime == null) {
            return false;
        }
        nodeManagerRuntime.kill(this.serverMBean);
        return true;
    }

    private static void updateTaskMBeanOnCompletion(CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime) {
        if (coherenceServerLifeCycleTaskRuntime.getError() != null) {
            coherenceServerLifeCycleTaskRuntime.setStatus("FAILED");
        } else {
            coherenceServerLifeCycleTaskRuntime.setStatus("TASK COMPLETED");
        }
        coherenceServerLifeCycleTaskRuntime.setEndTime(System.currentTimeMillis());
        coherenceServerLifeCycleTaskRuntime.setIsRunning(false);
    }

    private final class ShutdownRequest
    implements Runnable {
        private final CoherenceServerLifeCycleTaskRuntime taskMBean;

        ShutdownRequest(CoherenceServerLifeCycleTaskRuntime coherenceServerLifeCycleTaskRuntime) {
            this.taskMBean = coherenceServerLifeCycleTaskRuntime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    CoherenceServerLifeCycleRuntime.this.useNodeManagerToShutdown();
                }
                catch (IOException iOException) {
                    this.taskMBean.setError(iOException);
                    Object var3_2 = null;
                    CoherenceServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                CoherenceServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                throw throwable;
            }
            CoherenceServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
        }
    }
}

