/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.security.AccessController;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.RemoteLifeCycleOperations;
import weblogic.server.ServerLifeCycleService;
import weblogic.server.ServerLifecycleException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class RemoteLifeCycleOperationsImpl
implements RemoteLifeCycleOperations {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugCategory debugSLC = Debug.getCategory((String)"weblogic.slc");

    public static RemoteLifeCycleOperationsImpl getInstance() {
        return Singleton.SINGLETON;
    }

    private RemoteLifeCycleOperationsImpl() {
    }

    public void shutdown() throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing shutdown(). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().shutdown();
    }

    public void shutdown(int n, boolean bl) throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing shutdown(timeout). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().shutdown(n, bl);
    }

    public void forceShutdown() throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing forceShutdown(). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().forceShutdown();
    }

    public void suspend() throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing suspend(). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().suspend();
    }

    public void suspend(int n, boolean bl) throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing suspend(timeout). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().suspend(n, bl);
    }

    public void forceSuspend() throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing forceSuspend(). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().forceSuspend();
    }

    public void resume() throws ServerLifecycleException {
        RemoteLifeCycleOperationsImpl.debug("executing resume(). Requested by '" + this.getUserName() + "'");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().resume();
    }

    public String getState() {
        RemoteLifeCycleOperationsImpl.debug("executing getState(). Requested by '" + this.getUserName() + "'");
        return ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getState();
    }

    public void setState(String string, String string2) {
        if (!ServerLifeCycleService.isStarted()) {
            return;
        }
        ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = ManagementService.getDomainAccess(kernelId).getDomainRuntime().lookupServerLifeCycleRuntime(string);
        RemoteLifeCycleOperationsImpl.debug("got slcRuntime '" + serverLifeCycleRuntimeMBean + "' for serverName '" + string + "'. Updating state to " + string2);
        if (serverLifeCycleRuntimeMBean == null) {
            RemoteLifeCycleOperationsImpl.debug("slcRuntime is null, cannot update state to " + string2);
            return;
        }
        serverLifeCycleRuntimeMBean.setState(string2);
    }

    public String getWeblogicHome() {
        RemoteLifeCycleOperationsImpl.debug("executing getWeblogicHome(). Requested by '" + this.getUserName() + "'");
        return ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getWeblogicHome();
    }

    public String getMiddlewareHome() {
        RemoteLifeCycleOperationsImpl.debug("executing getMiddlewareHome(). Requested by '" + this.getUserName() + "'");
        return ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getMiddlewareHome();
    }

    private static void debug(String string) {
        if (debugSLC.isEnabled()) {
            T3SrvrLogger.logDebugSLC((String)("<RemoteSLCOperationsImpl>" + string));
        }
    }

    private AuthenticatedSubject getUserName() {
        if (debugSLC.isEnabled()) {
            return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        }
        return null;
    }

    private static class Singleton {
        private static final RemoteLifeCycleOperationsImpl SINGLETON = new RemoteLifeCycleOperationsImpl();

        private Singleton() {
        }
    }
}

