/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.ManagementRuntimeException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.ServerStates;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.protocol.URLManager;
import weblogic.protocol.UnknownProtocolException;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.RemoteLifeCycleOperations;
import weblogic.server.RemoteLifeCycleOperationsImpl;
import weblogic.server.ServerLifeCycleTaskRuntime;
import weblogic.server.ServerLifecycleException;
import weblogic.server.ServerLogger;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentMapAsyncTX;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.ContextWrap;
import weblogic.work.WorkManagerFactory;

public final class ServerLifeCycleRuntime
extends DomainRuntimeMBeanDelegate
implements ServerLifeCycleRuntimeMBean,
ServerStates {
    private static final int TASK_AFTERLIFE_TIME_MILLIS = 1800000;
    private static final String SERVER_LIFECYCLE_STORE_NAME = "weblogic.server.lifecycle.store";
    private static final DebugCategory debug = Debug.getCategory((String)"weblogic.slcruntime");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final Set tasks = Collections.synchronizedSet(new HashSet());
    private final String serverName;
    private final ServerMBean serverMBean;
    private String oldState;
    private String currentState;
    private int startCount;
    private boolean stateShouldBeAvailable;
    private transient String cachedBulkQueryState;
    private static final PersistentMap pMap = ServerLifeCycleRuntime.initStore();
    private ServerProperties mCachedValue;
    private MachineMBean lastKnownMachine;

    ServerLifeCycleRuntime(ServerMBean serverMBean) throws ManagementException {
        super(serverMBean.getName());
        this.serverMBean = serverMBean;
        this.serverName = serverMBean.getName();
    }

    public ServerMBean getServerMBean() {
        return this.serverMBean;
    }

    static void cleanupStore(ServerMBean[] serverMBeanArray) {
        block7: {
            if (pMap == null) {
                return;
            }
            try {
                Set set = pMap.keySet();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(set);
                if (serverMBeanArray != null && serverMBeanArray.length > 0) {
                    for (int i = 0; i < serverMBeanArray.length; ++i) {
                        if (serverMBeanArray[i] == null) continue;
                        arrayList.remove(serverMBeanArray[i].getName());
                    }
                }
                for (String string : arrayList) {
                    if (debug.isEnabled()) {
                        Debug.say((String)("ServerLifeCycleRuntime.cleanupStore() removing entry for " + string));
                    }
                    pMap.remove((Object)string);
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (!debug.isEnabled()) break block7;
                Debug.say((String)persistentStoreException.getMessage());
            }
        }
    }

    private static PersistentMap initStore() {
        PersistentMapAsyncTX persistentMapAsyncTX;
        block7: {
            persistentMapAsyncTX = null;
            PersistentStore persistentStore = PersistentStoreManager.getManager().getDefaultStore();
            if (persistentStore == null) {
                if (debug.isEnabled()) {
                    Debug.say((String)"The default persistent store cannot be found.");
                }
            } else {
                try {
                    persistentMapAsyncTX = persistentStore.createPersistentMap(SERVER_LIFECYCLE_STORE_NAME);
                    if (debug.isEnabled()) {
                        Set set = persistentMapAsyncTX.keySet();
                        for (Object e : set) {
                            Debug.say((String)("--  pMap contains (" + e + ", " + persistentMapAsyncTX.get(e) + ")"));
                        }
                    }
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (!debug.isEnabled()) break block7;
                    Debug.say((String)persistentStoreException.getMessage());
                }
            }
        }
        return persistentMapAsyncTX;
    }

    void cleanup() {
        block3: {
            if (pMap != null) {
                try {
                    pMap.remove((Object)this.getName());
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (!debug.isEnabled()) break block3;
                    Debug.say((String)persistentStoreException.getMessage());
                }
            }
        }
    }

    private void saveStore(ServerProperties serverProperties) {
        block5: {
            if (pMap != null) {
                try {
                    pMap.put((Object)this.getName(), (Object)serverProperties);
                    if (debug.isEnabled()) {
                        Debug.say((String)("saveStore() adding to pMap(" + this.getName() + ", " + serverProperties + ") pMap size is " + pMap.size()));
                        Set set = pMap.keySet();
                        for (Object e : set) {
                            Debug.say((String)("--  pMap contains (" + e + ", " + pMap.get(e) + ")"));
                        }
                    }
                    this.mCachedValue = serverProperties;
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (!debug.isEnabled()) break block5;
                    Debug.say((String)persistentStoreException.getMessage());
                }
            }
        }
    }

    private ServerProperties getFromStore() {
        block4: {
            if (this.mCachedValue == null && pMap != null) {
                try {
                    this.mCachedValue = (ServerProperties)pMap.get((Object)this.getName());
                    if (debug.isEnabled()) {
                        Debug.say((String)("getFromStore() got from pMap(" + this.getName() + ", " + this.mCachedValue + ")"));
                    }
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (!debug.isEnabled()) break block4;
                    Debug.say((String)persistentStoreException.getMessage());
                }
            }
        }
        return this.mCachedValue;
    }

    public ServerLifeCycleTaskRuntimeMBean start() throws ServerLifecycleException {
        try {
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Starting " + this.serverName + " server ...", "start");
            this.tasks.add(serverLifeCycleTaskRuntime);
            this.currentState = null;
            this.startServer(serverLifeCycleTaskRuntime, null);
            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(serverLifeCycleTaskRuntime);
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var4_4 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean start(String string) throws ServerLifecycleException {
        try {
            Object object;
            boolean bl = false;
            MachineMBean machineMBean = this.serverMBean.getMachine();
            if (machineMBean != null && machineMBean.getName().equals(string)) {
                bl = true;
            }
            if (!bl) {
                object = this.serverMBean.getCandidateMachines();
                if (object != null && ((MachineMBean[])object).length > 0) {
                    bl = this.isMachineListed(string, (MachineMBean[])object);
                } else {
                    MachineMBean[] machineMBeanArray;
                    ClusterMBean clusterMBean = this.serverMBean.getCluster();
                    if (clusterMBean != null && (machineMBeanArray = clusterMBean.getCandidateMachinesForMigratableServers()) != null && machineMBeanArray.length > 0) {
                        bl = this.isMachineListed(string, machineMBeanArray);
                    }
                }
            }
            if (!bl) {
                throw new ServerLifecycleException("Invalid machine name or server not configured to run on this machine");
            }
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Starting " + this.serverName + " server ...", "start");
            this.tasks.add(serverLifeCycleTaskRuntime);
            this.currentState = null;
            this.startServer(serverLifeCycleTaskRuntime, string);
            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(serverLifeCycleTaskRuntime);
            object = serverLifeCycleTaskRuntime;
            Object var9_9 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return object;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    private boolean isMachineListed(String string, MachineMBean[] machineMBeanArray) {
        for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (!machineMBeanArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public ServerLifeCycleTaskRuntimeMBean startInStandby() throws ServerLifecycleException {
        try {
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Starting " + this.serverName + " server in standby mode ...", "startInStandby");
            this.tasks.add(serverLifeCycleTaskRuntime);
            this.currentState = null;
            this.startInStandbyServer(serverLifeCycleTaskRuntime);
            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(serverLifeCycleTaskRuntime);
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var4_4 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean resume() throws ServerLifecycleException {
        try {
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Resuming " + this.serverName + " server ...", "resume");
            this.tasks.add(serverLifeCycleTaskRuntime);
            ResumeRequest resumeRequest = new ResumeRequest(serverLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(resumeRequest)));
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var5_5 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean shutdown() throws ServerLifecycleException {
        return this.shutdown(0, false);
    }

    public ServerLifeCycleTaskRuntimeMBean shutdown(int n, boolean bl) throws ServerLifecycleException {
        try {
            this.logAdministratorAddress("Graceful shutdown");
            if (this.getState() == "SHUTDOWN") {
                throw new ServerLifecycleException("Can not get to the relevant ServerRuntimeMBean for server " + this.serverName + ". Server is in SHUTDOWN state and cannot be reached.");
            }
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Shutting down " + this.serverName + " server ...", "shutdown");
            this.tasks.add(serverLifeCycleTaskRuntime);
            ShutdownRequest shutdownRequest = new ShutdownRequest(n, bl, serverLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(shutdownRequest)));
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var7_7 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean forceShutdown() throws ServerLifecycleException {
        try {
            this.logAdministratorAddress("Force shutdown");
            if (this.getState() == "SHUTDOWN") {
                throw new ServerLifecycleException("Can not get to the relevant ServerRuntimeMBean for server " + this.serverName + ". Server is in SHUTDOWN state and cannot be reached.");
            }
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Forcefully shutting down " + this.serverName + " server ...", "forceShutdown");
            this.tasks.add(serverLifeCycleTaskRuntime);
            ShutdownRequest shutdownRequest = new ShutdownRequest(serverLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(shutdownRequest)));
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var5_5 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean[] getTasks() {
        return this.tasks.toArray(new ServerLifeCycleTaskRuntimeMBean[this.tasks.size()]);
    }

    public ServerLifeCycleTaskRuntimeMBean suspend() throws ServerLifecycleException {
        return this.suspend(0, false);
    }

    public ServerLifeCycleTaskRuntimeMBean suspend(int n, boolean bl) throws ServerLifecycleException {
        try {
            this.logAdministratorAddress("Graceful suspend");
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "suspending " + this.serverName + " server ...", "suspendWithTimeout");
            this.tasks.add(serverLifeCycleTaskRuntime);
            SuspendRequest suspendRequest = new SuspendRequest(n, bl, serverLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(suspendRequest)));
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var7_7 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    public ServerLifeCycleTaskRuntimeMBean forceSuspend() throws ServerLifecycleException {
        try {
            this.logAdministratorAddress("Force suspend");
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = new ServerLifeCycleTaskRuntime(this, "Forcefully suspending " + this.serverName + " server ...", "forceSuspend");
            this.tasks.add(serverLifeCycleTaskRuntime);
            SuspendRequest suspendRequest = new SuspendRequest(serverLifeCycleTaskRuntime);
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new ContextWrap(suspendRequest)));
            ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime2 = serverLifeCycleTaskRuntime;
            Object var5_5 = null;
            this.clearOldServerLifeCycleTaskRuntimes();
            return serverLifeCycleTaskRuntime2;
        }
        catch (ManagementException managementException) {
            try {
                throw new ServerLifecycleException(managementException);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.clearOldServerLifeCycleTaskRuntimes();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String string) {
        ServerLifeCycleRuntime serverLifeCycleRuntime = this;
        synchronized (serverLifeCycleRuntime) {
            if (string == null || string.equalsIgnoreCase(this.currentState)) {
                return;
            }
            this.oldState = this.currentState;
            this.currentState = string;
            if ("RUNNING".equals(string)) {
                this.saveStore(new ServerProperties(this));
            }
            if ("SHUTTING_DOWN".equals(string) || "FORCE_SHUTTING_DOWN".equals(string)) {
                this.stateShouldBeAvailable = false;
            } else if ("STARTING".equals(string) || "RESUMING".equals(string) || "RUNNING".equals(string)) {
                this.stateShouldBeAvailable = true;
                this.saveLastKnownMachine();
            }
        }
        this._postSet("State", this.oldState, this.currentState);
    }

    public String getState() {
        String string = this.getStateRemote();
        if (string == null && ((string = this.getStateNodeManager()) == null || "UNKNOWN".equalsIgnoreCase(string))) {
            string = this.stateShouldBeAvailable ? "UNKNOWN" : "SHUTDOWN";
        }
        this.clearOldServerLifeCycleTaskRuntimes();
        return string;
    }

    public int getNodeManagerRestartCount() {
        return this.startCount > 0 ? this.startCount - 1 : 0;
    }

    public String getWeblogicHome() {
        RemoteLifeCycleOperations remoteLifeCycleOperations = this.getLifeCycleOperationsRemote();
        if (remoteLifeCycleOperations == null) {
            ServerProperties serverProperties = this.getFromStore();
            if (serverProperties != null) {
                return serverProperties.getWeblogicHome();
            }
            return null;
        }
        try {
            return remoteLifeCycleOperations.getWeblogicHome();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getMiddlewareHome() {
        RemoteLifeCycleOperations remoteLifeCycleOperations = this.getLifeCycleOperationsRemote();
        if (remoteLifeCycleOperations == null) {
            ServerProperties serverProperties = this.getFromStore();
            if (serverProperties != null) {
                return serverProperties.getMiddlewareHome();
            }
            return null;
        }
        try {
            return remoteLifeCycleOperations.getMiddlewareHome();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getIPv4URL(String string) {
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)ManagementService.getRuntimeAccess(kernelId).getDomainName(), (String)this.getName());
        String string2 = null;
        try {
            ServerProperties serverProperties;
            if (serverIdentity != null) {
                string2 = URLManager.findIPv4URL(serverIdentity, ProtocolManager.findProtocol((String)string));
            }
            if (string2 == null && (serverProperties = this.getFromStore()) != null) {
                string2 = serverProperties.getIPv4URL(string);
            }
        }
        catch (UnknownProtocolException unknownProtocolException) {
            // empty catch block
        }
        return string2;
    }

    public String getIPv6URL(String string) {
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)ManagementService.getRuntimeAccess(kernelId).getDomainName(), (String)this.getName());
        String string2 = null;
        try {
            ServerProperties serverProperties;
            if (serverIdentity != null) {
                string2 = URLManager.findIPv6URL(serverIdentity, ProtocolManager.findProtocol((String)string));
            }
            if (string2 == null && (serverProperties = this.getFromStore()) != null) {
                string2 = serverProperties.getIPv6URL(string);
            }
        }
        catch (UnknownProtocolException unknownProtocolException) {
            // empty catch block
        }
        return string2;
    }

    private String getStateRemote() {
        block10: {
            RemoteLifeCycleOperations remoteLifeCycleOperations = this.getLifeCycleOperationsRemote();
            if (remoteLifeCycleOperations == null) {
                return null;
            }
            try {
                return remoteLifeCycleOperations.getState();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (PeerGoneException peerGoneException) {
            }
            catch (ManagementRuntimeException managementRuntimeException) {
                if (!ServerLifeCycleRuntime.isNestedDueToShutdown(managementRuntimeException.getCause())) {
                    throw new AssertionError((Throwable)managementRuntimeException);
                }
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                if (!ServerLifeCycleRuntime.isNestedDueToShutdown(remoteRuntimeException.getNested())) {
                    throw new AssertionError((Throwable)remoteRuntimeException);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new AssertionError((Throwable)runtimeException);
            }
            catch (RemoteException remoteException) {
                if (ServerLifeCycleRuntime.isNestedDueToShutdown(remoteException.getCause())) break block10;
                throw new AssertionError((Throwable)remoteException);
            }
        }
        return null;
    }

    private String getStateNodeManager() {
        MachineMBean machineMBean = this.getLastKnownMachine();
        if (machineMBean == null) {
            return null;
        }
        try {
            return NodeManagerRuntime.getInstance(machineMBean).getState(this.serverMBean);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean isNestedDueToShutdown(Throwable throwable) {
        return throwable instanceof IOException;
    }

    public int getStateVal() {
        String string = this.getState().intern();
        if (string == "STARTING" || string == "FAILED_RESTARTING") {
            return 1;
        }
        if (string == "SHUTTING_DOWN") {
            return 7;
        }
        if (string == "FORCE_SHUTTING_DOWN") {
            return 18;
        }
        if (string == "STANDBY") {
            return 3;
        }
        if (string == "ADMIN") {
            return 17;
        }
        if (string == "SUSPENDING") {
            return 4;
        }
        if (string == "RESUMING") {
            return 6;
        }
        if (string == "RUNNING") {
            return 2;
        }
        if (string == "SHUTDOWN") {
            return 0;
        }
        if (string == "FAILED") {
            return 8;
        }
        if (string == "ACTIVATE_LATER") {
            return 13;
        }
        if (string == "FAILED_NOT_RESTARTABLE") {
            return 14;
        }
        if (string == "FAILED_MIGRATABLE") {
            return 15;
        }
        return 9;
    }

    private void startServer(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime, String string) {
        try {
            Object object;
            NodeManagerRuntime.checkStartPrivileges(this.serverName, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId));
            NodeManagerRuntime nodeManagerRuntime = null;
            if (string != null) {
                object = this.getMachine(string);
                if (string == null) {
                    serverLifeCycleTaskRuntime.setError(new IOException("Unknown machine name"));
                    return;
                }
                nodeManagerRuntime = NodeManagerRuntime.getInstance((MachineMBean)object);
            } else {
                nodeManagerRuntime = NodeManagerRuntime.getInstance(this.serverMBean);
            }
            object = nodeManagerRuntime.start(this.serverMBean);
            ++this.startCount;
            serverLifeCycleTaskRuntime.setNMTask((NodeManagerTask)object);
        }
        catch (SecurityException securityException) {
            serverLifeCycleTaskRuntime.setError(securityException);
        }
        catch (IOException iOException) {
            serverLifeCycleTaskRuntime.setError(iOException);
        }
    }

    private MachineMBean getMachine(String string) {
        MachineMBean[] machineMBeanArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getMachines();
        for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (!machineMBeanArray[i].getName().equals(string)) continue;
            return machineMBeanArray[i];
        }
        return null;
    }

    private void startInStandbyServer(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
        this.startServer(serverLifeCycleTaskRuntime, null);
    }

    private static boolean isSecurityException(Exception exception) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable instanceof SecurityException;
    }

    private boolean useNodeManagerToShutdown() throws IOException {
        ServerStartMBean serverStartMBean = this.serverMBean.getServerStart();
        if (serverStartMBean == null) {
            return false;
        }
        MachineMBean machineMBean = this.serverMBean.getMachine();
        if (machineMBean == null) {
            return false;
        }
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
        if (nodeManagerRuntime == null) {
            return false;
        }
        nodeManagerRuntime.kill(this.serverMBean);
        return true;
    }

    private static void updateTaskMBeanOnCompletion(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
        if (serverLifeCycleTaskRuntime.getError() != null) {
            serverLifeCycleTaskRuntime.setStatus("FAILED");
        } else {
            serverLifeCycleTaskRuntime.setStatus("TASK COMPLETED");
        }
        serverLifeCycleTaskRuntime.setEndTime(System.currentTimeMillis());
        serverLifeCycleTaskRuntime.setIsRunning(false);
    }

    public String getBulkQueryState() {
        return this.cachedBulkQueryState;
    }

    public void setBulkQueryState(String string) {
        this.cachedBulkQueryState = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldServerLifeCycleTaskRuntimes() {
        Set set = this.tasks;
        synchronized (set) {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime = (ServerLifeCycleTaskRuntime)iterator.next();
                if (serverLifeCycleTaskRuntime.getEndTime() <= 0L || System.currentTimeMillis() - serverLifeCycleTaskRuntime.getEndTime() <= 1800000L) continue;
                try {
                    serverLifeCycleTaskRuntime.unregister();
                }
                catch (ManagementException managementException) {
                    // empty catch block
                }
                iterator.remove();
            }
        }
    }

    private RemoteLifeCycleOperations getLifeCycleOperationsRemote() {
        return ServerLifeCycleRuntime.getLifeCycleOperationsRemote(this.serverName);
    }

    public static RemoteLifeCycleOperations getLifeCycleOperationsRemote(String string) {
        try {
            Environment environment = new Environment();
            String string2 = URLManager.findAdministrationURL(string);
            environment.setProviderUrl(string2);
            if (debug.isEnabled()) {
                Debug.say((String)("Looking up RemoteLifeCycleOperations with URL " + string2));
            }
            RemoteLifeCycleOperations remoteLifeCycleOperations = (RemoteLifeCycleOperations)PortableRemoteObject.narrow((Object)environment.getInitialReference(RemoteLifeCycleOperationsImpl.class), RemoteLifeCycleOperations.class);
            return remoteLifeCycleOperations;
        }
        catch (UnknownHostException unknownHostException) {
            ServerLogger.logLookupSLCOperations((String)string, (Throwable)unknownHostException);
            return null;
        }
        catch (NamingException namingException) {
            ServerLogger.logLookupSLCOperations((String)string, (Throwable)namingException);
            return null;
        }
    }

    private void logAdministratorAddress(String string) {
        EndPoint endPoint = ServerHelper.getClientEndPointInternal();
        if (endPoint == null) {
            return;
        }
        Channel channel = endPoint.getRemoteChannel();
        if (channel == null) {
            return;
        }
        ServerLogger.logAdminAddress((String)(string + " of " + this.serverName), (String)channel.getInetAddress().getHostAddress());
    }

    private ServerRuntimeMBean getServerRuntimeMBean() {
        DomainRuntimeServiceMBean domainRuntimeServiceMBean = ManagementService.getDomainAccess(kernelId).getDomainRuntimeService();
        return domainRuntimeServiceMBean.lookupServerRuntime(this.serverMBean.getName());
    }

    private void saveLastKnownMachine() {
        ServerRuntimeMBean serverRuntimeMBean = this.getServerRuntimeMBean();
        if (serverRuntimeMBean != null) {
            this.lastKnownMachine = this.getMachine(serverRuntimeMBean.getCurrentMachine());
        }
    }

    private MachineMBean getLastKnownMachine() {
        return this.lastKnownMachine != null ? this.lastKnownMachine : this.serverMBean.getMachine();
    }

    static class ServerProperties
    implements Serializable {
        private String mWeblogicHome;
        private String mMiddlewareHome;
        private HashMap<String, String> mIPv4URLs;
        private HashMap<String, String> mIPv6URLs;

        ServerProperties(ServerLifeCycleRuntime serverLifeCycleRuntime) {
            this.mWeblogicHome = serverLifeCycleRuntime.getWeblogicHome();
            this.mMiddlewareHome = serverLifeCycleRuntime.getMiddlewareHome();
            String[] stringArray = ProtocolManager.getProtocols();
            if (stringArray != null && stringArray.length > 0) {
                this.mIPv4URLs = new HashMap();
                this.mIPv6URLs = new HashMap();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = serverLifeCycleRuntime.getIPv4URL(string);
                    String string3 = serverLifeCycleRuntime.getIPv6URL(string);
                    if (string2 != null) {
                        this.mIPv4URLs.put(string, string2);
                    }
                    if (string3 == null) continue;
                    this.mIPv6URLs.put(string, string3);
                }
            }
        }

        public String getWeblogicHome() {
            return this.mWeblogicHome;
        }

        public String getMiddlewareHome() {
            return this.mMiddlewareHome;
        }

        public String getIPv4URL(String string) {
            String string2 = null;
            if (this.mIPv4URLs != null) {
                string2 = this.mIPv4URLs.get(string);
            }
            return string2;
        }

        public String getIPv6URL(String string) {
            String string2 = null;
            if (this.mIPv6URLs != null) {
                string2 = this.mIPv6URLs.get(string);
            }
            return string2;
        }

        public String toString() {
            return "ServerProperties(weblogicHome: " + this.mWeblogicHome + ", middlewareHome: " + this.mMiddlewareHome + ")";
        }
    }

    private final class ResumeRequest
    implements Runnable {
        private final ServerLifeCycleTaskRuntime taskMBean;

        ResumeRequest(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
            this.taskMBean = serverLifeCycleTaskRuntime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    RemoteLifeCycleOperations remoteLifeCycleOperations = ServerLifeCycleRuntime.this.getLifeCycleOperationsRemote();
                    if (remoteLifeCycleOperations == null) {
                        throw new ServerLifecycleException("Can not get to the relevant ServerRuntimeMBean");
                    }
                    remoteLifeCycleOperations.resume();
                }
                catch (Exception exception) {
                    this.taskMBean.setError(exception);
                    Object var3_4 = null;
                    ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                    return;
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                throw throwable;
            }
            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
        }
    }

    private final class SuspendRequest
    implements Runnable {
        private int timeout;
        private final boolean forceSuspend;
        private boolean ignoreSessions;
        private final ServerLifeCycleTaskRuntime taskMBean;

        SuspendRequest(int n, boolean bl, ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
            this.timeout = n;
            this.ignoreSessions = bl;
            this.forceSuspend = false;
            this.taskMBean = serverLifeCycleTaskRuntime;
        }

        SuspendRequest(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
            this.forceSuspend = true;
            this.taskMBean = serverLifeCycleTaskRuntime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    RemoteLifeCycleOperations remoteLifeCycleOperations = ServerLifeCycleRuntime.this.getLifeCycleOperationsRemote();
                    if (remoteLifeCycleOperations == null) {
                        throw new ServerLifecycleException("Can not get to the relevant ServerRuntimeMBean");
                    }
                    if (this.forceSuspend) {
                        remoteLifeCycleOperations.forceSuspend();
                    }
                    remoteLifeCycleOperations.suspend(this.timeout, this.ignoreSessions);
                }
                catch (Exception exception) {
                    this.taskMBean.setError(exception);
                    Object var3_4 = null;
                    ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                    return;
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                throw throwable;
            }
            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
        }
    }

    private final class ShutdownRequest
    implements Runnable {
        private int timeout;
        private final boolean forceShutdown;
        private boolean ignoreSessions;
        private final ServerLifeCycleTaskRuntime taskMBean;

        ShutdownRequest(int n, boolean bl, ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
            this.timeout = n;
            this.ignoreSessions = bl;
            this.forceShutdown = false;
            this.taskMBean = serverLifeCycleTaskRuntime;
        }

        ShutdownRequest(ServerLifeCycleTaskRuntime serverLifeCycleTaskRuntime) {
            this.forceShutdown = true;
            this.taskMBean = serverLifeCycleTaskRuntime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block14: {
                    try {
                        RemoteLifeCycleOperations remoteLifeCycleOperations = ServerLifeCycleRuntime.this.getLifeCycleOperationsRemote();
                        if (remoteLifeCycleOperations == null) {
                            Loggable loggable = ServerLogger.logRemoteServerLifeCycleRuntimeNotFoundLoggable((String)this.taskMBean.getServerName());
                            throw new ServerLifecycleException(loggable.getMessageText());
                        }
                        if (this.forceShutdown) {
                            remoteLifeCycleOperations.forceShutdown();
                            break block14;
                        }
                        remoteLifeCycleOperations.shutdown(this.timeout, this.ignoreSessions);
                    }
                    catch (RemoteRuntimeException remoteRuntimeException) {
                        Throwable throwable = remoteRuntimeException.getNestedException();
                        if (debug.isEnabled()) {
                            Debug.say((String)("Got a RemoteRuntimeException shutting down with nested exception:" + throwable));
                        }
                        if (!(throwable instanceof PeerGoneException)) {
                            this.taskMBean.setError((Exception)((Object)remoteRuntimeException));
                        }
                        Object var4_8 = null;
                        ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                        return;
                    }
                    catch (Exception exception) {
                        block15: {
                            if (debug.isEnabled()) {
                                Debug.say((String)("Got an Exception shutting down with exeption " + exception));
                            }
                            if (exception instanceof PeerGoneException) {
                                Object var4_9 = null;
                                ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                                return;
                            }
                            if (!this.forceShutdown || ServerLifeCycleRuntime.isSecurityException(exception) || !ServerLifeCycleRuntime.this.useNodeManagerToShutdown()) break block15;
                            Object var4_10 = null;
                            ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                            return;
                        }
                        try {
                            this.taskMBean.setError(exception);
                        }
                        catch (IOException iOException) {
                            iOException.initCause(exception);
                            this.taskMBean.setError(iOException);
                        }
                        Object var4_11 = null;
                        ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                        return;
                    }
                }
                Object var4_7 = null;
                ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                return;
            }
            catch (Throwable throwable) {
                Object var4_12 = null;
                ServerLifeCycleRuntime.updateTaskMBeanOnCompletion(this.taskMBean);
                throw throwable;
            }
        }
    }
}

