/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.WebLogicMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.server.ServerLifeCycleRuntime;

public class ServerLifeCycleRuntimeBeanInfo
extends WebLogicMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = ServerLifeCycleRuntimeMBean.class;

    public ServerLifeCycleRuntimeBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ServerLifeCycleRuntimeBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ServerLifeCycleRuntime.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.server");
        String string = new String("<p>Provides methods that transition servers from one state to another. This class is instantiated only on the Administration Server, but you can use it to transition the states of Managed Servers as well as Administration Servers.</p>  <p>You cannot use it to start an Administration Server, and if you want to use it to start Managed Servers, you must first set up a Node Manager on each Managed Server's host machine.</p>  <p>If you want to use the methods that transition a server into the <code>ADMIN</code> state, you must first set up an administration channel for that server.</p>  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Operator")};
        beanDescriptor.setValue("rolesAllowed", stringArray);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.runtime.ServerLifeCycleRuntimeMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion) && !map.containsKey("MiddlewareHome")) {
            string2 = "getMiddlewareHome";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MiddlewareHome", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("MiddlewareHome", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The Oracle Middleware installation directory. </p> ");
            propertyDescriptor.setValue("since", "10.3.3.0");
        }
        if (!map.containsKey("NodeManagerRestartCount")) {
            string2 = "getNodeManagerRestartCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("NodeManagerRestartCount", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("NodeManagerRestartCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "Number of times the server has been restarted using the NodeManager since creation. The first start does not count. The count is valid only if the NodeManager is used to start and restart the server everytime. ");
        }
        if (!map.containsKey("State")) {
            string2 = "getState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("State", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("State", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The current state of the server.</p> Server states are described in ");
        }
        if (!map.containsKey("StateVal")) {
            string2 = "getStateVal";
            string = null;
            propertyDescriptor = new PropertyDescriptor("StateVal", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("StateVal", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>An integer that identifies the current state of the server. Values range from <code>0</code> to <code>8</code>.</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("Tasks")) {
            string2 = "getTasks";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Tasks", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("Tasks", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get preexisting Server Lifecycle Tasks ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion) && !map.containsKey("WeblogicHome")) {
            string2 = "getWeblogicHome";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WeblogicHome", ServerLifeCycleRuntimeMBean.class, string2, string);
            map.put("WeblogicHome", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The directory where the WebLogic Server instance (server) is installed, without the trailing \"/server\".</p> ");
            propertyDescriptor.setValue("since", "10.3.3.0");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        Object object;
        MethodDescriptor methodDescriptor;
        Method method = ServerLifeCycleRuntimeMBean.class.getMethod("preDeregister", new Class[0]);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("start", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Uses the Node Manager to start a Managed Server.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("startInStandby", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Uses the Node Manager to start a Managed Server and place it in the <code>STANDBY</code> state.</p>  <p>The server transitions through the following states:<br clear=\"none\" /> <code>SHUTDOWN</code>&gt;<code>SUSPENDING</code>&gt;<code>STANDBY</code>. </p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("resume", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Transitions the server from <code>ADMIN</code> to <code>RUNNING</code> state.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("suspend", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Gracefully suspends server to <code>ADMIN</code> state. New requests are rejected and inflight work is allowed to complete.</p> ");
            object = new String[]{BeanInfoHelper.encodeEntities((String)"#suspend(int, boolean)")};
            methodDescriptor.setValue("see", object);
            methodDescriptor.setValue("role", "operation");
        }
        method = ServerLifeCycleRuntimeMBean.class.getMethod("suspend", Integer.TYPE, Boolean.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"timeout", (String)"Seconds to wait for server to transition gracefully. The server calls {@link #forceSuspend()} after timeout. "), ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"ignoreSessions", (String)"drop inflight HTTP sessions during graceful suspend ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ServerLifecycleException server failed to suspend gracefully.            A {@link #forceSuspend()} or a {@link #forceShutdown()} operation can be   invoked.")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Transitions the server from <code>RUNNING</code> to <code>ADMIN</code> state gracefully.</p>  <p>Applications are in admin mode. Inflight work is completed.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("forceSuspend", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            object = new String[]{BeanInfoHelper.encodeEntities((String)"ServerLifecycleException server failed to force suspend.            A {@link #forceShutdown()} operation can be invoked.")};
            methodDescriptor.setValue("throws", object);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Transitions the server from RUNNING to ADMIN state forcefully cancelling inflight work.</p> <p>Work that cannot be cancelled is dropped. Applications are brought into the admin mode forcefully.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("shutdown", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Gracefully transitions a server to the <code>SHUTDOWN</code> state. The server completes all current work before it shuts down. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ServerLifeCycleRuntimeMBean.class.getMethod("shutdown", Integer.TYPE, Boolean.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"timeout", (String)"Number of seconds to wait before aborting inflight work and force shutting down the server. "), ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"ignoreSessions", (String)"Set to <code>true</code> to ignore pending HTTP sessions during inflight work handling. ")};
        object = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(object)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Gracefully shutdown the server after handling inflight work. The following inflight work is handled :</p>  <ul> <li> <p>Pending transaction's and TLOG checkpoint</p> </li>  <li> <p>Pending HTTP sessions</p> </li>  <li> <p>Pending JMS work</p> </li>  <li> <p>Pending work in the Work Managers</p> </li>  <li> <p>RMI requests with tx context or administrator calls</p> </li> </ul> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("forceShutdown", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Immediately transitions a server to the <code>SHUTDOWN</code> state. The server immediately terminates all current work, moves through the <code>SHUTTING_DOWN</code> state, and ends in the <code>SHUTDOWN</code> state.</p>  <p>You can forcefully shut down a server from any state except <code>UNKNOWN</code>.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ServerLifeCycleRuntimeMBean.class.getMethod("clearOldServerLifeCycleTaskRuntimes", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "Removes all ServerLifeCycleTaskRuntimeMBeans that have completed and been around for over 30 minutes. ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion)) {
            method = ServerLifeCycleRuntimeMBean.class.getMethod("getIPv4URL", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.3.3.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "<p>The IPv4 URL that clients use when connecting to this server using the specified protocol.</p> ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("since", "10.3.3.0");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion)) {
            method = ServerLifeCycleRuntimeMBean.class.getMethod("getIPv6URL", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{ServerLifeCycleRuntimeBeanInfo.createParameterDescriptor((String)"protocol", (String)"the desired protocol ")};
            object = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(object)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.3.3.0");
                map.put(object, methodDescriptor);
                methodDescriptor.setValue("description", "<p>The IPv6 URL that clients use when connecting to this server using the specified protocol.</p> ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("since", "10.3.3.0");
            }
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

