/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CoherenceServerMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.DomainAccessSettable;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.CoherenceServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.CoherenceServerLifeCycleRuntime;
import weblogic.server.ServerLifeCycleRuntime;
import weblogic.server.ServiceFailureException;

public class ServerLifeCycleService
extends AbstractServerService {
    private static ServerLifeCycleService singleton;
    private Map<String, ServerLifeCycleRuntime> instances;
    private Map<String, CoherenceServerLifeCycleRuntime> instancesCoh;
    private boolean started;
    private static final AuthenticatedSubject KERNEL_ID;

    public ServerLifeCycleService() {
        if (singleton != null) {
            throw new AssertionError((Object)"ServeruLifecycleServices can be initialized only once");
        }
        singleton = this;
    }

    public static final ServerLifeCycleService getInstance() {
        SecurityHelper.assertIfNotKernel();
        if (singleton == null) {
            throw new AssertionError((Object)"ServeruLifecycleServices Not Yet Initialized");
        }
        return singleton;
    }

    public final ServerLifeCycleRuntimeMBean[] getServerLifecycleRuntimes() {
        return this.instances.values().toArray(new ServerLifeCycleRuntimeMBean[this.instances.size()]);
    }

    public final ServerLifeCycleRuntimeMBean lookupServerLifecycleRuntime(String string) {
        return this.instances.get(string);
    }

    public final CoherenceServerLifeCycleRuntimeMBean[] getCoherenceServerLifecycleRuntimes() {
        return this.instancesCoh.values().toArray(new CoherenceServerLifeCycleRuntimeMBean[this.instancesCoh.size()]);
    }

    public final CoherenceServerLifeCycleRuntimeMBean lookupCoherenceServerLifecycleRuntime(String string) {
        return this.instancesCoh.get(string);
    }

    public void start() throws ServiceFailureException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        if (!runtimeAccess.isAdminServer()) {
            return;
        }
        this.instances = Collections.synchronizedMap(new HashMap());
        ((DomainAccessSettable)((Object)ManagementService.getDomainAccess(KERNEL_ID))).setLifecycleService(this);
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        ServerLifeCycleRuntime.cleanupStore(serverMBeanArray);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            try {
                this.createServerLifeCycleRuntime(serverMBeanArray[i]);
                continue;
            }
            catch (ManagementException managementException) {
                throw new Error("Unexpected exception creating server lifecycle", managementException);
            }
        }
        domainMBean.addBeanUpdateListener(this.createBeanUpdateListener());
        this.startCoherenceServers(domainMBean);
        this.started = true;
    }

    private void startCoherenceServers(DomainMBean domainMBean) {
        CoherenceServerMBean[] coherenceServerMBeanArray;
        this.instancesCoh = Collections.synchronizedMap(new HashMap());
        for (CoherenceServerMBean coherenceServerMBean : coherenceServerMBeanArray = domainMBean.getCoherenceServers()) {
            try {
                this.createCoherenceServerLifeCycleRuntime(coherenceServerMBean);
            }
            catch (ManagementException managementException) {
                throw new Error("Unexpected exception creating coherence server lifecycle", managementException);
            }
        }
    }

    private BeanUpdateListener createBeanUpdateListener() {
        return new BeanUpdateListener(){

            public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            }

            public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                block8: for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                    switch (propertyUpdate.getUpdateType()) {
                        case 2: {
                            ConfigurationMBean configurationMBean;
                            String string = propertyUpdate.getPropertyName();
                            if ("Servers".equals(string)) {
                                configurationMBean = (ServerMBean)propertyUpdate.getAddedObject();
                                try {
                                    ServerLifeCycleService.this.createServerLifeCycleRuntime((ServerMBean)configurationMBean);
                                    continue block8;
                                }
                                catch (ManagementException managementException) {
                                    throw new Error("Unexpected exception creating server lifecycle", managementException);
                                }
                            }
                            if (!"CoherenceServers".equals(string)) continue block8;
                            configurationMBean = (CoherenceServerMBean)propertyUpdate.getAddedObject();
                            try {
                                ServerLifeCycleService.this.createCoherenceServerLifeCycleRuntime((CoherenceServerMBean)configurationMBean);
                                continue block8;
                            }
                            catch (ManagementException managementException) {
                                throw new Error("Unexpected exception creating server lifecycle", managementException);
                            }
                        }
                        case 3: {
                            ConfigurationMBean configurationMBean;
                            String string = propertyUpdate.getPropertyName();
                            if ("Servers".equals(string)) {
                                configurationMBean = (ServerMBean)propertyUpdate.getRemovedObject();
                                ServerLifeCycleService.this.destroyServerLifecycleRuntime(configurationMBean.getName());
                                continue block8;
                            }
                            if (!"CoherenceServers".equals(string)) continue block8;
                            configurationMBean = (CoherenceServerMBean)propertyUpdate.getRemovedObject();
                            ServerLifeCycleService.this.destroyCoherenceServerLifecycleRuntime(configurationMBean.getName());
                        }
                    }
                }
            }

            public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            }
        };
    }

    private void createServerLifeCycleRuntime(ServerMBean serverMBean) throws ManagementException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        ServerLifeCycleRuntime serverLifeCycleRuntime = new ServerLifeCycleRuntime(serverMBean);
        this.instances.put(serverMBean.getName(), serverLifeCycleRuntime);
    }

    private void createCoherenceServerLifeCycleRuntime(CoherenceServerMBean coherenceServerMBean) throws ManagementException {
        CoherenceServerLifeCycleRuntime coherenceServerLifeCycleRuntime = new CoherenceServerLifeCycleRuntime(coherenceServerMBean);
        this.instancesCoh.put(coherenceServerMBean.getName(), coherenceServerLifeCycleRuntime);
    }

    private void destroyServerLifecycleRuntime(String string) {
        ServerLifeCycleRuntime serverLifeCycleRuntime = this.instances.get(string);
        serverLifeCycleRuntime.cleanup();
        this.instances.remove(string);
        ManagementService.getDomainAccess(KERNEL_ID).unregister(serverLifeCycleRuntime);
    }

    private void destroyCoherenceServerLifecycleRuntime(String string) {
        CoherenceServerLifeCycleRuntime coherenceServerLifeCycleRuntime = this.instancesCoh.get(string);
        coherenceServerLifeCycleRuntime.cleanup();
        this.instancesCoh.remove(string);
        ManagementService.getDomainAccess(KERNEL_ID).unregister(coherenceServerLifeCycleRuntime);
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }

    public static boolean isStarted() {
        return singleton != null ? ServerLifeCycleService.singleton.started : false;
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

