/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.io.IOException;
import java.io.PrintWriter;
import weblogic.management.ManagementException;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.management.runtime.TaskRuntimeMBean;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.server.ServerLifeCycleRuntime;

public class ServerLifeCycleTaskRuntime
extends DomainRuntimeMBeanDelegate
implements ServerLifeCycleTaskRuntimeMBean {
    private long beginTime = System.currentTimeMillis();
    private long endTime;
    private String description = null;
    private boolean isRunning = true;
    private String status = "TASK IN PROGRESS";
    private Exception exception;
    private static int num = 0;
    private boolean sysTask = false;
    private NodeManagerTask nmTask = null;
    private String serverName = null;
    private String operation = null;

    public ServerLifeCycleTaskRuntime(ServerLifeCycleRuntime serverLifeCycleRuntime, String string, String string2) throws ManagementException {
        super("_" + ServerLifeCycleTaskRuntime.getSequenceNumber() + "_" + string2, serverLifeCycleRuntime, true, "Tasks");
        this.description = string;
        this.serverName = serverLifeCycleRuntime.getName();
        this.operation = string2;
    }

    private static synchronized int getSequenceNumber() {
        return num++;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getOperation() {
        return this.operation;
    }

    public void cancel() throws Exception {
        if (this.nmTask == null) {
            throw new Exception("Operation can not be cancelled ...");
        }
        this.nmTask.cancel();
    }

    public long getBeginTime() {
        return this.nmTask != null ? this.nmTask.getBeginTime() : this.beginTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getEndTime() {
        if (this.nmTask != null) {
            return this.nmTask.getEndTime();
        }
        if (this.isRunning) {
            return -1L;
        }
        return this.endTime;
    }

    public void unregister() throws ManagementException {
        super.unregister();
        if (this.nmTask != null) {
            try {
                this.nmTask.cleanup();
            }
            catch (IOException iOException) {
                throw new ManagementException((Throwable)iOException);
            }
        }
    }

    public void setError(Exception exception) {
        this.exception = exception;
    }

    public Exception getError() {
        return this.nmTask != null ? this.nmTask.getError() : this.exception;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.nmTask != null ? this.nmTask.getStatus() : this.status;
    }

    public void setisRunning(boolean bl) {
        this.isRunning = bl;
    }

    public boolean isRunning() {
        return this.nmTask != null ? !this.nmTask.isFinished() : this.isRunning;
    }

    public String getDescription() {
        return this.description;
    }

    public NodeManagerTask getNMTask() {
        return this.nmTask;
    }

    public void setNMTask(NodeManagerTask nodeManagerTask) {
        this.nmTask = nodeManagerTask;
    }

    public void setIsRunning(boolean bl) {
        this.isRunning = bl;
    }

    public boolean isSystemTask() {
        return this.sysTask;
    }

    public void setSystemTask(boolean bl) {
        this.sysTask = bl;
    }

    public TaskRuntimeMBean[] getSubTasks() {
        return null;
    }

    public TaskRuntimeMBean getParentTask() {
        return null;
    }

    public void printLog(PrintWriter printWriter) {
        printWriter.println("This feature is to be replaced as per CR184195");
    }
}

