/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import weblogic.server.channels.Jdk6;

public class AddressUtils {
    public static final InetAddress getLoopback() {
        return AddressMaker.LOOPBACK;
    }

    public static final InetAddress getLocalHost() {
        return AddressMaker.LOCALHOST;
    }

    public static final InetAddress[] getIPAny() {
        return AddressMaker.IP_ANY;
    }

    public static final String getIPAny(int n, boolean bl) {
        return bl ? AddressMaker.IP_ANY[n].getHostName().toLowerCase() : AddressMaker.IP_ANY[n].getHostAddress();
    }

    private static final class AddressMaker {
        private static final InetAddress LOOPBACK = AddressMaker.getLoopback();
        private static final InetAddress LOCALHOST = AddressMaker.getLocalHost();
        private static final InetAddress[] IP_ANY = AddressMaker.getAllAddresses();

        private AddressMaker() {
        }

        private static final InetAddress getLoopback() {
            try {
                return InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                AssertionError assertionError = new AssertionError((Object)"Could not obtain the loopback address. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertionError)).initCause(unknownHostException);
                throw assertionError;
            }
        }

        private static final InetAddress getLocalHost() {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                AssertionError assertionError = new AssertionError((Object)"Could not obtain the localhost address. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertionError)).initCause(unknownHostException);
                throw assertionError;
            }
        }

        private static final InetAddress[] getAllAddresses() {
            try {
                ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
                ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
                ArrayList<InetAddress> arrayList3 = new ArrayList<InetAddress>();
                ArrayList<InetAddress> arrayList4 = new ArrayList<InetAddress>();
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress;
                    Enumeration<InetAddress> enumeration2;
                    NetworkInterface networkInterface = enumeration.nextElement();
                    boolean bl = Jdk6.isVirtual(networkInterface);
                    if (bl) {
                        enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            inetAddress = enumeration2.nextElement();
                            if ((inetAddress = InetAddress.getByAddress(inetAddress.getAddress())).isLoopbackAddress()) {
                                arrayList4.add(inetAddress);
                                continue;
                            }
                            if (inetAddress.isSiteLocalAddress()) {
                                arrayList2.add(inetAddress);
                                continue;
                            }
                            if (inetAddress.isLinkLocalAddress()) {
                                arrayList3.add(inetAddress);
                                continue;
                            }
                            if (inetAddress.isMulticastAddress() || inetAddress.isAnyLocalAddress()) continue;
                            arrayList.add(inetAddress);
                        }
                        continue;
                    }
                    enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        inetAddress = enumeration2.nextElement();
                        if ((inetAddress = InetAddress.getByAddress(inetAddress.getAddress())).isLoopbackAddress()) {
                            arrayList4.add(0, inetAddress);
                            continue;
                        }
                        if (inetAddress.isSiteLocalAddress()) {
                            arrayList2.add(0, inetAddress);
                            continue;
                        }
                        if (inetAddress.isLinkLocalAddress()) {
                            arrayList3.add(0, inetAddress);
                            continue;
                        }
                        if (inetAddress.isMulticastAddress() || inetAddress.isAnyLocalAddress()) continue;
                        arrayList.add(0, inetAddress);
                    }
                }
                if (!arrayList2.isEmpty()) {
                    arrayList.addAll(arrayList2);
                }
                if (!arrayList3.isEmpty()) {
                    arrayList.addAll(arrayList3);
                }
                if (!arrayList4.isEmpty()) {
                    arrayList.addAll(arrayList4);
                }
                return arrayList.toArray(new InetAddress[arrayList.size()]);
            }
            catch (SocketException socketException) {
                AssertionError assertionError = new AssertionError((Object)"An error occurred while retrieving the network addresses for this machine. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertionError)).initCause(socketException);
                throw assertionError;
            }
            catch (UnknownHostException unknownHostException) {
                AssertionError assertionError = new AssertionError((Object)"An error occurred while retrieving the network addresses for this machine. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertionError)).initCause(unknownHostException);
                throw assertionError;
            }
        }
    }
}

