/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.ChannelService;
import weblogic.server.channels.DynamicListenThread;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.utils.Debug;

public class AdminPortService
extends AbstractServerService {
    private static boolean DEBUG = false;
    private HashMap adminListeners = new HashMap(11);
    private static AdminPortService singleton;
    private boolean listenersBound = false;

    public AdminPortService() {
        singleton = this;
    }

    public static AdminPortService getInstance() {
        Debug.assertion((singleton != null ? 1 : 0) != 0);
        return singleton;
    }

    public void start() throws ServiceFailureException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getListenersBindEarly()) {
            this.bindListeners();
        }
    }

    synchronized void bindListeners() throws ServiceFailureException {
        if (this.listenersBound) {
            return;
        }
        if (ChannelHelper.isLocalAdminChannelEnabled()) {
            if (DEBUG) {
                AdminPortService.p("start()");
            }
            try {
                if (DEBUG) {
                    ChannelService.dumpTables();
                }
                DynamicListenThreadManager dynamicListenThreadManager = DynamicListenThreadManager.getInstance();
                ArrayList arrayList = ChannelService.findInboundServerChannels(ProtocolHandlerAdmin.PROTOCOL_ADMIN);
                if (DEBUG) {
                    AdminPortService.p("admin channels: " + arrayList);
                }
                for (ServerChannel serverChannel : arrayList) {
                    ArrayList arrayList2 = ChannelService.getDiscriminantSet(serverChannel.getListenerKey());
                    if (this.adminListeners.get(serverChannel.getListenerKey()) != null) continue;
                    DynamicListenThread dynamicListenThread = dynamicListenThreadManager.createListener(arrayList2);
                    dynamicListenThread.setAdminChannel(true);
                    this.adminListeners.put(dynamicListenThread.getKey(), dynamicListenThread);
                    if (dynamicListenThread.start(true, false, true)) continue;
                    throw new ServiceFailureException("Failed to start admin channel " + serverChannel.getChannelName());
                }
            }
            catch (IOException iOException) {
                throw new ServiceFailureException((Throwable)iOException);
            }
            this.listenersBound = true;
        } else if (DEBUG) {
            AdminPortService.p("start() skipped - no admin channels");
        }
    }

    synchronized void addListener(DynamicListenThread dynamicListenThread) {
        if (dynamicListenThread == null) {
            return;
        }
        this.adminListeners.put(dynamicListenThread.getKey(), dynamicListenThread);
    }

    synchronized DynamicListenThread findListener(ServerChannel serverChannel) {
        return (DynamicListenThread)this.adminListeners.get(serverChannel.getListenerKey());
    }

    synchronized void removeListener(DynamicListenThread dynamicListenThread) {
        this.adminListeners.remove(dynamicListenThread.getKey());
    }

    DynamicListenThread stopListener(ServerChannel serverChannel) throws IOException {
        return DynamicListenThreadManager.getInstance().stopListener(serverChannel, this.adminListeners);
    }

    DynamicListenThread restartListener(ServerChannel serverChannel) throws IOException {
        return DynamicListenThreadManager.getInstance().restartListener(serverChannel, this.adminListeners, true);
    }

    public void enable() {
        if (DEBUG) {
            AdminPortService.p("enable()");
        }
        DynamicListenThreadManager.getInstance().enableListeners(this.adminListeners);
    }

    public void stop() {
        this.halt();
    }

    public synchronized void halt() {
        if (DEBUG) {
            AdminPortService.p("halt()");
        }
        DynamicListenThreadManager.getInstance().stopListeners(this.adminListeners);
        this.listenersBound = false;
    }

    public synchronized boolean listenersBound() {
        return this.listenersBound;
    }

    private static void p(String string) {
        System.out.println("<AdminPortService>: " + string);
    }
}

