/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import weblogic.kernel.NetworkAccessPointMBeanStub;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.UnknownProtocolException;
import weblogic.rmi.spi.Channel;

public class BasicServerChannelImpl
implements Externalizable,
ServerChannel,
Comparable {
    static final long serialVersionUID = 3682806476156685669L;
    private static final boolean DEBUG = false;
    protected static final byte HAS_PUBLIC_ADDRESS = 1;
    protected static final byte HAS_LISTEN_PORT = 2;
    protected static final byte HAS_PUBLIC_PORT = 4;
    protected static final byte HAS_LISTEN_ADDRESS = 8;
    protected static final byte SUPPORTS_HTTP = 16;
    protected static final byte SUPPORTS_TLS = 32;
    protected static final byte SUPPORTS_SDP = 64;
    private static final InetAddress LOCALHOST = BasicServerChannelImpl.getLocalHost();
    protected byte flags;
    protected String address;
    private String resolvedAddress;
    protected String channelName;
    protected int listenPort = -1;
    protected int publicPort = -1;
    protected String publicAddress;
    protected int rawAddress;
    protected Protocol protocol;
    protected int priority;
    protected int weight;
    protected transient InetAddress inetAddress;
    protected transient InetSocketAddress inSockAddress;
    protected transient NetworkAccessPointMBean config;
    protected transient boolean implicitChannel;
    protected transient boolean isLocal;
    protected transient String displayName;
    private transient boolean t3SenderQueueDisabled;

    private static final InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            AssertionError assertionError = new AssertionError((Object)"Could not obtain the localhost address. The most likely cause is an error in the network configuration of this machine.");
            ((Throwable)((Object)assertionError)).initCause(unknownHostException);
            throw assertionError;
        }
    }

    public BasicServerChannelImpl() {
    }

    public int hashCode() {
        return this.channelName.hashCode() ^ this.rawAddress ^ this.listenPort ^ this.protocol.getAsURLPrefix().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BasicServerChannelImpl) {
            BasicServerChannelImpl basicServerChannelImpl = (BasicServerChannelImpl)object;
            return basicServerChannelImpl.channelName.equals(this.channelName) && basicServerChannelImpl.rawAddress == this.rawAddress && basicServerChannelImpl.listenPort == this.listenPort && basicServerChannelImpl.protocol.getAsURLPrefix().equals(this.protocol.getAsURLPrefix());
        }
        return false;
    }

    public boolean requiresNAT() {
        return this.hasPublicAddress() || this.hasPublicPort();
    }

    public boolean supportsTLS() {
        return (this.flags & 0x20) != 0;
    }

    boolean isImplicitChannel() {
        return this.implicitChannel;
    }

    boolean isLocal() {
        return this.isLocal;
    }

    public boolean supportsHttp() {
        return (this.flags & 0x10) != 0;
    }

    public NetworkAccessPointMBean getConfig() {
        return this.config;
    }

    public final String getAddress() {
        return this.address;
    }

    public final String getResolvedAddress() {
        if (this.resolvedAddress == null) {
            if (this.isLocal) {
                assert (this.inetAddress != null);
                this.resolvedAddress = this.inetAddress.getHostAddress();
            } else {
                this.resolvedAddress = this.address == null ? this.publicAddress : this.address;
            }
        }
        return this.resolvedAddress;
    }

    public final int getRawAddress() {
        return this.rawAddress;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public int getChannelWeight() {
        return this.weight;
    }

    public String getPublicAddress() {
        return this.publicAddress != null ? this.publicAddress : this.getAddress();
    }

    public int getPublicPort() {
        return this.hasPublicPort() ? this.publicPort : this.listenPort;
    }

    public int getPort() {
        return this.listenPort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolPrefix() {
        return this.protocol.getAsURLPrefix();
    }

    public String getProtocolName() {
        return this.protocol.getProtocolName();
    }

    public final InetAddress address() {
        return this.getInetAddress();
    }

    public InetSocketAddress getPublicInetAddress() {
        return this.inSockAddress;
    }

    public final String getClusterAddress() {
        String string = this.getConfig().getClusterAddress();
        return string == null ? this.getPublicAddress() : string;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public String getListenerKey() {
        return this.getResolvedAddress().toLowerCase() + this.getPort();
    }

    public boolean hasPublicAddress() {
        return (this.flags & 1) != 0;
    }

    protected void setPublicAddress(String string) {
        if (string != null && string.length() > 0 && !string.equals(this.address)) {
            this.publicAddress = string;
            this.flags = (byte)(this.flags | 1);
        }
    }

    protected boolean hasListenAddress() {
        return (this.flags & 8) != 0;
    }

    protected void setListenAddress(String string) {
        if (string != null && string.length() > 0) {
            this.address = string;
            this.flags = (byte)(this.flags | 8);
        }
    }

    protected boolean hasListenPort() {
        return (this.flags & 2) != 0;
    }

    protected void setListenPort(int n) {
        if (n != -1) {
            this.listenPort = n;
            this.flags = (byte)(this.flags | 2);
        }
    }

    protected boolean hasPublicPort() {
        return (this.flags & 4) != 0;
    }

    protected void setPublicPort(int n) {
        if (n != -1 && n != this.listenPort) {
            this.publicPort = n;
            this.flags = (byte)(this.flags | 4);
        }
    }

    public boolean isSDPEnabled() {
        return (this.flags & 0x40) != 0;
    }

    protected void setSDPEnabled(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.channelName);
        stringBuffer.append(':').append(this.getProtocol().getProtocolName()).append('(').append(this.getProtocol().getAsURLPrefix()).append(')');
        stringBuffer.append(':').append(this.address);
        stringBuffer.append(":" + this.listenPort);
        stringBuffer.append(':').append(this.publicAddress);
        stringBuffer.append(":" + this.publicPort);
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        BasicServerChannelImpl basicServerChannelImpl = (BasicServerChannelImpl)object;
        int n = this.priority - basicServerChannelImpl.priority;
        if (n == 0 && this.isImplicitChannel() != basicServerChannelImpl.isImplicitChannel()) {
            int n2 = n = this.isImplicitChannel() ? 1 : -1;
        }
        if (n == 0) {
            NetworkAccessPointMBean networkAccessPointMBean = basicServerChannelImpl.getConfig();
            if (this.config.isOutboundEnabled() && !networkAccessPointMBean.isOutboundEnabled()) {
                n = -1;
            } else if (!this.config.isOutboundEnabled() && networkAccessPointMBean.isOutboundEnabled()) {
                n = 1;
            }
        }
        if (n == 0 && (bl3 = this.getChannelName().startsWith("Default")) != basicServerChannelImpl.getChannelName().startsWith("Default")) {
            int n3 = n = bl3 ? -1 : 1;
        }
        if (n == 0 && (bl2 = this.requiresNAT()) != basicServerChannelImpl.requiresNAT()) {
            int n4 = n = bl2 ? 1 : -1;
        }
        if (n == 0 && (bl = this.address() != null && this.address().isLoopbackAddress()) != (basicServerChannelImpl.address() != null && basicServerChannelImpl.address().isLoopbackAddress())) {
            int n5 = n = bl ? 1 : -1;
        }
        if (n == 0) {
            n = this.getChannelName().compareTo(basicServerChannelImpl.getChannelName());
        }
        return n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.flags);
        objectOutput.writeUTF(this.channelName);
        if (this.hasListenAddress()) {
            objectOutput.writeUTF(this.address);
        }
        objectOutput.writeInt(this.rawAddress);
        objectOutput.writeObject(this.protocol);
        objectOutput.writeInt(this.priority);
        objectOutput.writeInt(this.weight);
        if (this.hasPublicAddress() || !this.hasListenAddress()) {
            objectOutput.writeUTF(this.publicAddress);
        }
        if (this.hasListenPort()) {
            objectOutput.writeInt(this.listenPort);
        }
        if (this.hasPublicPort()) {
            objectOutput.writeInt(this.publicPort);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.flags = objectInput.readByte();
        this.channelName = objectInput.readUTF();
        if (this.hasListenAddress()) {
            this.address = objectInput.readUTF();
        }
        this.rawAddress = objectInput.readInt();
        this.protocol = (Protocol)objectInput.readObject();
        this.priority = objectInput.readInt();
        this.weight = objectInput.readInt();
        if (this.hasPublicAddress() || !this.hasListenAddress()) {
            this.publicAddress = objectInput.readUTF();
        }
        if (this.hasListenPort()) {
            this.listenPort = objectInput.readInt();
        }
        if (this.hasPublicPort()) {
            this.publicPort = objectInput.readInt();
        }
        if (this.getPublicPort() >= 0) {
            this.inSockAddress = new InetSocketAddress(this.getPublicAddress(), this.getPublicPort());
        }
    }

    BasicServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, ServerIdentity serverIdentity) throws UnknownHostException, UnknownProtocolException {
        this(networkAccessPointMBean, ProtocolManager.findProtocol((String)networkAccessPointMBean.getProtocol()), networkAccessPointMBean.getName(), serverIdentity, null);
    }

    public BasicServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, Protocol protocol, ServerIdentity serverIdentity) throws UnknownHostException {
        this(networkAccessPointMBean, protocol, BasicServerChannelImpl.encodeName(protocol, networkAccessPointMBean.getName()), serverIdentity, null);
        this.displayName = networkAccessPointMBean.getName();
    }

    protected static final String encodeName(Protocol protocol, String string) {
        return string + "[" + protocol.getAsURLPrefix() + "]";
    }

    String getRealName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.channelName;
    }

    protected BasicServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, Protocol protocol, String string, ServerIdentity serverIdentity, String string2) throws UnknownHostException {
        if (protocol.isSecure()) {
            this.flags = (byte)(this.flags | 0x20);
        }
        if (!protocol.getProtocolName().equalsIgnoreCase(networkAccessPointMBean.getProtocol())) {
            this.implicitChannel = true;
        }
        this.protocol = protocol;
        this.priority = protocol.getHandler().getPriority();
        this.channelName = string;
        this.config = networkAccessPointMBean;
        this.setListenAddress(string2);
        this.update(serverIdentity);
    }

    public static ServerChannel createBootstrapChannel(String string) throws UnknownHostException {
        BasicServerChannelImpl basicServerChannelImpl = new BasicServerChannelImpl();
        if (string.equalsIgnoreCase("https")) {
            basicServerChannelImpl.flags = (byte)(basicServerChannelImpl.flags | 0x20);
        }
        basicServerChannelImpl.channelName = "BootstrapChannel";
        basicServerChannelImpl.config = NetworkAccessPointMBeanStub.createBootstrapStub();
        if (basicServerChannelImpl.config.getListenAddress() == null) {
            return null;
        }
        basicServerChannelImpl.update(null);
        return basicServerChannelImpl;
    }

    void update(ServerIdentity serverIdentity) throws UnknownHostException {
        Object object;
        this.setListenAddress(this.config.getListenAddress());
        InetAddress inetAddress = null;
        this.setListenPort(this.config.getListenPort());
        this.setPublicPort(this.config.getPublicPort());
        this.setPublicAddress(this.config.getPublicAddress());
        this.setSDPEnabled(this.config.isSDPEnabled());
        this.flags = this.config.isHttpEnabledForThisProtocol() || this.config.isTunnelingEnabled() ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        if (serverIdentity != null && serverIdentity.isLocal()) {
            this.isLocal = true;
            if (this.address == null) {
                inetAddress = LOCALHOST;
                if (!this.hasPublicAddress()) {
                    this.publicAddress = inetAddress.getHostAddress();
                }
            } else {
                this.inetAddress = inetAddress = InetAddress.getByName(this.address);
                if (this.address.indexOf(":") != -1) {
                    this.address = "[" + this.inetAddress.getHostAddress() + "]";
                }
            }
        } else {
            object = this.getPublicAddress();
            if (object == null) {
                if (serverIdentity instanceof Channel) {
                    object = ((Channel)serverIdentity).getPublicAddress();
                }
                if (object == null) {
                    throw new UnknownHostException("Couldn't determine usable host address for remote channel: " + this.config.getName());
                }
                this.setPublicAddress((String)object);
            }
            this.inetAddress = inetAddress = InetAddress.getByName((String)object);
        }
        object = inetAddress.getAddress();
        this.rawAddress = ((object[0] & 0xFF) << 24) + ((object[1] & 0xFF) << 16) + ((object[2] & 0xFF) << 8) + ((object[3] & 0xFF) << 0);
        if (this.getPublicPort() >= 0) {
            this.inSockAddress = new InetSocketAddress(this.getPublicAddress(), this.getPublicPort());
        }
        this.weight = this.config.getChannelWeight();
    }

    void update() {
        this.weight = this.config.getChannelWeight();
        if (this.address != null) {
            this.setPublicAddress(this.config.getPublicAddress());
        }
        this.setPublicPort(this.config.getPublicPort());
    }

    protected BasicServerChannelImpl(BasicServerChannelImpl basicServerChannelImpl, Protocol protocol) {
        this.flags = basicServerChannelImpl.flags;
        this.displayName = basicServerChannelImpl.displayName;
        this.listenPort = basicServerChannelImpl.listenPort;
        this.publicPort = basicServerChannelImpl.publicPort;
        this.weight = basicServerChannelImpl.weight;
        this.config = basicServerChannelImpl.config;
        this.publicAddress = basicServerChannelImpl.publicAddress;
        this.address = basicServerChannelImpl.address;
        this.inetAddress = basicServerChannelImpl.inetAddress;
        this.rawAddress = basicServerChannelImpl.rawAddress;
        this.inSockAddress = basicServerChannelImpl.inSockAddress;
        this.implicitChannel = true;
        this.protocol = protocol;
        this.isLocal = basicServerChannelImpl.isLocal;
        this.priority = protocol.getHandler().getPriority();
        if (this.displayName == null) {
            this.displayName = basicServerChannelImpl.channelName;
        }
        this.channelName = BasicServerChannelImpl.encodeName(protocol, this.displayName);
    }

    private static void p(String string) {
        System.out.println("<BasicServerChannelImpl>: " + string);
    }

    public static ServerChannel createDefaultServerChannel(Protocol protocol) {
        try {
            return new BasicServerChannelImpl(new NetworkAccessPointMBeanStub(protocol.getProtocolName()), protocol, LocalServerIdentity.getIdentity());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public String getConfiguredProtocol() {
        return this.config.getProtocol();
    }

    public int getAcceptBacklog() {
        return this.config.getAcceptBacklog();
    }

    public int getCompleteMessageTimeout() {
        return this.config.getCompleteMessageTimeout();
    }

    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    public int getIdleConnectionTimeout() {
        return this.config.getIdleConnectionTimeout();
    }

    public int getLoginTimeoutMillis() {
        return this.config.getLoginTimeoutMillis();
    }

    public int getMaxBackoffBetweenFailures() {
        return this.config.getMaxBackoffBetweenFailures();
    }

    public int getMaxConnectedClients() {
        return this.config.getMaxConnectedClients();
    }

    public int getMaxMessageSize() {
        return this.config.getMaxMessageSize();
    }

    public String getProxyAddress() {
        return this.config.getProxyAddress();
    }

    public int getProxyPort() {
        return this.config.getProxyPort();
    }

    public boolean getTimeoutConnectionWithPendingResponses() {
        return this.config.getTimeoutConnectionWithPendingResponses();
    }

    public int getTunnelingClientPingSecs() {
        return this.config.getTunnelingClientPingSecs();
    }

    public int getTunnelingClientTimeoutSecs() {
        return this.config.getTunnelingClientTimeoutSecs();
    }

    public boolean getUseFastSerialization() {
        return this.config.getUseFastSerialization();
    }

    public boolean isClientCertificateEnforced() {
        return this.config.isClientCertificateEnforced();
    }

    public boolean isHttpEnabledForThisProtocol() {
        return this.config.isHttpEnabledForThisProtocol();
    }

    public boolean isOutboundEnabled() {
        return this.config.isOutboundEnabled();
    }

    public boolean isOutboundPrivateKeyEnabled() {
        return this.config.isOutboundPrivateKeyEnabled();
    }

    public boolean isTunnelingEnabled() {
        return this.config.isTunnelingEnabled();
    }

    public boolean isTwoWaySSLEnabled() {
        return this.config.isTwoWaySSLEnabled();
    }

    public boolean isT3SenderQueueDisabled() {
        return this.t3SenderQueueDisabled;
    }

    void setT3SenderQueueDisabled(boolean bl) {
        this.t3SenderQueueDisabled = bl;
    }
}

