/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import weblogic.protocol.ChannelList;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.server.channels.ChannelService;
import weblogic.server.channels.RemoteChannelService;
import weblogic.server.channels.RemoteChannelServiceImpl;

class ChannelListImpl
implements ChannelList {
    private ServerIdentity id;
    private RemoteChannelService service;

    public ChannelListImpl() {
        this.id = LocalServerIdentity.getIdentity();
        this.service = (RemoteChannelService)RemoteChannelServiceImpl.getInstance();
    }

    public ChannelListImpl(ServerIdentity serverIdentity) {
        this.id = serverIdentity;
    }

    public ServerIdentity getIdentity() {
        return this.id;
    }

    public RemoteChannelService getChannelService() {
        return this.service;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (!ChannelService.hasChannels(this.id)) {
            return null;
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.service);
        ChannelService.exportServerChannels(this.id, objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ServerIdentity)objectInput.readObject();
        this.service = (RemoteChannelService)objectInput.readObject();
        ChannelService.importServerChannels(this.id, objectInput);
    }
}

