/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.rmi.RemoteException;
import java.security.AccessController;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.ChannelService;

public class ChannelRuntimeService
extends AbstractServerService {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        try {
            ChannelService channelService = (ChannelService)ServerChannelManager.getServerChannelManager();
            channelService.registerRuntimeService();
            ManagementService.getPropertyService(kernelId).setChannelServiceReady();
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
    }
}

