/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import weblogic.cluster.ClusterService;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.net.http.HttpURLConnection;
import weblogic.protocol.AdminServerIdentity;
import weblogic.protocol.ChannelList;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.protocol.UnknownProtocolException;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.protocol.configuration.NetworkAccessPointDefaultMBean;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.SubjectManager;
import weblogic.security.utils.SSLContextManager;
import weblogic.server.ServerLogger;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.AddressUtils;
import weblogic.server.channels.AdminPortService;
import weblogic.server.channels.BasicServerChannelImpl;
import weblogic.server.channels.ChannelListImpl;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.server.channels.EnableAdminListenersService;
import weblogic.server.channels.RemoteChannelService;
import weblogic.server.channels.RemoteChannelServiceImpl;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.server.channels.ServerThrottle;
import weblogic.socket.ChannelSocketFactory;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.utils.net.InetAddressHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelService
extends ServerChannelManager
implements ServerService,
BeanUpdateListener {
    private static final int EXPECTED_SERVERS = 63;
    private static final int EXPECTED_CHANNELS = 31;
    private static final int EXPECTED_PROTOCOLS = 16;
    private static ConcurrentHashMap channelMap = new ConcurrentHashMap(63);
    private static ConcurrentHashMap channelsByName = new ConcurrentHashMap(63);
    private static ConcurrentHashMap localChannels = new ConcurrentHashMap(31);
    private static ConcurrentHashMap localChannelsByProtocol = new ConcurrentHashMap(16);
    private static ConcurrentHashMap localChannelsByName = new ConcurrentHashMap(31);
    private static ConcurrentHashMap EMPTY_MAP = new ConcurrentHashMap(1);
    private static boolean initialized = false;
    private static boolean DEBUG = false;
    private static boolean DEBUG_MAP = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static RuntimeAccess runtimeAccess;
    private long adminChannelCreationTime;
    private static ArrayList<String> replicationChannelNames;
    private boolean inCreateChannels = false;

    public String getName() {
        return "ChannelService";
    }

    public String getVersion() {
        return null;
    }

    public void start() throws ServiceFailureException {
        try {
            runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            if (!ChannelHelper.checkConsistency(runtimeAccess.getServer())) {
                throw new ServiceFailureException("Network configuration error, check log for details.");
            }
            ChannelHelper.logChannelConfiguration(runtimeAccess.getServer());
            if (DEBUG) {
                ChannelService.p("Admin protocol is: " + ProtocolManager.getRealProtocol((Protocol)PROTOCOL.ADMIN).getAsURLPrefix());
            }
            ServerURL.setIsServer((boolean)true);
            this.initializeServerChannels();
            initialized = true;
            ServerChannelManager.setServerChannelManager((ServerChannelManager)this);
            if (AdminServerIdentity.getBootstrapIdentity() != null) {
                boolean bl;
                boolean bl2 = ServerChannelManager.findServerChannel((HostID)LocalServerIdentity.getIdentity(), (Protocol)PROTOCOL.ADMIN) != null;
                boolean bl3 = bl = ServerChannelManager.findServerChannel((HostID)AdminServerIdentity.getBootstrapIdentity(), (Protocol)PROTOCOL.ADMIN) != null;
                if (bl2 && !bl || bl && !bl2) {
                    ServerLogger.logAdminChannelConflict();
                    throw new ServiceFailureException("Domain configuration must have at least one admin channel on every server, or none at all");
                }
            }
            if (URLManager.findAdministrationURL(LocalServerIdentity.getIdentity()) == null) {
                throw new ServiceFailureException("The server has no configured channels");
            }
            if (AdminServerIdentity.getBootstrapIdentity() != null && !AdminServerIdentity.getBootstrapIdentity().isLocal() && ChannelService.isLocalChannel(URLManager.findAdministrationURL(AdminServerIdentity.getBootstrapIdentity()))) {
                throw new ServiceFailureException("The server's administration channel conflicts with the admin server's");
            }
            this.resetQOS();
            RemoteChannelServiceImpl.getInstance().addConnectDisconnectListener((weblogic.rmi.extensions.ConnectListener)new ConnectListener(), (weblogic.rmi.extensions.DisconnectListener)new DisconnectListener());
            this.injectChannelBasedSocketFactories();
            ServerLogger.logChannelsEnabled();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServiceFailureException("Initialization Failed", (Throwable)unknownHostException);
        }
    }

    private void injectChannelBasedSocketFactories() {
        ServerChannel serverChannel = PROTOCOL.HTTP.getHandler().getDefaultServerChannel();
        if (serverChannel != null) {
            HttpURLConnection.setDefaultSocketFactory(new ChannelSocketFactory(serverChannel));
        }
    }

    private void resetQOS() {
        byte by;
        if (ChannelService.findLocalServerChannel((Protocol)PROTOCOL.ADMIN) == null) {
            by = 101;
            if (DEBUG) {
                ChannelService.p("Kernel and Server Identity is now QOS_ANY");
            }
        } else {
            by = 103;
            if (DEBUG) {
                ChannelService.p("Kernel and Server Identity is now QOS_ADMIN");
            }
        }
        kernelId.setQOS(by);
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.sendASToWire((AuthenticatedSubject)kernelId);
        if (authenticatedSubject != null) {
            authenticatedSubject.setQOS(by);
        }
    }

    private void initializeServerChannels() throws UnknownHostException {
        HashMap hashMap = this.createServerChannels(ManagementService.getRuntimeAccess(kernelId).getServer(), LocalServerIdentity.getIdentity(), localChannelsByProtocol, localChannelsByName);
        for (Map.Entry entry : hashMap.entrySet()) {
            localChannels.put(entry.getKey(), entry.getValue());
        }
        channelMap.put(LocalServerIdentity.getIdentity(), localChannelsByProtocol);
        channelsByName.put(LocalServerIdentity.getIdentity(), localChannelsByName);
    }

    void registerRuntimeService() throws ManagementException, RemoteException {
        runtimeAccess.getServer().addBeanUpdateListener(this);
        SSLMBean sSLMBean = runtimeAccess.getServer().getSSL();
        sSLMBean.addBeanUpdateListener(this);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        domainMBean.addBeanUpdateListener(this);
        for (ArrayList arrayList : localChannelsByProtocol.values()) {
            for (ServerChannelImpl serverChannelImpl : arrayList) {
                ((ServerRuntime)runtimeAccess.getServerRuntime()).addServerChannelRuntime(serverChannelImpl.createRuntime());
                if (!DEBUG) continue;
                ChannelService.p("added runtime for: " + serverChannelImpl);
            }
        }
        ServerHelper.exportObject((Remote)((Remote)RemoteChannelServiceImpl.getInstance()));
    }

    private AbstractMap findOrCreateChannels(ServerIdentity serverIdentity) {
        if (serverIdentity.isClient()) {
            return null;
        }
        AbstractMap abstractMap = (AbstractMap)channelMap.get(serverIdentity);
        if (abstractMap == null && serverIdentity.getDomainName().equals(LocalServerIdentity.getIdentity().getDomainName())) {
            this.createChannels(serverIdentity);
            abstractMap = (AbstractMap)channelMap.get(serverIdentity);
        }
        return abstractMap;
    }

    private AbstractMap findOrCreateNamedChannels(ServerIdentity serverIdentity) {
        if (serverIdentity.isClient()) {
            return null;
        }
        AbstractMap abstractMap = (AbstractMap)channelsByName.get(serverIdentity);
        if (abstractMap == null && serverIdentity.getDomainName().equals(LocalServerIdentity.getIdentity().getDomainName())) {
            this.createChannels(serverIdentity);
            abstractMap = (AbstractMap)channelsByName.get(serverIdentity);
        }
        return abstractMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createChannels(final ServerIdentity serverIdentity) {
        if (this.inCreateChannels) {
            return;
        }
        try {
            try {
                this.inCreateChannels = true;
                SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        RemoteChannelServiceImpl.retrieveRemoteChannels(serverIdentity);
                        if (channelMap.get(serverIdentity) != null) {
                            return null;
                        }
                        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(31);
                        ConcurrentHashMap concurrentHashMap2 = new ConcurrentHashMap(31);
                        ServerMBean serverMBean = ChannelService.this.getServer(serverIdentity.getServerName());
                        if (serverMBean != null) {
                            ChannelService.this.createServerChannels(serverMBean, serverIdentity, concurrentHashMap, concurrentHashMap2);
                            channelMap.put(serverIdentity, concurrentHashMap);
                            channelsByName.put(serverIdentity, concurrentHashMap2);
                        } else {
                            channelMap.put(serverIdentity, EMPTY_MAP);
                            channelsByName.put(serverIdentity, EMPTY_MAP);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Object var4_3 = null;
                this.inCreateChannels = false;
            }
            Object var4_2 = null;
            this.inCreateChannels = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.inCreateChannels = false;
            throw throwable;
        }
    }

    private ServerMBean getServer(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return domainMBean.lookupServer(string);
    }

    private synchronized HashMap createServerChannels(ServerMBean serverMBean, ServerIdentity serverIdentity, AbstractMap abstractMap, AbstractMap abstractMap2) throws UnknownHostException {
        Object object;
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = serverMBean.getNetworkAccessPoints();
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            NetworkAccessPointMBean object22 = networkAccessPointMBeanArray[i];
            if (serverIdentity != null && serverIdentity.isLocal()) {
                object22.addBeanUpdateListener(this);
            }
            if (!object22.isEnabled()) continue;
            try {
                object = new ServerChannelImpl(object22, serverIdentity);
                ChannelService.addServerChannel((ServerChannelImpl)object, hashMap, abstractMap, abstractMap2);
                continue;
            }
            catch (Exception exception) {
                ServerLogger.logChannelConfigurationFailed((String)object22.getName(), (Exception)exception);
            }
        }
        if (ChannelHelper.isMultipleReplicationChannelsConfigured(serverMBean)) {
            this.createAdditionalReplicationChannels(serverMBean, hashMap, abstractMap, abstractMap2);
        }
        Iterator<Map.Entry<String, ArrayList<Object>>> iterator = ProtocolManager.iterator();
        while (iterator.hasNext()) {
            Protocol protocol = (Protocol)iterator.next();
            if ((protocol.toByte() == 12 || protocol.toByte() == 13) && serverMBean.getCluster() == null || !protocol.isEnabled()) continue;
            if (serverIdentity != null && serverIdentity.isLocal()) {
                ServerChannelImpl serverChannelImpl;
                object = protocol.getHandler().getDefaultServerChannel();
                if (object == null || !(object instanceof ServerChannelImpl) || !(serverChannelImpl = (ServerChannelImpl)object).getConfig().isEnabled() || protocol.getHandler().getPriority() < 0) continue;
                ChannelService.addServerChannel(serverChannelImpl, hashMap, abstractMap, abstractMap2);
                continue;
            }
            object = new NetworkAccessPointDefaultMBean(protocol, serverMBean);
            if (!object.isEnabled()) continue;
            ChannelService.addServerChannel(new ServerChannelImpl((NetworkAccessPointMBean)object, protocol, serverIdentity), hashMap, abstractMap, abstractMap2);
        }
        for (Map.Entry<String, ArrayList> entry : hashMap.entrySet()) {
            object = entry.getValue();
            Collections.sort(object);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Object object2 = ((ArrayList)object).iterator();
            block11: while (object2.hasNext()) {
                ServerChannelImpl serverChannelImpl = (ServerChannelImpl)object2.next();
                switch (serverChannelImpl.getProtocol().toByte()) {
                    case 1: 
                    case 3: {
                        bl2 = true;
                        continue block11;
                    }
                    case 10: 
                    case 11: {
                        bl4 = true;
                        continue block11;
                    }
                    case 12: 
                    case 13: {
                        bl5 = true;
                        if (!serverChannelImpl.supportsHttp()) continue block11;
                        bl = true;
                        continue block11;
                    }
                    case 6: {
                        bl3 = true;
                        if (ProtocolManager.getRealProtocol((Protocol)serverChannelImpl.getProtocol()) != PROTOCOL.HTTP && ProtocolManager.getRealProtocol((Protocol)serverChannelImpl.getProtocol()) != PROTOCOL.HTTPS) break;
                        bl2 = true;
                    }
                }
                if (!serverChannelImpl.supportsHttp()) continue;
                bl = true;
            }
            if (!bl5 && serverMBean.getCluster() != null) {
                object2 = (ServerChannelImpl)((ArrayList)object).get(0);
                if (((BasicServerChannelImpl)object2).supportsTLS()) {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.CLUSTERS), hashMap, abstractMap, abstractMap2);
                } else {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.CLUSTER), hashMap, abstractMap, abstractMap2);
                }
            }
            if (bl3 && !bl4) {
                object2 = (ServerChannelImpl)((ArrayList)object).get(0);
                if (((BasicServerChannelImpl)object2).supportsTLS()) {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.LDAPS), hashMap, abstractMap, abstractMap2);
                } else {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.LDAP), hashMap, abstractMap, abstractMap2);
                }
            }
            if (bl && !bl2) {
                object2 = (ServerChannelImpl)((ArrayList)object).get(0);
                if (((BasicServerChannelImpl)object2).supportsTLS()) {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.HTTPS), hashMap, abstractMap, abstractMap2);
                } else {
                    ChannelService.addServerChannel(((ServerChannelImpl)object2).createImplicitChannel(PROTOCOL.HTTP), hashMap, abstractMap, abstractMap2);
                }
            }
            Collections.sort(object);
        }
        for (ArrayList arrayList : abstractMap.values()) {
            Collections.sort(arrayList);
        }
        for (ArrayList arrayList : abstractMap2.values()) {
            Collections.sort(arrayList);
        }
        return hashMap;
    }

    private void createAdditionalReplicationChannels(ServerMBean serverMBean, AbstractMap<String, ArrayList> abstractMap, AbstractMap<Protocol, ArrayList> abstractMap2, AbstractMap<String, ArrayList> abstractMap3) throws UnknownHostException {
        ClusterMBean clusterMBean = serverMBean.getCluster();
        String string = clusterMBean.getReplicationChannel();
        ArrayList arrayList = abstractMap3.get(string);
        ServerChannelImpl serverChannelImpl = (ServerChannelImpl)arrayList.get(0);
        boolean bl = clusterMBean.isOneWayRmiForReplicationEnabled();
        try {
            int[] nArray = this.parseReplicationPorts(serverMBean.getReplicationPorts());
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                ServerChannelImpl serverChannelImpl2 = serverChannelImpl.cloneChannel(String.valueOf(i + 1));
                serverChannelImpl2.listenPort = nArray[i];
                if (serverChannelImpl2.publicPort > -1) {
                    serverChannelImpl2.publicPort = serverChannelImpl2.listenPort;
                }
                if (bl) {
                    serverChannelImpl2.setT3SenderQueueDisabled(true);
                }
                replicationChannelNames.add(serverChannelImpl2.getChannelName());
                ChannelService.addServerChannel(serverChannelImpl2, abstractMap, abstractMap2, abstractMap3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ServerLogger.logChannelConfigurationFailed((String)string, (Exception)new Exception("Failed to parse replication ports for server " + serverMBean.getName() + " port range: " + serverMBean.getReplicationPorts()));
        }
    }

    private int[] parseReplicationPorts(String string) throws NumberFormatException {
        int[] nArray = null;
        String[] stringArray = string.split("-");
        switch (stringArray.length) {
            case 1: {
                nArray = new int[]{Integer.valueOf(stringArray[0].trim())};
                return nArray;
            }
            case 2: {
                int n = Integer.valueOf(stringArray[0].trim());
                int n2 = Integer.valueOf(stringArray[1].trim());
                if (n2 - n <= 0) break;
                nArray = new int[n2 - n + 1];
                int n3 = n;
                int n4 = 0;
                while (n3 <= n2) {
                    nArray[n4] = n3++;
                    ++n4;
                }
                return nArray;
            }
        }
        throw new NumberFormatException();
    }

    public static List<String> getReplicationChannelNames() {
        return replicationChannelNames;
    }

    private static void addServerChannel(ServerChannelImpl serverChannelImpl, AbstractMap abstractMap, AbstractMap abstractMap2, AbstractMap abstractMap3) throws UnknownHostException {
        ArrayList<ServerChannelImpl> arrayList;
        if (serverChannelImpl.getConfig() != null && !serverChannelImpl.getConfig().isEnabled()) {
            if (DEBUG) {
                ChannelService.p("channel " + serverChannelImpl.toString() + " is not enabled");
            }
            return;
        }
        if (serverChannelImpl.isLocal() && serverChannelImpl.getAddress() == null) {
            ChannelService.addServerChannel(new ServerChannelImpl(serverChannelImpl, AddressUtils.getIPAny(0, ChannelService.resolveDNS()), ""), abstractMap, abstractMap2, abstractMap3);
            for (int i = 1; i < AddressUtils.getIPAny().length; ++i) {
                ChannelService.addServerChannel(new ServerChannelImpl(serverChannelImpl, AddressUtils.getIPAny(i, ChannelService.resolveDNS()), "[" + i + "]"), abstractMap, abstractMap2, abstractMap3);
            }
            return;
        }
        if (DEBUG) {
            ChannelService.p("adding " + serverChannelImpl.toString());
        }
        String string = serverChannelImpl.getListenerKey();
        if (abstractMap != null) {
            arrayList = (ArrayList<ServerChannelImpl>)abstractMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ServerChannelImpl>();
                abstractMap.put(string, arrayList);
            }
            arrayList.add(serverChannelImpl);
        }
        if ((arrayList = (ArrayList)abstractMap2.get(serverChannelImpl.getProtocol())) == null) {
            arrayList = new ArrayList();
            abstractMap2.put(serverChannelImpl.getProtocol(), arrayList);
        }
        arrayList.add(serverChannelImpl);
        arrayList = (ArrayList<ServerChannelImpl>)abstractMap3.get(serverChannelImpl.getChannelName());
        if (arrayList == null) {
            arrayList = new ArrayList<ServerChannelImpl>();
            abstractMap3.put(serverChannelImpl.getChannelName(), arrayList);
        }
        arrayList.add(serverChannelImpl);
    }

    private ServerChannelImpl[] expandServerChannels(ServerIdentity serverIdentity, ServerChannelImpl serverChannelImpl) throws IOException, UnknownHostException {
        if (serverIdentity.isLocal() && serverChannelImpl.getAddress() == null) {
            ServerChannelImpl[] serverChannelImplArray = new ServerChannelImpl[AddressUtils.getIPAny().length];
            serverChannelImplArray[0] = new ServerChannelImpl(serverChannelImpl, AddressUtils.getIPAny(0, ChannelService.resolveDNS()), "");
            for (int i = 1; i < AddressUtils.getIPAny().length; ++i) {
                serverChannelImplArray[i] = new ServerChannelImpl(serverChannelImpl, AddressUtils.getIPAny(i, ChannelService.resolveDNS()), "[" + i + "]");
            }
            return serverChannelImplArray;
        }
        return new ServerChannelImpl[]{serverChannelImpl};
    }

    private ServerChannelImpl[] expandServerChannels(ServerIdentity serverIdentity, NetworkAccessPointMBean networkAccessPointMBean) throws IOException, UnknownHostException, UnknownProtocolException {
        return this.expandServerChannels(serverIdentity, new ServerChannelImpl(networkAccessPointMBean, serverIdentity));
    }

    private static boolean resolveDNS() {
        return runtimeAccess.getServer().isReverseDNSAllowed();
    }

    private void addLocalServerChannels(ServerChannelImpl serverChannelImpl) throws IOException, UnknownHostException, ManagementException {
        ServerChannelImpl[] serverChannelImplArray = this.expandServerChannels(LocalServerIdentity.getIdentity(), serverChannelImpl);
        for (int i = 0; i < serverChannelImplArray.length; ++i) {
            this.addLocalServerChannel(serverChannelImplArray[i]);
        }
    }

    private ArrayList addLocalServerChannel(ServerChannelImpl serverChannelImpl) throws IOException, UnknownHostException, ManagementException {
        Object object;
        ServerIdentity serverIdentity = LocalServerIdentity.getIdentity();
        serverChannelImpl.update(serverIdentity);
        ArrayList arrayList = ChannelService.getDiscriminantSet(serverChannelImpl.getListenerKey());
        NetworkAccessPointMBean networkAccessPointMBean = serverChannelImpl.getConfig();
        boolean bl = serverChannelImpl.getProtocol() == PROTOCOL.ADMIN;
        boolean bl2 = !(!networkAccessPointMBean.isHttpEnabledForThisProtocol() && !networkAccessPointMBean.isTunnelingEnabled() || !bl && networkAccessPointMBean instanceof NetworkAccessPointDefaultMBean || ProtocolManager.getRealProtocol((Protocol)serverChannelImpl.getProtocol()) == PROTOCOL.HTTP || ProtocolManager.getRealProtocol((Protocol)serverChannelImpl.getProtocol()) == PROTOCOL.HTTPS);
        boolean bl3 = networkAccessPointMBean.isEnabled();
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ServerChannelImpl serverChannelImpl2 = (ServerChannelImpl)object.next();
                if (serverChannelImpl2.getProtocol() == serverChannelImpl.getProtocol()) {
                    serverChannelImpl2.update(serverIdentity);
                    bl3 = false;
                    continue;
                }
                if (serverChannelImpl2.getProtocol() == PROTOCOL.HTTP || serverChannelImpl2.getProtocol() == PROTOCOL.HTTPS) {
                    if (!serverChannelImpl.supportsHttp() && serverChannelImpl2.isImplicitChannel()) {
                        object.remove();
                        ChannelService.getServerRuntime().removeServerChannelRuntime(serverChannelImpl2.deleteRuntime());
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (serverChannelImpl2.getProtocol() != PROTOCOL.LDAP && serverChannelImpl2.getProtocol() != PROTOCOL.LDAPS) continue;
                bl = false;
            }
        }
        if (bl3) {
            ChannelService.addServerChannel(serverChannelImpl, localChannels, localChannelsByProtocol, localChannelsByName);
            ChannelService.getServerRuntime().addServerChannelRuntime(serverChannelImpl.createRuntime());
        }
        if (bl) {
            if (serverChannelImpl.supportsTLS()) {
                object = serverChannelImpl.createImplicitChannel(PROTOCOL.LDAPS);
                ChannelService.addServerChannel((ServerChannelImpl)object, localChannels, localChannelsByProtocol, localChannelsByName);
                ChannelService.getServerRuntime().addServerChannelRuntime(((ServerChannelImpl)object).createRuntime());
            } else {
                object = serverChannelImpl.createImplicitChannel(PROTOCOL.LDAP);
                ChannelService.addServerChannel((ServerChannelImpl)object, localChannels, localChannelsByProtocol, localChannelsByName);
                ChannelService.getServerRuntime().addServerChannelRuntime(((ServerChannelImpl)object).createRuntime());
            }
        }
        if (bl2) {
            if (serverChannelImpl.supportsTLS()) {
                object = serverChannelImpl.createImplicitChannel(PROTOCOL.HTTPS);
                ChannelService.addServerChannel((ServerChannelImpl)object, localChannels, localChannelsByProtocol, localChannelsByName);
                ChannelService.getServerRuntime().addServerChannelRuntime(((ServerChannelImpl)object).createRuntime());
            } else {
                object = serverChannelImpl.createImplicitChannel(PROTOCOL.HTTP);
                ChannelService.addServerChannel((ServerChannelImpl)object, localChannels, localChannelsByProtocol, localChannelsByName);
                ChannelService.getServerRuntime().addServerChannelRuntime(((ServerChannelImpl)object).createRuntime());
            }
        }
        return ChannelService.getDiscriminantSet(serverChannelImpl.getListenerKey());
    }

    private synchronized void updateLocalServerChannel(NetworkAccessPointMBean networkAccessPointMBean) {
        if (DEBUG) {
            ChannelService.p("updateLocalServerChannel(" + networkAccessPointMBean + ")");
        }
        try {
            ServerChannelImpl[] serverChannelImplArray = this.expandServerChannels(LocalServerIdentity.getIdentity(), networkAccessPointMBean);
            for (int i = 0; i < serverChannelImplArray.length; ++i) {
                this.addLocalServerChannel(serverChannelImplArray[i]);
                if (networkAccessPointMBean.getProtocol().equalsIgnoreCase("ADMIN")) {
                    this.adminChannelCreationTime = System.currentTimeMillis();
                    AdminPortService.getInstance().restartListener(serverChannelImplArray[i]);
                    continue;
                }
                DynamicListenThreadManager.getInstance().restartListener(serverChannelImplArray[i]);
            }
        }
        catch (Exception exception) {
            ServerLogger.logChannelConfigurationFailed((String)networkAccessPointMBean.getName(), (Exception)exception);
        }
    }

    private synchronized void removeLocalServerChannel(NetworkAccessPointMBean networkAccessPointMBean) {
        if (DEBUG) {
            ChannelService.p("removeLocalServerChannel(" + networkAccessPointMBean + ")");
        }
        try {
            ServerIdentity serverIdentity = LocalServerIdentity.getIdentity();
            ServerChannelImpl[] serverChannelImplArray = this.expandServerChannels(serverIdentity, networkAccessPointMBean);
            for (int i = 0; i < serverChannelImplArray.length; ++i) {
                ArrayList arrayList = ChannelService.getDiscriminantSet(serverChannelImplArray[i].getListenerKey());
                if (arrayList == null) continue;
                if (serverChannelImplArray[i].getProtocol() == PROTOCOL.ADMIN) {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        this.removeLocalServerChannelMappings((ServerChannelImpl)iterator.next());
                    }
                    arrayList.clear();
                    AdminPortService.getInstance().stopListener(serverChannelImplArray[i]);
                    continue;
                }
                boolean bl = false;
                ServerChannelImpl serverChannelImpl = null;
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    ServerChannelImpl serverChannelImpl2 = (ServerChannelImpl)object.next();
                    if (serverChannelImpl2.equals(serverChannelImplArray[i]) || serverChannelImpl2.isImplicitChannel()) {
                        object.remove();
                        this.removeLocalServerChannelMappings(serverChannelImpl2);
                        continue;
                    }
                    if (serverChannelImpl2.getProtocol() == PROTOCOL.HTTP || serverChannelImpl2.getProtocol() == PROTOCOL.HTTPS) {
                        bl = true;
                        continue;
                    }
                    if (!serverChannelImpl2.supportsHttp()) continue;
                    serverChannelImpl = serverChannelImpl2;
                }
                if (serverChannelImpl != null && !bl) {
                    object = serverChannelImplArray[i].supportsTLS() ? serverChannelImpl.createImplicitChannel(PROTOCOL.HTTPS) : serverChannelImpl.createImplicitChannel(PROTOCOL.HTTP);
                    arrayList.add(object);
                    try {
                        ChannelService.getServerRuntime().addServerChannelRuntime(((ServerChannelImpl)object).createRuntime());
                    }
                    catch (ManagementException managementException) {
                        ServerLogger.logChannelConfigurationFailed((String)((BasicServerChannelImpl)object).getChannelName(), (Exception)((Object)managementException));
                    }
                }
                DynamicListenThreadManager.getInstance().restartListener(serverChannelImplArray[i]);
            }
        }
        catch (Exception exception) {
            ServerLogger.logChannelConfigurationFailed((String)networkAccessPointMBean.getName(), (Exception)exception);
        }
    }

    private synchronized void removeDefaultServerChannel(ServerChannelImpl serverChannelImpl) {
        ArrayList arrayList = (ArrayList)localChannels.remove(serverChannelImpl.getListenerKey());
        if (DEBUG && arrayList == null) {
            ChannelService.p("Could not remove: " + serverChannelImpl);
        }
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeLocalServerChannelMappings((ServerChannelImpl)iterator.next());
            }
        }
    }

    private void removeLocalServerChannelMappings(ServerChannelImpl serverChannelImpl) {
        ArrayList arrayList;
        if (DEBUG) {
            ChannelService.p("removing " + serverChannelImpl.toString());
        }
        Object v = localChannelsByName.remove(serverChannelImpl.getChannelName());
        if (DEBUG && v == null) {
            ChannelService.p("Could not remove: " + serverChannelImpl);
        }
        if (serverChannelImpl.getRuntime() != null) {
            ChannelService.getServerRuntime().removeServerChannelRuntime(serverChannelImpl.deleteRuntime());
        }
        if ((arrayList = (ArrayList)localChannelsByProtocol.get(serverChannelImpl.getProtocol())) != null) {
            arrayList.remove(serverChannelImpl);
        }
    }

    private void restartChannelSet(ServerChannelImpl[] serverChannelImplArray) throws IOException {
        for (int i = 0; i < serverChannelImplArray.length; ++i) {
            if (DEBUG) {
                ChannelService.p("restartChannelSet(" + serverChannelImplArray[i] + ")");
            }
            DynamicListenThreadManager.getInstance().restartListener(serverChannelImplArray[i]);
        }
    }

    private synchronized void updateDefaultChannels(boolean bl) {
        try {
            this.stopDefaultChannels(bl);
            ArrayList arrayList = new ArrayList();
            ServerChannelImpl[] serverChannelImplArray = this.updateAndGetDefaultChannels(bl, arrayList);
            if (serverChannelImplArray != null && serverChannelImplArray.length > 0) {
                if (this.isChannelListenKeyInUse(serverChannelImplArray[0], !bl)) {
                    this.stopDefaultChannels(!bl);
                    this.updateAndGetDefaultChannels(!bl, null);
                }
                this.addLocalServerChannels(arrayList);
                this.restartChannelSet(serverChannelImplArray);
            }
        }
        catch (IOException iOException) {
            ServerLogger.logProtocolNotConfigured((String)iOException.getMessage());
        }
    }

    private boolean isChannelListenKeyInUse(ServerChannel serverChannel, boolean bl) {
        ServerChannel[] serverChannelArray;
        ArrayList arrayList;
        boolean bl2 = false;
        if (serverChannel != null && (arrayList = ChannelService.getDiscriminantSet(serverChannel.getListenerKey())) != null && (serverChannelArray = arrayList.toArray(new ServerChannel[0])) != null) {
            int n = 0;
            while (n++ < serverChannelArray.length && !bl2) {
                if (serverChannelArray[n] == null || serverChannelArray[n].supportsTLS() != bl) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    private ServerChannelImpl[] updateAndGetDefaultChannels(boolean bl, ArrayList arrayList) throws IOException {
        ServerChannelImpl[] serverChannelImplArray = null;
        Iterator iterator = ProtocolManager.iterator();
        while (iterator.hasNext()) {
            ServerChannelImpl serverChannelImpl;
            Protocol protocol = (Protocol)iterator.next();
            if (!protocol.isEnabled() || protocol.isSecure() != bl || protocol.getQOS() == 103 || (serverChannelImpl = (ServerChannelImpl)protocol.getHandler().getDefaultServerChannel()) == null || !serverChannelImpl.getConfig().isEnabled() || protocol.getHandler().getPriority() < 0) continue;
            serverChannelImpl.update(LocalServerIdentity.getIdentity());
            serverChannelImplArray = this.expandServerChannels(LocalServerIdentity.getIdentity(), serverChannelImpl);
            for (int i = 0; i < serverChannelImplArray.length; ++i) {
                if (arrayList == null) continue;
                arrayList.add(serverChannelImplArray[i]);
            }
        }
        return serverChannelImplArray;
    }

    private void addLocalServerChannels(ArrayList arrayList) {
        for (ServerChannelImpl serverChannelImpl : arrayList) {
            try {
                this.addLocalServerChannel(serverChannelImpl);
            }
            catch (Exception exception) {
                ServerLogger.logChannelConfigurationFailed((String)serverChannelImpl.getChannelName(), (Exception)exception);
            }
        }
    }

    private synchronized void stopDefaultChannels(boolean bl) {
        try {
            Iterator iterator = ProtocolManager.iterator();
            while (iterator.hasNext()) {
                Protocol protocol = (Protocol)iterator.next();
                if (!protocol.isEnabled() || protocol.isSecure() != bl) continue;
                ServerChannel serverChannel = protocol.getHandler().getDefaultServerChannel();
                if (DEBUG) {
                    ChannelService.p("stopDefaultChannels(" + protocol + ")");
                }
                if (protocol.getHandler().getPriority() < 0 || serverChannel == null) continue;
                ServerChannelImpl[] serverChannelImplArray = this.expandServerChannels(LocalServerIdentity.getIdentity(), (ServerChannelImpl)serverChannel);
                for (int i = 0; i < serverChannelImplArray.length; ++i) {
                    DynamicListenThreadManager.getInstance().stopListener(serverChannelImplArray[i]);
                    this.removeDefaultServerChannel(serverChannelImplArray[i]);
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServerLogger.logProtocolNotConfigured((String)unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            ServerLogger.logProtocolNotConfigured((String)iOException.getMessage());
        }
    }

    private synchronized void startDefaultAdminChannel() {
        if (DEBUG) {
            ChannelService.p("startDefaultAdminChannel()");
        }
        ServerChannelImpl serverChannelImpl = (ServerChannelImpl)ProtocolHandlerAdmin.getProtocolHandler().getDefaultServerChannel();
        try {
            serverChannelImpl.update(LocalServerIdentity.getIdentity());
            this.addLocalServerChannels(serverChannelImpl);
            EnableAdminListenersService.getInstance().start();
        }
        catch (Exception exception) {
            ServerLogger.logChannelConfigurationFailed((String)serverChannelImpl.getChannelName(), (Exception)exception);
        }
        this.resetQOS();
        this.adminChannelCreationTime = System.currentTimeMillis();
    }

    private synchronized void stopDefaultAdminChannel() {
        if (DEBUG) {
            ChannelService.p("stopDefaultAdminChannel()");
        }
        AdminPortService.getInstance().halt();
        ServerChannelImpl serverChannelImpl = (ServerChannelImpl)ProtocolHandlerAdmin.getProtocolHandler().getDefaultServerChannel();
        try {
            ServerChannelImpl[] serverChannelImplArray = this.expandServerChannels(LocalServerIdentity.getIdentity(), serverChannelImpl);
            for (int i = 0; i < serverChannelImplArray.length; ++i) {
                this.removeDefaultServerChannel(serverChannelImplArray[i]);
            }
            serverChannelImpl.update(LocalServerIdentity.getIdentity());
        }
        catch (Exception exception) {
            ServerLogger.logChannelConfigurationFailed((String)serverChannelImpl.getChannelName(), (Exception)exception);
        }
        this.resetQOS();
        this.adminChannelCreationTime = 0L;
    }

    public static Map getLocalServerChannels() {
        return localChannels;
    }

    public static void exportServerChannels(ServerIdentity serverIdentity, ObjectOutput objectOutput) throws IOException {
        ArrayList arrayList = new ArrayList();
        AbstractMap abstractMap = (AbstractMap)channelMap.get(serverIdentity);
        if (abstractMap != null) {
            for (ArrayList arrayList2 : abstractMap.values()) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        objectOutput.writeInt(arrayList.size());
        for (ArrayList arrayList2 : arrayList) {
            objectOutput.writeObject(arrayList2);
            if (!DEBUG) continue;
            ChannelService.p("Exported: " + arrayList2);
        }
    }

    public static boolean hasChannels(ServerIdentity serverIdentity) {
        AbstractMap abstractMap = (AbstractMap)channelMap.get(serverIdentity);
        return abstractMap != null && !abstractMap.isEmpty();
    }

    public static void importServerChannels(ServerIdentity serverIdentity, ObjectInput objectInput) throws IOException {
        if (serverIdentity.isLocal() || LocalServerIdentity.getIdentity().getPersistentIdentity().equals((Object)serverIdentity.getPersistentIdentity())) {
            int n = objectInput.readInt();
            while (n-- > 0) {
                try {
                    objectInput.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ChannelService.importNonLocalServerChannels(serverIdentity, objectInput);
        }
    }

    public static void importNonLocalServerChannels(ServerIdentity serverIdentity, ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(31);
        ConcurrentHashMap concurrentHashMap2 = new ConcurrentHashMap(31);
        for (int i = 0; i < n; ++i) {
            try {
                ChannelService.addServerChannel((ServerChannelImpl)objectInput.readObject(), null, concurrentHashMap, concurrentHashMap2);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (DEBUG) {
            ChannelService.p("Imported: " + serverIdentity + ":\n" + concurrentHashMap.toString());
            ChannelService.p("Imported: " + serverIdentity + ":\n" + concurrentHashMap2.toString());
        }
        channelMap.put(serverIdentity, concurrentHashMap);
        channelsByName.put(serverIdentity, concurrentHashMap2);
        ServerIdentityManager.recordIdentity((ServerIdentity)serverIdentity);
    }

    private void updateConnectedServers() {
        String[] stringArray = URLManager.getConnectedServers();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(AdminServerIdentity.getIdentity().getServerName()) || stringArray[i].equals(LocalServerIdentity.getIdentity().getServerName())) continue;
            try {
                String string = URLManager.findAdministrationURL(stringArray[i]);
                if (string == null) continue;
                Environment environment = new Environment();
                environment.setProviderUrl(string);
                RemoteChannelService remoteChannelService = (RemoteChannelService)PortableRemoteObject.narrow((Object)environment.getInitialReference(RemoteChannelServiceImpl.class), RemoteChannelService.class);
                remoteChannelService.updateServer(LocalServerIdentity.getIdentity().getServerName(), ServerChannelManager.getLocalChannelsForExport());
                continue;
            }
            catch (RemoteException remoteException) {
                ServerLogger.logServerUpdateFailed((String)stringArray[i]);
                continue;
            }
            catch (NamingException namingException) {
                ServerLogger.logServerUpdateFailed((String)stringArray[i]);
            }
        }
    }

    protected ChannelList getLocalChannelList() {
        return new ChannelListImpl();
    }

    public static ArrayList getDiscriminantSet(String string) {
        return (ArrayList)localChannels.get(string);
    }

    public static boolean isLocalChannel(InetAddress inetAddress, int n) {
        boolean bl;
        String string = inetAddress.getHostAddress();
        if (InetAddressHelper.isIPV6Address((String)string)) {
            string = "[" + string + "]";
        }
        boolean bl2 = bl = localChannels.get(inetAddress.getHostName().toLowerCase() + n) != null || localChannels.get(string + n) != null;
        if (!bl && inetAddress.isLoopbackAddress() && !AddressUtils.getLocalHost().isLoopbackAddress()) {
            return ChannelService.isLocalChannel(AddressUtils.getLocalHost(), n);
        }
        if (DEBUG) {
            ChannelService.p("isLocalChannel(" + inetAddress + ", " + n + "): " + bl);
        }
        return bl;
    }

    public static boolean isLocalChannel(String string) {
        try {
            URI uRI = new URI(string);
            return ChannelService.isLocalChannel(InetAddress.getByName(uRI.getHost()), uRI.getPort());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        Object object;
        if (DEBUG) {
            ChannelService.p("prepareUpdate() " + beanUpdateEvent.getSourceBean() + ", event dump:");
            object = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < ((BeanUpdateEvent.PropertyUpdate[])object).length; ++i) {
                ChannelService.p(" " + object[i].getPropertyName());
            }
        }
        object = null;
        if (beanUpdateEvent.getProposedBean() instanceof ServerMBean) {
            object = (BeanUpdateEvent.PropertyUpdate[])beanUpdateEvent.getProposedBean();
        } else if (beanUpdateEvent.getProposedBean() instanceof NetworkAccessPointMBean) {
            object = (ServerMBean)((NetworkAccessPointMBean)beanUpdateEvent.getProposedBean()).getParent();
        } else if (beanUpdateEvent.getProposedBean() instanceof SSLMBean) {
            object = (ServerMBean)((SSLMBean)beanUpdateEvent.getProposedBean()).getParent();
        }
        if (object != null && !ChannelHelper.checkConsistency((ServerMBean)object)) {
            throw new BeanUpdateRejectedException("Inconsistent channel updates");
        }
        if (beanUpdateEvent.getSourceBean() instanceof ServerMBean) {
            ServerMBean serverMBean = (ServerMBean)beanUpdateEvent.getSourceBean();
            ServerMBean serverMBean2 = (ServerMBean)beanUpdateEvent.getProposedBean();
            if (serverMBean.getMaxOpenSockCount() < 0 && serverMBean2.getMaxOpenSockCount() >= 0 || serverMBean.getMaxOpenSockCount() >= 0 && serverMBean2.getMaxOpenSockCount() < 0) {
                throw new BeanUpdateRejectedException("Cannot change MaxOpenSockCount enablement dynamically");
            }
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            NetworkAccessPointMBean networkAccessPointMBean;
            if (!(beanUpdateEvent.getSourceBean() instanceof ServerMBean ? propertyUpdateArray[i].getAddedObject() instanceof NetworkAccessPointMBean && (networkAccessPointMBean = (NetworkAccessPointMBean)propertyUpdateArray[i].getAddedObject()).getProtocol().equalsIgnoreCase("ADMIN") && !ChannelHelper.isLocalAdminChannelEnabled() && !AdminServerIdentity.getIdentity().isLocal() : beanUpdateEvent.getSourceBean() instanceof DomainMBean && propertyUpdateArray[i].getPropertyName().equals("AdministrationPortEnabled") && ((DomainMBean)beanUpdateEvent.getProposedBean()).isAdministrationPortEnabled() != ChannelHelper.isLocalAdminChannelEnabled() && !AdminServerIdentity.getIdentity().isLocal())) continue;
            throw new BeanUpdateRejectedException("Cannot dynamically enable adminstration port on Managed servers when they are running");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (DEBUG) {
            void propertyUpdateArray;
            ChannelService.p("activateUpdate() " + beanUpdateEvent.getSourceBean() + ", event dump:");
            object = beanUpdateEvent.getUpdateList();
            boolean n = false;
            while (propertyUpdateArray < ((BeanUpdateEvent.PropertyUpdate[])object).length) {
                ChannelService.p(" " + object[propertyUpdateArray].getPropertyName());
                ++propertyUpdateArray;
            }
        }
        if (beanUpdateEvent.getSourceBean() instanceof ServerMBean) {
            void var4_8;
            object = beanUpdateEvent.getUpdateList();
            boolean e = false;
            while (var4_8 < ((BeanUpdateEvent.PropertyUpdate[])object).length) {
                Object object2;
                if (object[var4_8].getAddedObject() instanceof NetworkAccessPointMBean) {
                    object2 = (NetworkAccessPointMBean)object[var4_8].getAddedObject();
                    if (DEBUG) {
                        ChannelService.p("adding: " + object2);
                    }
                    object2.addBeanUpdateListener((BeanUpdateListener)this);
                    if (object2.isEnabled()) {
                        hashSet.add(object2);
                    }
                } else if (object[var4_8].getRemovedObject() instanceof NetworkAccessPointMBean) {
                    object2 = (NetworkAccessPointMBean)object[var4_8].getRemovedObject();
                    if (DEBUG) {
                        ChannelService.p("remove: " + object2);
                    }
                    this.removeLocalServerChannel((NetworkAccessPointMBean)object2);
                    hashSet.add(new Object());
                } else {
                    object2 = object[var4_8].getPropertyName();
                    if (((String)object2).equals("KeyStores") || ((String)object2).equals("CustomIdentityKeyStoreFileName") || ((String)object2).equals("CustomIdentityKeyStoreType") || ((String)object2).equals("CustomIdentityKeyStorePassPhrase") || ((String)object2).equals("CustomTrustKeyStoreFileName") || ((String)object2).equals("CustomTrustKeyStoreType") || ((String)object2).equals("CustomTrustKeyStorePassPhrase") || ((String)object2).equals("JavaStandardTrustKeyStorePassPhrase")) {
                        hashSet.add(((ServerMBean)beanUpdateEvent.getSourceBean()).getSSL());
                    } else if (((String)object2).equals("ListenPortEnabled") && !((ServerMBean)beanUpdateEvent.getSourceBean()).isListenPortEnabled()) {
                        this.stopDefaultChannels(false);
                        hashSet.add(new Object());
                    } else if (((String)object2).equals("ListenPortEnabled") || ((String)object2).equals("ListenPort")) {
                        hashSet.add(beanUpdateEvent.getSourceBean());
                    } else if (((String)object2).equals("ListenAddress")) {
                        hashSet.add(beanUpdateEvent.getSourceBean());
                        hashSet.add(((ServerMBean)beanUpdateEvent.getSourceBean()).getSSL());
                    } else if (((String)object2).equals("AdministrationPort")) {
                        hashSet.add(beanUpdateEvent.getSourceBean());
                    } else if (((String)object2).equals("MaxOpenSockCount")) {
                        ServerThrottle.getServerThrottle().changeMaxOpenSockets(((ServerMBean)beanUpdateEvent.getSourceBean()).getMaxOpenSockCount());
                    }
                }
                ++var4_8;
            }
        } else if (beanUpdateEvent.getSourceBean() instanceof NetworkAccessPointMBean) {
            object = (NetworkAccessPointMBean)beanUpdateEvent.getSourceBean();
            if (DEBUG) {
                ChannelService.p("updating: " + object);
            }
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                String string = propertyUpdateArray[i].getPropertyName();
                if (string.equals("Enabled")) {
                    if (!object.isEnabled()) {
                        this.removeLocalServerChannel((NetworkAccessPointMBean)object);
                        hashSet.remove(object);
                    } else {
                        hashSet.add(object);
                    }
                    break;
                }
                if (!string.equals("AcceptBacklog") && !string.equals("HttpEnabledForThisProtocol") && !string.equals("TunnelingEnabled") && !string.equals("OutboundEnabled") && !string.equals("TwoWaySSLEnabled") && !string.equals("PrivateKeyAlias") && !string.equals("PrivateKeyPassPhrase") && !string.equals("ClientCertificateEnforced")) continue;
                hashSet.add(object);
            }
        } else if (beanUpdateEvent.getSourceBean() instanceof SSLMBean) {
            if (!((SSLMBean)beanUpdateEvent.getSourceBean()).isEnabled()) {
                this.stopDefaultChannels(true);
            } else {
                hashSet.add(beanUpdateEvent.getSourceBean());
            }
        } else if (beanUpdateEvent.getSourceBean() instanceof DomainMBean) {
            void var4_11;
            object = beanUpdateEvent.getUpdateList();
            boolean bl = false;
            while (var4_11 < ((Object)object).length) {
                String string = object[var4_11].getPropertyName();
                if (string.equals("AdministrationPortEnabled") || string.equals("AdministrationPort")) {
                    hashSet.add(beanUpdateEvent.getSourceBean());
                }
                ++var4_11;
            }
        }
        if (hashSet.size() > 0) {
            SSLContextManager.clearSSLContextCache();
            for (Object e : hashSet) {
                if (e instanceof NetworkAccessPointMBean) {
                    this.updateLocalServerChannel((NetworkAccessPointMBean)e);
                    continue;
                }
                if (e instanceof ServerMBean) {
                    this.updateDefaultChannels(false);
                    continue;
                }
                if (e instanceof SSLMBean) {
                    this.updateDefaultChannels(true);
                    continue;
                }
                if (!(e instanceof DomainMBean)) continue;
                this.stopDefaultAdminChannel();
                if (!((DomainMBean)e).isAdministrationPortEnabled()) continue;
                this.startDefaultAdminChannel();
            }
            try {
                if (!AdminServerIdentity.getIdentity().isLocal()) {
                    RemoteChannelServiceImpl.getDomainGateway().updateServer(LocalServerIdentity.getIdentity().getServerName(), ServerChannelManager.getLocalChannelsForExport());
                }
            }
            catch (RemoteException remoteException) {
                ServerLogger.logServerUpdateFailed((String)AdminServerIdentity.getIdentity().getServerName());
            }
            if (ClusterService.getServices() != null) {
                ClusterService.getServices().resendLocalAttributes();
            } else {
                this.updateConnectedServers();
            }
        }
    }

    public void restartSSLChannels() {
        SSLContextManager.clearSSLContextCache();
        this.updateDefaultChannels(true);
        NetworkAccessPointMBean[] networkAccessPointMBeanArray = ManagementService.getRuntimeAccess(kernelId).getServer().getNetworkAccessPoints();
        for (int i = 0; i < networkAccessPointMBeanArray.length; ++i) {
            NetworkAccessPointMBean networkAccessPointMBean = networkAccessPointMBeanArray[i];
            byte by = ProtocolManager.getProtocolByName((String)networkAccessPointMBean.getProtocol()).getQOS();
            if (!networkAccessPointMBean.isEnabled() || by != 102 && by != 103) continue;
            this.updateLocalServerChannel(networkAccessPointMBean);
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (DEBUG) {
            ChannelService.p("rollbackUpdate() " + beanUpdateEvent.getSourceBean());
        }
    }

    public static void removeChannelEntries(String string) {
        ChannelService.removeMapEntriesForServer(channelMap, string);
        ChannelService.removeMapEntriesForServer(channelsByName, string);
    }

    private static void removeMapEntriesForServer(ConcurrentHashMap concurrentHashMap, String string) {
        if (concurrentHashMap == null) {
            return;
        }
        Iterator iterator = concurrentHashMap.entrySet().iterator();
        String string2 = LocalServerIdentity.getIdentity().getDomainName();
        while (iterator.hasNext()) {
            ServerIdentity serverIdentity;
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (!(k instanceof ServerIdentity) || !StringUtils.strcmp((String)(serverIdentity = (ServerIdentity)k).getDomainName(), (String)string2) || !StringUtils.strcmp((String)serverIdentity.getServerName(), (String)string)) continue;
            iterator.remove();
        }
    }

    public static void removeChannelEntries(ServerIdentity serverIdentity) {
        channelMap.remove(serverIdentity);
        channelsByName.remove(serverIdentity);
    }

    private static void invalidateChannelEntriesInDomain() {
    }

    private static ServerChannel findOutboundServerChannelInternal(Protocol protocol, String string) throws IOException {
        ArrayList arrayList;
        Debug.assertion((initialized && (protocol != null || string != null) ? 1 : 0) != 0);
        if (string != null && (arrayList = (ArrayList)localChannelsByName.get(string)) != null) {
            for (ServerChannelImpl serverChannelImpl : arrayList) {
                if (!serverChannelImpl.getConfig().isOutboundEnabled() || protocol != null && serverChannelImpl.getProtocol() != protocol) continue;
                return serverChannelImpl;
            }
        }
        if (protocol != null) {
            arrayList = (ArrayList)localChannelsByProtocol.get(protocol);
            if (arrayList != null) {
                for (ServerChannelImpl serverChannelImpl : arrayList) {
                    if (!serverChannelImpl.getConfig().isOutboundEnabled() || serverChannelImpl.isSDPEnabled() || serverChannelImpl.isT3SenderQueueDisabled()) continue;
                    return serverChannelImpl;
                }
                if (protocol == PROTOCOL.ADMIN) {
                    for (ServerChannelImpl serverChannelImpl : arrayList) {
                        if (!serverChannelImpl.getConfig().isOutboundEnabled()) continue;
                        return serverChannelImpl;
                    }
                }
            }
            if (!protocol.isEnabled()) {
                throw new IOException("No configured outbound channel for " + protocol.getProtocolName());
            }
            return protocol.getHandler().getDefaultServerChannel();
        }
        return null;
    }

    static ServerChannel findInboundServerChannel(Protocol protocol, String string) {
        if (!initialized) {
            return null;
        }
        ArrayList arrayList = (ArrayList)localChannelsByProtocol.get(protocol);
        if (arrayList != null) {
            for (ServerChannel serverChannel : arrayList) {
                if (string != null && !serverChannel.getChannelName().equals(string)) continue;
                return serverChannel;
            }
        }
        return null;
    }

    static ServerChannel findInboundServerChannel(Protocol protocol) {
        return ChannelService.findInboundServerChannel(protocol, null);
    }

    public static ArrayList findInboundServerChannels(Protocol protocol) {
        Debug.assertion((boolean)initialized);
        return (ArrayList)localChannelsByProtocol.get(protocol);
    }

    public static ArrayList getInboundServerChannels() {
        Debug.assertion((boolean)initialized);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = localChannelsByProtocol.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((ArrayList)iterator.next());
        }
        return arrayList;
    }

    public static InetSocketAddress findServerAddress(Protocol protocol) {
        ServerChannel serverChannel = ChannelService.findInboundServerChannel(protocol);
        if (serverChannel == null) {
            return null;
        }
        return new InetSocketAddress(serverChannel.getPublicAddress(), serverChannel.getPublicPort());
    }

    public static InetSocketAddress findServerAddress(String string) {
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        return ChannelService.findServerAddress(protocol);
    }

    private static final ServerRuntime getServerRuntime() {
        return (ServerRuntime)ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }

    private static void p(String string) {
        System.out.println("<ChannelService>: " + string);
    }

    public long getAdminChannelCreationTime() {
        return this.adminChannelCreationTime;
    }

    public ServerChannel getServerChannel(HostID hostID) {
        if (hostID != LocalServerIdentity.getIdentity()) {
            throw new AssertionError((Object)("Only local HostID is supported" + hostID));
        }
        return ServerChannelManager.findDefaultLocalServerChannel();
    }

    protected ServerChannel getServerChannel(HostID hostID, Protocol protocol) {
        return this.getServerChannel(hostID, protocol, null);
    }

    protected ServerChannel getIPv4ServerChannel(HostID hostID, Protocol protocol) {
        return this.getServerChannel(hostID, protocol, false);
    }

    protected ServerChannel getIPv6ServerChannel(HostID hostID, Protocol protocol) {
        return this.getServerChannel(hostID, protocol, true);
    }

    private ServerChannel getServerChannel(HostID hostID, Protocol protocol, boolean bl) {
        ArrayList arrayList;
        AbstractMap abstractMap;
        Debug.assertion((hostID != null ? 1 : 0) != 0);
        if (DEBUG_MAP) {
            abstractMap = (ConcurrentHashMap)channelMap.get(hostID);
            ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ") =>\n" + ((ConcurrentHashMap)abstractMap).toString());
        }
        if ((abstractMap = this.findOrCreateChannels((ServerIdentity)hostID)) != null && (arrayList = (ArrayList)abstractMap.get(protocol)) != null) {
            for (ServerChannel serverChannel : arrayList) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(serverChannel.getPublicAddress());
                    if (inetAddress instanceof Inet6Address) {
                        if (!bl) continue;
                        if (DEBUG_MAP) {
                            ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ", ipv6Only) returned " + serverChannel);
                        }
                        return serverChannel;
                    }
                    if (bl) continue;
                    if (DEBUG_MAP) {
                        ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ", ipv4Only) returned " + serverChannel);
                    }
                    return serverChannel;
                }
                catch (UnknownHostException unknownHostException) {
                }
            }
        }
        if (DEBUG_MAP) {
            ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ") returned NULL");
        }
        return null;
    }

    protected ServerChannel getServerChannel(HostID hostID, Protocol protocol, String string) {
        ArrayList arrayList;
        AbstractMap abstractMap;
        Debug.assertion((hostID != null ? 1 : 0) != 0);
        if (DEBUG_MAP) {
            abstractMap = (ConcurrentHashMap)channelMap.get(hostID);
            ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ") =>\n" + ((ConcurrentHashMap)abstractMap).toString());
        }
        if ((abstractMap = this.findOrCreateChannels((ServerIdentity)hostID)) != null && (arrayList = (ArrayList)abstractMap.get(protocol)) != null) {
            for (ServerChannel serverChannel : arrayList) {
                if ((string != null || serverChannel.isSDPEnabled() || serverChannel.isT3SenderQueueDisabled()) && !serverChannel.getChannelName().equals(string)) continue;
                if (DEBUG_MAP) {
                    ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ") returned " + serverChannel);
                }
                return serverChannel;
            }
        }
        if (DEBUG_MAP) {
            ChannelService.p("getServerChannel(" + hostID + ", " + protocol + ") returned NULL");
        }
        return null;
    }

    public ServerChannel getConfiguredServerChannel(ServerMBean serverMBean, Protocol protocol) {
        try {
            Iterator iterator;
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(31);
            this.createServerChannels(serverMBean, null, concurrentHashMap, new ConcurrentHashMap(31));
            ArrayList arrayList = (ArrayList)concurrentHashMap.get(protocol);
            if (arrayList != null && (iterator = arrayList.iterator()).hasNext()) {
                return (ServerChannel)iterator.next();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    protected ServerChannel getServerChannel(HostID hostID, String string) {
        Debug.assertion((hostID != null ? 1 : 0) != 0);
        AbstractMap abstractMap = this.findOrCreateNamedChannels((ServerIdentity)hostID);
        if (abstractMap != null) {
            Iterator iterator;
            ArrayList arrayList = (ArrayList)abstractMap.get(string);
            if (DEBUG_MAP) {
                ChannelService.p("getServerChannel(" + hostID + ", " + string + ") => " + arrayList);
            }
            if (arrayList != null && (iterator = arrayList.iterator()).hasNext()) {
                return (ServerChannel)iterator.next();
            }
        }
        return null;
    }

    protected ServerChannel getAvailableServerChannel(HostID hostID, String string) {
        Debug.assertion((hostID != null ? 1 : 0) != 0);
        AbstractMap abstractMap = this.findNamedChannels((ServerIdentity)hostID);
        if (abstractMap != null) {
            Iterator iterator;
            ArrayList arrayList = (ArrayList)abstractMap.get(string);
            if (DEBUG_MAP) {
                ChannelService.p("getServerChannel(" + hostID + ", " + string + ") => " + arrayList);
            }
            if (arrayList != null && (iterator = arrayList.iterator()).hasNext()) {
                return (ServerChannel)iterator.next();
            }
        }
        return null;
    }

    private AbstractMap findNamedChannels(ServerIdentity serverIdentity) {
        if (serverIdentity.isClient()) {
            return null;
        }
        AbstractMap abstractMap = (AbstractMap)channelsByName.get(serverIdentity);
        return abstractMap;
    }

    protected ServerChannel getRelatedServerChannel(HostID hostID, Protocol protocol, String string) {
        ArrayList arrayList;
        Debug.assertion((boolean)initialized);
        AbstractMap abstractMap = this.findOrCreateChannels((ServerIdentity)hostID);
        if (abstractMap != null && (arrayList = (ArrayList)abstractMap.get(protocol)) != null) {
            for (ServerChannel serverChannel : arrayList) {
                if (!string.equals(serverChannel.getPublicAddress())) continue;
                return serverChannel;
            }
        }
        return null;
    }

    protected ServerChannel getOutboundServerChannel(Protocol protocol, String string) {
        try {
            return ChannelService.findOutboundServerChannelInternal(protocol, string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void dumpTables() {
        System.out.println("Local channels:");
        System.out.println(localChannels.toString());
        System.out.println("Domain channels by protocol:");
        System.out.println(channelMap.toString());
        System.out.println("Domain channels by name:");
        System.out.println(channelsByName.toString());
    }

    static {
        replicationChannelNames = new ArrayList();
    }

    private static class DisconnectListener
    implements weblogic.rmi.extensions.DisconnectListener {
        private DisconnectListener() {
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            if (disconnectEvent instanceof ServerDisconnectEvent) {
                String string = ((ServerDisconnectEvent)disconnectEvent).getServerName();
                ChannelService.removeChannelEntries(string);
            }
        }
    }

    private static class ConnectListener
    implements weblogic.rmi.extensions.ConnectListener {
        private ConnectListener() {
        }

        public void onConnect(ConnectEvent connectEvent) {
        }
    }

    private static final class PROTOCOL {
        private static final Protocol LDAP = ProtocolManager.getProtocolByIndex((int)10);
        private static final Protocol LDAPS = ProtocolManager.getProtocolByIndex((int)11);
        private static final Protocol HTTP = ProtocolManager.getProtocolByIndex((int)1);
        private static final Protocol HTTPS = ProtocolManager.getProtocolByIndex((int)3);
        private static final Protocol ADMIN = ProtocolManager.getProtocolByIndex((int)6);
        private static final Protocol CLUSTER = ProtocolManager.getProtocolByIndex((int)12);
        private static final Protocol CLUSTERS = ProtocolManager.getProtocolByIndex((int)13);
        private static final Protocol SNMP = ProtocolManager.getProtocolByIndex((int)17);

        private PROTOCOL() {
        }
    }
}

