/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.security.AccessController;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannel;
import weblogic.security.SSL.SSLEngineFactory;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLCipherUtility;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLSetup;
import weblogic.server.channels.DynamicListenThread;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.socket.JSSEFilterImpl;
import weblogic.socket.JSSESocket;
import weblogic.socket.MuxableSocket;
import weblogic.socket.MuxableSocketDiscriminator;
import weblogic.socket.SocketMuxer;

final class DynamicJSSEListenThread
extends DynamicListenThread {
    private static final String SSL_LISTEN_THREAD_NAME = "DynamicJSSEListenThread";
    private static final String ADMIN_LISTEN_THREAD_NAME = "AdminJSSEListenThread";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final SSLEngineFactory sslEngineFactory;

    DynamicJSSEListenThread(ServerChannel[] serverChannelArray, DynamicListenThreadManager dynamicListenThreadManager) throws IOException {
        super(serverChannelArray, dynamicListenThreadManager);
        this.port = serverChannelArray[0].getPort();
        try {
            this.sslEngineFactory = SSLContextManager.getSSLEngineFactory(serverChannelArray[0], kernelId);
        }
        catch (Exception exception) {
            T3SrvrLogger.logInconsistentSecurityConfig((Throwable)exception);
            throw (IOException)new IOException(exception.getMessage()).initCause(exception);
        }
        this.loginTimeout = serverChannelArray[0].getLoginTimeoutMillis();
    }

    final String getName() {
        return "DynamicJSSEListenThread[" + this.getChannelName() + "]";
    }

    public void registerSocket(Socket socket) {
        try {
            Object object;
            socket.setSoTimeout(this.loginTimeout);
            WeblogicSSLEngine weblogicSSLEngine = this.sslEngineFactory.createSSLEngine(socket.getInetAddress().getHostAddress(), socket.getPort());
            weblogicSSLEngine.setUseClientMode(false);
            SSLMBean sSLMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getSSL();
            String[] stringArray = sSLMBean.getCiphersuites();
            stringArray = SSLCipherUtility.removeNullCipherSuites(stringArray);
            if (stringArray != null && stringArray.length > 0) {
                weblogicSSLEngine.setEnabledCipherSuites(stringArray);
            }
            if (SSLSetup.isDebugEnabled(3)) {
                object = weblogicSSLEngine.getEnabledCipherSuites();
                SSLSetup.info(this.getName() + " " + ((String[])object).length + " cipher suites enabled:");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    SSLSetup.info(object[i]);
                }
            }
            weblogicSSLEngine.setWantClientAuth(this.channels[0].isTwoWaySSLEnabled());
            if (this.channels[0].isTwoWaySSLEnabled() && this.channels[0].isClientCertificateEnforced()) {
                weblogicSSLEngine.setNeedClientAuth(this.channels[0].isClientCertificateEnforced());
            } else if (!this.channels[0].isTwoWaySSLEnabled() && this.channels[0].isClientCertificateEnforced()) {
                T3SrvrLogger.logInconsistentSSLConfig();
            }
            object = new JSSEFilterImpl(socket, weblogicSSLEngine);
            JSSESocket jSSESocket = new JSSESocket(socket, (JSSEFilterImpl)object);
            MuxableSocketDiscriminator muxableSocketDiscriminator = new MuxableSocketDiscriminator(jSSESocket, this.handlers, this.channels);
            ((JSSEFilterImpl)object).setDelegate(muxableSocketDiscriminator);
            muxableSocketDiscriminator.setSocketFilter((MuxableSocket)object);
            SocketMuxer.getMuxer().register((MuxableSocket)object);
            SocketMuxer.getMuxer().read((MuxableSocket)object);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.rejectCatastrophe(socket, "Login timed out after: '" + this.loginTimeout + "' ms on socket: '" + DynamicJSSEListenThread.socketInfo(socket) + "'", interruptedIOException);
        }
        catch (EOFException eOFException) {
            this.rejectCatastrophe(socket, "Client closed socket '" + DynamicJSSEListenThread.socketInfo(socket) + "' before completing connection.", eOFException);
        }
        catch (IOException iOException) {
            this.rejectCatastrophe(socket, "Unable to read from socket: '" + DynamicJSSEListenThread.socketInfo(socket) + "'", iOException);
        }
    }
}

