/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import weblogic.kernel.KernelStatus;
import weblogic.logging.Loggable;
import weblogic.management.configuration.UnixMachineMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ServerChannel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServerLogger;
import weblogic.server.channels.AdminPortService;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.server.channels.ServerThread;
import weblogic.server.channels.ServerThrottle;
import weblogic.socket.Login;
import weblogic.socket.MuxableSocketDiscriminator;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketOptionException;
import weblogic.t3.srvr.ServerServicesManager;
import weblogic.t3.srvr.SetUIDRendezvous;
import weblogic.t3.srvr.T3Srvr;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.utils.Debug;

public class DynamicListenThread
implements Runnable {
    private static final String LISTEN_THREAD_NAME = "DynamicListenThread";
    private static final byte[] UNAVAIL_RESPONSE = "HTTP/1.0 503 Unavailable\r\nWL-Result: UNAVAIL\r\nContent-Type: text/html\r\n\r\n<TITLE>503 Unavailable</TITLE>The Server is not able to service this request: <b>".getBytes();
    private static final boolean DEBUG = false;
    private final SocketAccepter accepter = new SocketAccepter();
    private final DynamicListenThreadManager manager;
    protected int port;
    protected boolean managed;
    private static final int PRIVILEDGED_PORT_HWM = 1024;
    private InetAddress listenAddress = null;
    private boolean isAdminChannel;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected ProtocolHandler[] handlers;
    protected ServerChannel[] channels;
    private volatile boolean bindingDone = false;
    private volatile boolean bindingFail = false;
    private volatile boolean shutdown = false;
    protected int loginTimeout;
    private static HashMap boundErrorTable = new HashMap();

    protected final InetAddress getListenAddress() {
        return this.listenAddress;
    }

    final boolean isBindingDone() {
        return this.bindingDone;
    }

    final boolean isBindingFail() {
        return this.bindingFail;
    }

    DynamicListenThread(ServerChannel[] serverChannelArray, DynamicListenThreadManager dynamicListenThreadManager) {
        Debug.assertion((serverChannelArray != null && serverChannelArray.length > 0 ? 1 : 0) != 0);
        this.channels = serverChannelArray;
        this.handlers = new ProtocolHandler[serverChannelArray.length];
        for (int i = 0; i < serverChannelArray.length; ++i) {
            this.handlers[i] = serverChannelArray[i].getProtocol().getHandler();
        }
        this.listenAddress = serverChannelArray[0].getInetAddress();
        this.loginTimeout = serverChannelArray[0].getLoginTimeoutMillis();
        this.manager = dynamicListenThreadManager;
        this.port = this.channels[0].getPort();
    }

    public static DynamicListenThread createClientListener(ServerChannel serverChannel) {
        if (KernelStatus.isServer()) {
            throw new IllegalStateException("createClientListener() called in a server");
        }
        DynamicListenThread dynamicListenThread = new DynamicListenThread(new ServerChannel[]{serverChannel}, null);
        dynamicListenThread.start(true, false, false);
        return dynamicListenThread;
    }

    protected ServerSocket newServerSocket(int n) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = this.channels[0].isSDPEnabled() ? ServerSocketMuxer.getMuxer().newSDPServerSocket(this.listenAddress, n, this.channels[0].getAcceptBacklog(), this.isAdminChannel) : ServerSocketMuxer.getMuxer().newServerSocket(this.listenAddress, n, this.channels[0].getAcceptBacklog(), this.isAdminChannel);
        ServerSocket serverSocket2 = serverSocket;
        return serverSocket2;
    }

    String getName() {
        return "DynamicListenThread[" + this.getChannelName() + "]";
    }

    protected String getChannelName() {
        return ((ServerChannelImpl)this.channels[0]).getRealName();
    }

    String getKey() {
        return this.channels[0].getListenerKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId);
        try {
            try {
                this.accepter.open();
                while (true) {
                    Socket socket = this.accepter.accept();
                    if (KernelStatus.isServer() && !this.manager.checkDumpThreads(socket)) continue;
                    if (this.accepter.isSuspended()) {
                        this.rejectSuspendedServer(socket);
                        continue;
                    }
                    this.registerSocket(socket);
                }
            }
            catch (SocketException socketException) {
                this.bindingFail = true;
                if (!this.shutdown) {
                    ServerLogger.logUnableToCreateSocket((String)(this.listenAddress == null ? "IP_ANY" : this.listenAddress.getHostAddress()), (int)this.port, (Exception)socketException, (String)this.getChannelName());
                }
                Object var3_4 = null;
                if (this.shutdown) {
                    ServerLogger.logChannelClosed((String)(this.listenAddress == null ? "IP_ANY" : this.listenAddress.getHostAddress()), (int)this.port, (String)this.getChannelName());
                }
                if (this.accepter.isOpen()) {
                    this.bindingDone = false;
                    this.accepter.close();
                }
                SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
            }
            catch (Throwable throwable) {
                if (!this.shutdown) {
                    ServerLogger.logListenThreadFailure((Throwable)throwable);
                }
                Object var3_5 = null;
                if (this.shutdown) {
                    ServerLogger.logChannelClosed((String)(this.listenAddress == null ? "IP_ANY" : this.listenAddress.getHostAddress()), (int)this.port, (String)this.getChannelName());
                }
                if (this.accepter.isOpen()) {
                    this.bindingDone = false;
                    this.accepter.close();
                }
                SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this.shutdown) {
                ServerLogger.logChannelClosed((String)(this.listenAddress == null ? "IP_ANY" : this.listenAddress.getHostAddress()), (int)this.port, (String)this.getChannelName());
            }
            if (this.accepter.isOpen()) {
                this.bindingDone = false;
                this.accepter.close();
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
            throw throwable;
        }
    }

    public boolean start() {
        return this.start(true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean bl, boolean bl2, boolean bl3) {
        int n;
        ServerThread serverThread;
        this.managed = bl2;
        if (this.manager == null) {
            serverThread = new ServerThread(this, this.getName());
            ((Thread)((Object)serverThread)).setDaemon(true);
            ((Thread)((Object)serverThread)).start();
            ((Thread)((Object)serverThread)).setPriority(9);
        } else {
            serverThread = new ServerThread(this.manager.getThreadGroup(), this, this.getName());
            ((Thread)((Object)serverThread)).setPriority(9);
            ((Thread)((Object)serverThread)).start();
        }
        if (bl2) {
            this.manager.addListener(this);
        }
        int n2 = bl ? 1000 * (KernelStatus.isServer() ? ManagementService.getRuntimeAccess(kernelId).getServer().getListenThreadStartDelaySecs() : 60) : (n = 0);
        while (n > 0 && !this.isBindingDone() && !this.isBindingFail()) {
            try {
                DynamicListenThread dynamicListenThread = this;
                synchronized (dynamicListenThread) {
                    this.wait(100L);
                }
                n -= 100;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (bl && (!this.isBindingDone() || this.isBindingFail())) {
            ServerLogger.logChannelHung((String)(this.listenAddress == null ? "IP_ANY" : this.listenAddress.getHostAddress()), (int)this.port, (String)this.getChannelName());
            return false;
        }
        if (!bl3) {
            this.enable();
        }
        return true;
    }

    boolean enable() {
        return this.accepter.enable();
    }

    protected final void rejectCatastrophe(Socket socket, String string, IOException iOException) {
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getListenThreadDebug()) {
            ServerLogger.logDebugThreadException((String)string, (Exception)iOException);
        }
        try {
            socket.close();
        }
        catch (IOException iOException2) {
            // empty catch block
        }
    }

    protected final void rejectSuspendedServer(Socket socket) {
        ServerServicesManager.StartupSnapshot startupSnapshot = ServerServicesManager.getStartupSnapshot();
        Loggable loggable = ServerLogger.logServerUnavailableLoggable((String)T3Srvr.getT3Srvr().getState(), (String)startupSnapshot.getCurrentServiceName(), (int)startupSnapshot.getCurrentServiceIndex(), (int)ServerServicesManager.getServicesCount(), (String)startupSnapshot.getPreviousServiceName(), (long)startupSnapshot.getPreviousServiceStartupTime());
        try {
            InputStream inputStream = socket.getInputStream();
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            if (n == 71 && n2 == 69 && n3 == 84 || n == 80 && n2 == 79 && n3 == 83 && n4 == 84) {
                socket.getOutputStream().write(UNAVAIL_RESPONSE);
                socket.getOutputStream().write(loggable.getMessage().getBytes());
                socket.getOutputStream().write(Login.UNAVAIL_END);
            } else {
                Login.connectReply((Socket)socket, (int)3, (String)loggable.getMessage());
            }
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loggable.log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.bindingDone = false;
        this.shutdown = true;
        DynamicListenThread dynamicListenThread = this;
        synchronized (dynamicListenThread) {
            this.notifyAll();
        }
        this.accepter.close();
        if (this.managed) {
            this.manager.removeListener(this);
        }
        if (this.isAdminChannel) {
            AdminPortService.getInstance().removeListener(this);
        }
    }

    final void unmanage() {
        this.managed = false;
    }

    public void registerSocket(Socket socket) {
        try {
            socket.setSoTimeout(this.loginTimeout);
            MuxableSocketDiscriminator muxableSocketDiscriminator = new MuxableSocketDiscriminator(socket, this.handlers, this.channels);
            ServerSocketMuxer.getMuxer().register(muxableSocketDiscriminator);
            ServerSocketMuxer.getMuxer().read(muxableSocketDiscriminator);
        }
        catch (IOException iOException) {
            this.rejectCatastrophe(socket, "Can't Read from socket: '" + DynamicListenThread.socketInfo(socket) + "'", iOException);
        }
    }

    protected static final String socketInfo(Socket socket) {
        if (socket == null) {
            return "null";
        }
        InetAddress inetAddress = socket.getInetAddress();
        return socket.toString() + " - address: '" + (inetAddress != null ? inetAddress.getHostAddress() : null) + "', port: '" + socket.getPort() + "', localport: '" + socket.getLocalPort() + "'";
    }

    private static synchronized void checkForMultipleAddressBind(String string) throws UnknownHostException {
        if (string == null || boundErrorTable.get(string) != null) {
            return;
        }
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        if (inetAddressArray.length > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringBuffer.append(inetAddressArray[i].getHostAddress());
                if (i == inetAddressArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            String string2 = stringBuffer.toString();
            ServerLogger.logHostMapsToMultipleAddress((String)string, (String)string2);
        }
        boundErrorTable.put(string, string);
    }

    void setAdminChannel(boolean bl) {
        this.isAdminChannel = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.channels.length; ++i) {
            stringBuffer.append(this.channels[i].toString()).append(", ");
        }
        return stringBuffer.toString();
    }

    private final class SocketAccepter {
        private static final int PER_FAILURE_BACKOFF = 1000;
        private ServerSocket acceptSocket;
        private volatile boolean listening;
        private volatile boolean suspended = true;
        private int failures;
        private long lastFailure;

        private SocketAccepter() {
        }

        private void open() throws IOException {
            String string;
            try {
                try {
                    this.acceptSocket = this.createServerSocket(DynamicListenThread.this.port);
                    DynamicListenThread.this.bindingDone = true;
                }
                catch (IOException iOException) {
                    DynamicListenThread.this.bindingFail = true;
                    throw iOException;
                }
                Object var3_1 = null;
                if (DynamicListenThread.this.managed) {
                    DynamicListenThread.this.manager.waitForBinding();
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (DynamicListenThread.this.managed) {
                    DynamicListenThread.this.manager.waitForBinding();
                }
                throw throwable;
            }
            if (KernelStatus.isServer() && ((string = ManagementService.getRuntimeAccess(kernelId).getServer().getListenAddress()) == null || string.equals(""))) {
                DynamicListenThread.checkForMultipleAddressBind(this.acceptSocket.getInetAddress().getHostName());
            }
            this.listening = true;
            if (!this.suspended) {
                this.enable();
            }
        }

        private boolean isThrottlingEnabled() {
            if (DynamicListenThread.this.isAdminChannel) {
                // empty if block
            }
            return true;
        }

        private boolean isOpen() {
            return this.listening;
        }

        private boolean isSuspended() {
            return this.suspended;
        }

        private synchronized boolean enable() {
            if (!this.suspended) {
                return true;
            }
            if (!DynamicListenThread.this.isBindingDone()) {
                return false;
            }
            this.suspended = false;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < DynamicListenThread.this.channels.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(DynamicListenThread.this.channels[i].getProtocol().getProtocolName());
            }
            if (DynamicListenThread.this.channels[0].isSDPEnabled()) {
                stringBuffer.append(" using SDP for I/O");
            }
            ServerLogger.logChannelOpen((String)(DynamicListenThread.this.listenAddress == null ? "IP_ANY" : DynamicListenThread.this.listenAddress.getHostAddress()), (int)DynamicListenThread.this.port, (String)DynamicListenThread.this.getChannelName(), (String)stringBuffer.toString());
            this.notifyAll();
            return true;
        }

        private void close() {
            if (this.acceptSocket != null) {
                try {
                    this.suspended = true;
                    this.listening = false;
                    this.acceptSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private Socket accept() throws IOException {
            boolean bl = false;
            while (true) {
                try {
                    if (this.acceptSocket == null) {
                        ServerLogger.logChannelReopening((String)(DynamicListenThread.this.listenAddress == null ? "IP_ANY" : DynamicListenThread.this.listenAddress.getHostAddress()), (int)DynamicListenThread.this.port, (String)DynamicListenThread.this.getChannelName());
                        this.acceptSocket = this.createServerSocket(DynamicListenThread.this.port);
                        if (bl) {
                            this.suspended = false;
                            bl = false;
                            this.listening = true;
                        }
                    }
                    if (this.isThrottlingEnabled()) {
                        ServerThrottle.getServerThrottle().acquireSocketPermit();
                    }
                    Socket socket = this.acceptSocket.accept();
                    this.onAccept();
                    return socket;
                }
                catch (SocketOptionException socketOptionException) {
                    continue;
                }
                catch (ProtocolException protocolException) {
                    continue;
                }
                catch (IOException iOException) {
                    if (!this.listening) {
                        throw iOException;
                    }
                    bl = this.onAcceptException(iOException);
                    continue;
                }
                break;
            }
        }

        private ServerSocket createServerSocket(final int n) throws IOException {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    try {
                        SocketAccepter.this.acceptSocket = DynamicListenThread.this.newServerSocket(n);
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                    return null;
                }
            };
            IOException iOException = null;
            iOException = KernelStatus.isServer() && n <= 1024 ? (IOException)SetUIDRendezvous.doPrivileged(privilegedAction) : (IOException)privilegedAction.run();
            if (iOException != null) {
                throw iOException;
            }
            return this.acceptSocket;
        }

        private void onAccept() {
            if (this.failures > 0) {
                this.failures = 0;
                ServerLogger.logChannelRestored((String)(DynamicListenThread.this.listenAddress == null ? "IP_ANY" : DynamicListenThread.this.listenAddress.getHostAddress()), (int)DynamicListenThread.this.port, (String)DynamicListenThread.this.getChannelName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onAcceptException(IOException iOException) {
            boolean bl = false;
            long l = TimeEventGenerator.getCurrentMillis();
            if (this.failures == 0) {
                this.lastFailure = l;
            }
            long l2 = l - this.lastFailure;
            ++this.failures;
            ServerLogger.logChannelFailed((String)(DynamicListenThread.this.listenAddress == null ? "IP_ANY" : DynamicListenThread.this.listenAddress.getHostAddress()), (int)DynamicListenThread.this.port, (String)DynamicListenThread.this.getChannelName(), (int)this.failures, (long)(l2 / 1000L), (Exception)iOException);
            int n = 1000 * this.failures;
            if (n < DynamicListenThread.this.channels[0].getMaxBackoffBetweenFailures()) {
                try {
                    SocketAccepter socketAccepter = this;
                    synchronized (socketAccepter) {
                        this.wait(n);
                    }
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Object object;
                boolean bl2 = false;
                if (DynamicListenThread.this.port > 0 && DynamicListenThread.this.port < 1024 && ManagementService.getRuntimeAccess(kernelId).getServer().getMachine() instanceof UnixMachineMBean) {
                    object = (UnixMachineMBean)ManagementService.getRuntimeAccess(kernelId).getServer().getMachine();
                    boolean bl3 = bl2 = object.isPostBindGIDEnabled() || object.isPostBindUIDEnabled();
                }
                if (!bl2) {
                    ServerLogger.logCloseAndReopenChannel((String)(DynamicListenThread.this.listenAddress == null ? "IP_ANY" : DynamicListenThread.this.listenAddress.getHostAddress()), (int)DynamicListenThread.this.port, (String)DynamicListenThread.this.getChannelName());
                    this.close();
                    this.acceptSocket = null;
                    bl = true;
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.wait(DynamicListenThread.this.channels[0].getMaxBackoffBetweenFailures());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return bl;
        }
    }
}

