/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CyclicBarrier;
import weblogic.management.provider.ManagementService;
import weblogic.platform.VM;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLSetup;
import weblogic.server.AbstractServerService;
import weblogic.server.ServerLogger;
import weblogic.server.ServiceFailureException;
import weblogic.server.channels.ChannelService;
import weblogic.server.channels.DynamicJSSEListenThread;
import weblogic.server.channels.DynamicListenThread;
import weblogic.server.channels.DynamicSSLListenThread;
import weblogic.server.channels.ServerChannelImpl;

public final class DynamicListenThreadManager
extends AbstractServerService {
    private boolean magicThreadDumpsOn;
    private InetAddress magicAddress;
    private InetAddress localhost;
    private final HashMap licensedAddresses = new HashMap();
    private CyclicBarrier barrier;
    private final HashMap listeners = new HashMap();
    private boolean isJSSEEnabled = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final ThreadGroup tg = new ThreadGroup("WebLogicServer");
    private boolean initialBinding = false;

    private DynamicListenThreadManager() {
        this.isJSSEEnabled = SSLSetup.isJSSEEnabled();
    }

    public static final DynamicListenThreadManager getInstance() {
        return SingletonMaker.singleton;
    }

    final ThreadGroup getThreadGroup() {
        return this.tg;
    }

    private final synchronized void notifyWaiters() {
        this.initialBinding = true;
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitForBinding() {
        block9: {
            try {
                if (!this.initialBinding) {
                    this.barrier.await();
                }
            }
            catch (Exception exception) {
                if (this.initialBinding) break block9;
                DynamicListenThreadManager dynamicListenThreadManager = this;
                synchronized (dynamicListenThreadManager) {
                    while (!this.initialBinding) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    private synchronized void pause(int n) throws InterruptedException {
        ((Object)((Object)this)).wait(n);
    }

    /*
     * WARNING - void declaration
     */
    public void start() throws ServiceFailureException {
        this.initialize();
        ArrayList<DynamicListenThread> arrayList = new ArrayList<DynamicListenThread>();
        block6: for (ArrayList object : ChannelService.getLocalServerChannels().values()) {
            for (ServerChannelImpl serverChannelImpl : object) {
                if (serverChannelImpl.isImplicitChannel() || serverChannelImpl.getProtocol() == ProtocolHandlerAdmin.PROTOCOL_ADMIN) continue;
                try {
                    DynamicListenThread dynamicListenThread = this.createListener(object);
                    arrayList.add(dynamicListenThread);
                }
                catch (IOException iOException) {
                    SecurityLogger.logNotListeningForSSLInfo((String)iOException.toString());
                }
                continue block6;
            }
        }
        this.barrier = new CyclicBarrier(arrayList.size() + 1);
        for (DynamicListenThread dynamicListenThread : arrayList) {
            dynamicListenThread.start(false, true, true);
        }
        try {
            this.barrier.await();
        }
        catch (Exception exception) {
            void var3_9;
            int n = 1000 * ManagementService.getRuntimeAccess(kernelId).getServer().getListenThreadStartDelaySecs();
            block9: while (var3_9 > 0) {
                for (DynamicListenThread dynamicListenThread : arrayList) {
                    if (dynamicListenThread.isBindingDone() || dynamicListenThread.isBindingFail()) continue;
                    try {
                        this.pause(100);
                        var3_9 -= 100;
                    }
                    catch (InterruptedException interruptedException) {}
                    continue block9;
                }
            }
        }
        int n = 0;
        for (DynamicListenThread dynamicListenThread : arrayList) {
            if (!dynamicListenThread.isBindingDone() || dynamicListenThread.isBindingFail()) continue;
            ++n;
        }
        if (n == 0 && !ChannelHelper.isLocalAdminChannelEnabled()) {
            SecurityLogger.logNotInitOnAnyPortInfo();
            throw new ServiceFailureException("Server failed to bind to any usable port. See preceeding log message for details.");
        }
        if (n < arrayList.size()) {
            ServerLogger.logListenPortsNotOpenTotally();
        }
        this.notifyWaiters();
        ServerLogger.logDynamicListenersEnabled();
    }

    private void initialize() {
        this.magicThreadDumpsOn = ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().isMagicThreadDumpEnabled();
        if (this.magicThreadDumpsOn) {
            try {
                String string = ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getMagicThreadDumpHost();
                this.magicAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                this.magicThreadDumpsOn = false;
            }
        }
        try {
            this.localhost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    final boolean checkDumpThreads(Socket socket) {
        if (this.magicThreadDumpsOn && socket.getInetAddress().equals(this.magicAddress)) {
            DynamicListenThreadManager.dumpThreads(socket);
            if (ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getMagicThreadDumpBackToSocket()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    ServerLogger.logDebugThreadException((String)"Problem dumping threads back to socket", (Exception)iOException);
                }
                return false;
            }
        }
        return true;
    }

    private static void dumpThreads(Socket socket) {
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getMagicThreadDumpBackToSocket()) {
            ServerLogger.logDebugThread((String)("Dumping threads to " + socket));
            try {
                OutputStream outputStream = socket.getOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                PrintWriter printWriter = new PrintWriter(bufferedWriter);
                VM.getVM().threadDump(printWriter);
                printWriter.flush();
            }
            catch (IOException iOException) {
                ServerLogger.logDebugThreadException((String)"Problem dumping threads back to socket", (Exception)iOException);
            }
        }
    }

    public DynamicListenThread createListener(ArrayList arrayList) throws IOException {
        Collections.sort(arrayList);
        ServerChannel[] serverChannelArray = arrayList.toArray(new ServerChannel[0]);
        if (!serverChannelArray[0].supportsTLS()) {
            return new DynamicListenThread(serverChannelArray, this);
        }
        if (this.isJSSEEnabled) {
            return new DynamicJSSEListenThread(serverChannelArray, this);
        }
        return new DynamicSSLListenThread(serverChannelArray, this);
    }

    public void stop() {
        this.stopListeners(this.listeners);
        this.initialBinding = false;
    }

    private static synchronized boolean isScaleLimitedLicenseEnabled() {
        return true;
    }

    private boolean checkConcurrentClients(int n) {
        return true;
    }

    public void halt() throws ServiceFailureException {
    }

    public void enableListeners() {
        this.enableListeners(this.listeners);
    }

    void enableListeners(HashMap hashMap) {
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            DynamicListenThread dynamicListenThread = (DynamicListenThread)iterator.next();
            if (dynamicListenThread.enable()) continue;
            iterator.remove();
        }
    }

    void addListener(DynamicListenThread dynamicListenThread) {
        this.listeners.put(dynamicListenThread.getKey(), dynamicListenThread);
    }

    void removeListener(DynamicListenThread dynamicListenThread) {
        this.listeners.remove(dynamicListenThread.getKey());
    }

    DynamicListenThread findListener(ServerChannel serverChannel) {
        return (DynamicListenThread)this.listeners.get(serverChannel.getListenerKey());
    }

    DynamicListenThread restartListener(ServerChannel serverChannel, HashMap hashMap, boolean bl) throws IOException {
        ArrayList arrayList;
        DynamicListenThread dynamicListenThread = (DynamicListenThread)hashMap.remove(serverChannel.getListenerKey());
        if (dynamicListenThread != null) {
            dynamicListenThread.stop();
        }
        if ((arrayList = ChannelService.getDiscriminantSet(serverChannel.getListenerKey())) != null && !arrayList.isEmpty()) {
            dynamicListenThread = this.createListener(arrayList);
            dynamicListenThread.setAdminChannel(bl);
            hashMap.put(serverChannel.getListenerKey(), dynamicListenThread);
            dynamicListenThread.start(true, !bl, false);
        } else {
            dynamicListenThread = null;
        }
        return dynamicListenThread;
    }

    DynamicListenThread restartListener(ServerChannel serverChannel) throws IOException {
        return this.restartListener(serverChannel, this.listeners, false);
    }

    DynamicListenThread stopListener(ServerChannel serverChannel, HashMap hashMap) {
        DynamicListenThread dynamicListenThread = (DynamicListenThread)hashMap.remove(serverChannel.getListenerKey());
        if (dynamicListenThread != null) {
            dynamicListenThread.stop();
        }
        return dynamicListenThread;
    }

    DynamicListenThread stopListener(ServerChannel serverChannel) {
        return this.stopListener(serverChannel, this.listeners);
    }

    void stopListeners(HashMap hashMap) {
        for (DynamicListenThread dynamicListenThread : hashMap.values()) {
            dynamicListenThread.unmanage();
            dynamicListenThread.setAdminChannel(false);
            dynamicListenThread.stop();
        }
        hashMap.clear();
    }

    private static class SingletonMaker {
        private static final DynamicListenThreadManager singleton = new DynamicListenThreadManager();

        private SingletonMaker() {
        }
    }
}

