/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLCipherUtility;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.security.utils.SSLSetup;
import weblogic.server.channels.DynamicListenThread;
import weblogic.server.channels.DynamicListenThreadManager;
import weblogic.socket.MuxableSocketDiscriminator;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketMuxer;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

final class DynamicSSLListenThread
extends DynamicListenThread {
    private static final String SSL_LISTEN_THREAD_NAME = "DynamicSSLListenThread";
    private static final String ADMIN_LISTEN_THREAD_NAME = "AdminListenThread";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private SSLServerSocketFactory serverFactory = null;

    DynamicSSLListenThread(ServerChannel[] serverChannelArray, DynamicListenThreadManager dynamicListenThreadManager) throws IOException {
        super(serverChannelArray, dynamicListenThreadManager);
        this.port = serverChannelArray[0].getPort();
        try {
            this.serverFactory = SocketMuxer.getMuxer().isAsyncMuxer() ? SSLContextManager.getSSLNioServerSocketFactory(serverChannelArray[0], kernelId) : SSLContextManager.getSSLServerSocketFactory(serverChannelArray[0], kernelId);
        }
        catch (Exception exception) {
            T3SrvrLogger.logInconsistentSecurityConfig((Throwable)exception);
            throw (IOException)new IOException(exception.getMessage()).initCause(exception);
        }
        this.loginTimeout = serverChannelArray[0].getLoginTimeoutMillis();
    }

    final String getName() {
        return "DynamicSSLListenThread[" + this.getChannelName() + "]";
    }

    protected ServerSocket newServerSocket(int n) throws IOException {
        int n2 = ManagementService.getRuntimeAccess(kernelId).getServer().getAcceptBacklog();
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.serverFactory.createServerSocket(n, n2, this.getListenAddress());
        SSLMBean sSLMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getSSL();
        String[] stringArray = sSLMBean.getCiphersuites();
        SSLCipherUtility.normalizeNames(stringArray);
        stringArray = SSLCipherUtility.removeNullCipherSuites(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            sSLServerSocket.setEnabledCipherSuites(stringArray);
        }
        if (SSLSetup.isDebugEnabled(3)) {
            String[] stringArray2 = sSLServerSocket.getEnabledCipherSuites();
            SSLSetup.info(this.getName() + " " + stringArray2.length + " cipher suites enabled:");
            for (int i = 0; i < stringArray2.length; ++i) {
                SSLSetup.info(stringArray2[i]);
            }
        }
        sSLServerSocket.setNeedClientAuth(this.channels[0].isTwoWaySSLEnabled() || this.channels[0].isClientCertificateEnforced());
        return sSLServerSocket;
    }

    public void registerSocket(Socket socket) {
        SSLIOContextTable.registerForThrottling((SSLSocket)socket);
        final SSLSocket sSLSocket = (SSLSocket)socket;
        final long l = this.loginTimeout;
        WorkAdapter workAdapter = new WorkAdapter(){
            final SSLSocket theSock;
            final long timeout;
            {
                this.theSock = sSLSocket;
                this.timeout = l;
            }

            public void run() {
                try {
                    this.theSock.setSoTimeout(DynamicSSLListenThread.this.loginTimeout);
                    MuxableSocketDiscriminator muxableSocketDiscriminator = new MuxableSocketDiscriminator(this.theSock, DynamicSSLListenThread.this.handlers, DynamicSSLListenThread.this.channels);
                    sSLSocket.startHandshake();
                    SSLIOContext sSLIOContext = SSLIOContextTable.findContext(this.theSock);
                    SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
                    sSLFilter.setDelegate(muxableSocketDiscriminator);
                    sSLFilter.activateNoRegister();
                    muxableSocketDiscriminator.setSocketFilter(sSLFilter);
                    SocketMuxer.getMuxer().register(sSLFilter);
                    SocketMuxer.getMuxer().read(sSLFilter);
                }
                catch (InterruptedIOException interruptedIOException) {
                    DynamicSSLListenThread.this.rejectCatastrophe(sSLSocket, "Login timed out after: '" + this.timeout + "' ms on socket: '" + DynamicListenThread.socketInfo(sSLSocket) + "'", interruptedIOException);
                }
                catch (EOFException eOFException) {
                    DynamicSSLListenThread.this.rejectCatastrophe(sSLSocket, "Client closed socket '" + DynamicListenThread.socketInfo(sSLSocket) + "' before completing connection.", eOFException);
                }
                catch (IOException iOException) {
                    DynamicSSLListenThread.this.rejectCatastrophe(sSLSocket, "Unable to read from socket: '" + DynamicListenThread.socketInfo(sSLSocket) + "'", iOException);
                }
            }
        };
        if (ChannelHelper.isAdminChannel((ServerChannel)this.channels[0])) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)workAdapter);
        } else {
            WorkManagerFactory.getInstance().getDefault().schedule((Runnable)workAdapter);
        }
    }
}

