/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import weblogic.jndi.Environment;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ChannelList;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.extensions.ConnectEvent;
import weblogic.rmi.extensions.ConnectListener;
import weblogic.rmi.extensions.ConnectMonitor;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.ServerDisconnectEvent;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLogger;
import weblogic.server.channels.ChannelListImpl;
import weblogic.server.channels.ChannelService;
import weblogic.server.channels.RemoteChannelService;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteChannelServiceImpl
implements RemoteChannelService,
ConnectMonitor {
    private static HashSet connectListeners = new HashSet();
    private static final boolean DEBUG = false;
    private static RemoteChannelService domainGateway;
    private static boolean shutdown;
    private static volatile int registeringNewServer;
    private static HashMap connectedServers;
    private static final AuthenticatedSubject kernelId;

    private RemoteChannelServiceImpl() {
    }

    public static synchronized RemoteChannelService getDomainGateway() {
        return domainGateway;
    }

    public static ConnectMonitor getInstance() {
        if (!KernelStatus.isServer()) {
            throw new UnsupportedOperationException("ConnectMonitor not supported in a client");
        }
        return ConnectSingleton.SINGLETON;
    }

    public static synchronized void unregister() {
        shutdown = true;
    }

    private static synchronized boolean isShutdown() {
        return shutdown;
    }

    public static void registerForever(Environment environment) throws NamingException {
        ArrayList<Environment> arrayList = new ArrayList<Environment>();
        arrayList.add(environment);
        RemoteChannelServiceImpl.registerForever(arrayList);
    }

    public static void registerForever(final List<Environment> list) throws NamingException {
        RemoteChannelServiceImpl.registerInternal(list, new DisconnectListener(){

            public void onDisconnect(DisconnectEvent disconnectEvent) {
                if (disconnectEvent instanceof ServerDisconnectEvent) {
                    ServerLogger.logServerDisconnect((String)((ServerDisconnectEvent)disconnectEvent).getServerName());
                }
                TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new TimerListenerImpl(list, this), (long)(ManagementService.getRuntimeAccess(kernelId).getServer().getAdminReconnectIntervalSeconds() * 1000));
            }
        });
    }

    private static synchronized void registerInternal(List<Environment> list, DisconnectListener disconnectListener) throws NamingException {
        NamingException namingException = null;
        for (Environment environment : list) {
            try {
                RemoteChannelService remoteChannelService = (RemoteChannelService)PortableRemoteObject.narrow((Object)environment.getInitialReference(RemoteChannelServiceImpl.class), RemoteChannelService.class);
                if (remoteChannelService == ConnectSingleton.SINGLETON) {
                    throw new ConfigurationException("Cannot register for disconnect events on local server");
                }
                remoteChannelService.getAdministrationURL();
                String string = remoteChannelService.registerServer(LocalServerIdentity.getIdentity().getServerName(), ServerChannelManager.getLocalChannelsForExport());
                ConnectSingleton.SINGLETON.invokeListeners(string, null);
                ServerLogger.logServerConnect((String)string);
                domainGateway = remoteChannelService;
                try {
                    DisconnectMonitorListImpl.getDisconnectMonitor().addDisconnectListener((Remote)remoteChannelService, disconnectListener);
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)exception);
                }
                return;
            }
            catch (ConfigurationException configurationException) {
                namingException = configurationException;
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                namingException = serviceUnavailableException;
            }
            catch (NamingException namingException2) {
            }
            catch (RemoteException remoteException) {
            }
        }
        if (namingException != null) {
            throw namingException;
        }
        disconnectListener.onDisconnect(null);
    }

    public static void retrieveRemoteChannels(ServerIdentity serverIdentity) throws RemoteException {
        if (RemoteChannelServiceImpl.getDomainGateway() != null && serverIdentity.getDomainName().equals(LocalServerIdentity.getIdentity().getDomainName())) {
            RemoteChannelServiceImpl.getDomainGateway().getChannelList(serverIdentity);
        }
    }

    @Override
    public ServerChannel getServerChannel(String string) {
        return ChannelService.findLocalServerChannel((String)string);
    }

    @Override
    public String getDefaultURL() {
        return ChannelHelper.getDefaultURL();
    }

    @Override
    public String getAdministrationURL() {
        return ChannelHelper.getLocalAdministrationURL();
    }

    @Override
    public String getURL(String string) {
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        return ChannelHelper.getURL(protocol);
    }

    @Override
    public ServerIdentity getServerIdentity() {
        return LocalServerIdentity.getIdentity();
    }

    @Override
    public synchronized String registerServer(String string, ChannelList channelList) {
        ++registeringNewServer;
        ServerLogger.logServerConnect((String)string);
        this.invokeListeners(string, channelList);
        connectedServers.put(string, channelList);
        return this.getServerIdentity().getServerName();
    }

    @Override
    public void updateServer(String string, ChannelList channelList) {
    }

    private void invokeListeners(final String string, final ChannelList channelList) {
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter(){
            private final long time = System.currentTimeMillis();
            private final String serverName = channelList != null ? channelList.getIdentity().getServerName() : string;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HashSet hashSet = null;
                    HashSet hashSet2 = connectListeners;
                    synchronized (hashSet2) {
                        hashSet = (HashSet)connectListeners.clone();
                    }
                    if (hashSet != null) {
                        for (ConnectListener connectListener : hashSet) {
                            connectListener.onConnect(new ConnectEvent(){

                                public String getServerName() {
                                    return serverName;
                                }

                                public long getTime() {
                                    return time;
                                }
                            });
                            if (channelList == null || !(connectListener instanceof DisconnectListener)) continue;
                            try {
                                DisconnectMonitorListImpl.getDisconnectMonitor().addDisconnectListener((Remote)((ChannelListImpl)channelList).getChannelService(), (DisconnectListener)connectListener);
                            }
                            catch (Exception exception) {
                                ServerLogger.logDisconnectRegistrationFailed((Exception)exception);
                            }
                        }
                        if (channelList != null) {
                            try {
                                DisconnectMonitorListImpl.getDisconnectMonitor().addDisconnectListener((Remote)((ChannelListImpl)channelList).getChannelService(), new DisconnectListener(){

                                    public void onDisconnect(DisconnectEvent disconnectEvent) {
                                        if (disconnectEvent instanceof ServerDisconnectEvent) {
                                            ServerLogger.logServerDisconnect((String)((ServerDisconnectEvent)disconnectEvent).getServerName());
                                        } else {
                                            ServerLogger.logServerDisconnect((String)"<unknown>");
                                        }
                                    }
                                });
                            }
                            catch (Exception exception) {
                                ServerLogger.logDisconnectRegistrationFailed((Exception)exception);
                            }
                        }
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    registeringNewServer--;
                    throw throwable;
                }
                registeringNewServer--;
            }
        });
    }

    @Override
    public ChannelList getChannelList(ServerIdentity serverIdentity) {
        return new ChannelListImpl(serverIdentity);
    }

    @Override
    public void removeChannelList(ServerIdentity serverIdentity) {
        ChannelService.removeChannelEntries(serverIdentity);
    }

    @Override
    public String[] getConnectedServers() {
        return URLManager.getConnectedServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectListener(ConnectListener connectListener) {
        HashSet hashSet = connectListeners;
        synchronized (hashSet) {
            connectListeners.add(connectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectListener(ConnectListener connectListener) {
        HashSet hashSet = connectListeners;
        synchronized (hashSet) {
            connectListeners.remove(connectListener);
        }
    }

    public synchronized void addConnectDisconnectListener(ConnectListener connectListener, DisconnectListener disconnectListener) {
        while (registeringNewServer != 0) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.addConnectListener(new ConnectDisconnectListener(connectListener, disconnectListener));
        Iterator iterator = connectedServers.keySet().iterator();
        Iterator iterator2 = connectedServers.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ChannelListImpl channelListImpl = (ChannelListImpl)iterator2.next();
            if (!URLManager.isConnected(string)) continue;
            try {
                DisconnectMonitorListImpl.getDisconnectMonitor().addDisconnectListener((Remote)channelListImpl.getChannelService(), disconnectListener);
            }
            catch (Exception exception) {
                ServerLogger.logDisconnectRegistrationFailed((Exception)exception);
            }
        }
    }

    private static final void p(String string) {
        System.out.println("<RemoteChannelServiceImpl>: " + string);
    }

    static {
        shutdown = false;
        registeringNewServer = 0;
        connectedServers = new HashMap();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static class ConnectDisconnectListener
    implements ConnectListener,
    DisconnectListener {
        private ConnectListener conlisten;
        private DisconnectListener dislisten;

        private ConnectDisconnectListener(ConnectListener connectListener, DisconnectListener disconnectListener) {
            this.conlisten = connectListener;
            this.dislisten = disconnectListener;
        }

        public int hashCode() {
            return this.conlisten.hashCode();
        }

        public boolean equals(Object object) {
            try {
                return ((ConnectDisconnectListener)object).conlisten == this.conlisten && ((ConnectDisconnectListener)object).dislisten == this.dislisten;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public void onConnect(ConnectEvent connectEvent) {
            String string = connectEvent.getServerName();
            this.conlisten.onConnect(connectEvent);
        }

        public void onDisconnect(DisconnectEvent disconnectEvent) {
            RemoteChannelServiceImpl.getInstance().addConnectListener((ConnectListener)this);
            this.dislisten.onDisconnect(disconnectEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimerListenerImpl
    implements TimerListener {
        private DisconnectListener listener;
        private List<Environment> envList;

        private TimerListenerImpl(List<Environment> list, DisconnectListener disconnectListener) {
            this.listener = disconnectListener;
            this.envList = list;
        }

        public void timerExpired(Timer timer) {
            if (RemoteChannelServiceImpl.isShutdown()) {
                return;
            }
            try {
                RemoteChannelServiceImpl.registerInternal(this.envList, this.listener);
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)namingException);
            }
        }
    }

    private static class ConnectSingleton {
        private static final RemoteChannelServiceImpl SINGLETON = new RemoteChannelServiceImpl();

        private ConnectSingleton() {
        }
    }
}

