/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.NetworkAccessPointMBeanStub;
import weblogic.management.ManagementException;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerChannelRuntimeMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.UnknownProtocolException;
import weblogic.protocol.configuration.NetworkAccessPointDefaultMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.channels.BasicServerChannelImpl;
import weblogic.server.channels.ServerChannelRuntimeMBeanImpl;
import weblogic.utils.Debug;

public final class ServerChannelImpl
extends BasicServerChannelImpl {
    static final long serialVersionUID = 3682806476156685669L;
    private static final boolean DEBUG = false;
    private transient ServerChannelRuntimeMBean runtime;

    public ServerChannelImpl() {
    }

    public ServerChannelRuntimeMBean getRuntime() {
        return this.runtime;
    }

    final synchronized ServerChannelRuntimeMBean createRuntime() throws ManagementException {
        Debug.assertion((this.runtime == null ? 1 : 0) != 0);
        this.runtime = new ServerChannelRuntimeMBeanImpl(this);
        return this.runtime;
    }

    final ServerChannelRuntimeMBean deleteRuntime() {
        Debug.assertion((this.runtime != null ? 1 : 0) != 0);
        ServerChannelRuntimeMBeanImpl serverChannelRuntimeMBeanImpl = (ServerChannelRuntimeMBeanImpl)this.runtime;
        this.runtime = null;
        try {
            serverChannelRuntimeMBeanImpl.unregister();
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        return serverChannelRuntimeMBeanImpl;
    }

    ServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, ServerIdentity serverIdentity) throws UnknownHostException, UnknownProtocolException {
        this(networkAccessPointMBean, ProtocolManager.findProtocol((String)networkAccessPointMBean.getProtocol()), networkAccessPointMBean.getName(), serverIdentity, null);
    }

    public ServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, Protocol protocol, ServerIdentity serverIdentity) throws UnknownHostException {
        this(networkAccessPointMBean, protocol, ServerChannelImpl.encodeName(protocol, networkAccessPointMBean.getName()), serverIdentity, null);
        this.displayName = networkAccessPointMBean.getName();
    }

    private ServerChannelImpl(NetworkAccessPointMBean networkAccessPointMBean, Protocol protocol, String string, ServerIdentity serverIdentity, String string2) throws UnknownHostException {
        super(networkAccessPointMBean, protocol, string, serverIdentity, string2);
    }

    ServerChannelImpl(ServerChannelImpl serverChannelImpl, String string, String string2) throws UnknownHostException {
        this.flags = serverChannelImpl.flags;
        this.channelName = serverChannelImpl.channelName + string2;
        if (serverChannelImpl.displayName != null) {
            this.displayName = serverChannelImpl.displayName + string2;
        }
        this.listenPort = serverChannelImpl.listenPort;
        this.publicPort = serverChannelImpl.publicPort;
        this.protocol = serverChannelImpl.protocol;
        this.priority = serverChannelImpl.priority;
        this.weight = serverChannelImpl.weight;
        this.config = serverChannelImpl.config;
        this.implicitChannel = serverChannelImpl.implicitChannel;
        this.isLocal = serverChannelImpl.isLocal;
        if (serverChannelImpl.hasPublicAddress()) {
            this.setPublicAddress(serverChannelImpl.publicAddress);
        }
        this.inetAddress = InetAddress.getByName(string);
        if (string.indexOf(":") != -1) {
            string = "[" + this.inetAddress.getHostAddress() + "]";
        }
        this.setListenAddress(string);
        byte[] byArray = this.inetAddress.getAddress();
        this.rawAddress = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + ((byArray[3] & 0xFF) << 0);
        if (this.getPublicPort() >= 0) {
            this.inSockAddress = new InetSocketAddress(this.getPublicAddress(), this.getPublicPort());
        }
    }

    public ServerChannelImpl createImplicitChannel(Protocol protocol) {
        return new ServerChannelImpl(this, protocol);
    }

    ServerChannelImpl cloneChannel(String string) {
        ServerChannelImpl serverChannelImpl = new ServerChannelImpl(this, this.protocol);
        serverChannelImpl.implicitChannel = false;
        serverChannelImpl.channelName = this.channelName + "{" + string + "}";
        String string2 = this.displayName != null ? this.displayName : this.channelName;
        serverChannelImpl.displayName = string2 + "{" + string + "}";
        return serverChannelImpl;
    }

    private ServerChannelImpl(ServerChannelImpl serverChannelImpl, Protocol protocol) {
        this.flags = serverChannelImpl.flags;
        this.displayName = serverChannelImpl.displayName;
        this.listenPort = serverChannelImpl.listenPort;
        this.publicPort = serverChannelImpl.publicPort;
        this.weight = serverChannelImpl.weight;
        this.config = serverChannelImpl.config;
        this.publicAddress = serverChannelImpl.publicAddress;
        this.address = serverChannelImpl.address;
        this.inetAddress = serverChannelImpl.inetAddress;
        this.rawAddress = serverChannelImpl.rawAddress;
        this.inSockAddress = serverChannelImpl.inSockAddress;
        this.implicitChannel = true;
        this.protocol = protocol;
        this.isLocal = serverChannelImpl.isLocal;
        this.priority = protocol.getHandler().getPriority();
        if (this.displayName == null) {
            this.displayName = serverChannelImpl.channelName;
        }
        this.channelName = ServerChannelImpl.encodeName(protocol, this.displayName);
    }

    private static void p(String string) {
        System.out.println("<ServerChannelImpl>: " + string);
    }

    public static ServerChannel createDefaultServerChannel(Protocol protocol) {
        try {
            if (KernelStatus.isServer()) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                return new ServerChannelImpl(new NetworkAccessPointDefaultMBean(protocol, ManagementService.getRuntimeAccess(authenticatedSubject).getServer()), protocol, LocalServerIdentity.getIdentity());
            }
            return new ServerChannelImpl(new NetworkAccessPointMBeanStub(protocol.getProtocolName()), protocol, LocalServerIdentity.getIdentity());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }
}

