/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.util.Iterator;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerChannelRuntimeMBean;
import weblogic.management.runtime.ServerConnectionRuntime;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.utils.collections.WeakConcurrentHashMap;

public class ServerChannelRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServerChannelRuntimeMBean {
    private final transient WeakConcurrentHashMap connectedSockets = new WeakConcurrentHashMap();
    private final ServerChannel channel;
    private long pastBytesSent;
    private long pastBytesReceived;
    private long pastMessagesSent;
    private long pastMessagesReceived;
    private long acceptCount;

    ServerChannelRuntimeMBeanImpl(ServerChannelImpl serverChannelImpl) throws ManagementException {
        super(serverChannelImpl.getChannelName().replace(':', '_'));
        this.channel = serverChannelImpl;
    }

    public void addServerConnectionRuntime(ServerConnectionRuntime serverConnectionRuntime) {
        this.connectedSockets.put((Object)serverConnectionRuntime.getSocketRuntime(), (Object)serverConnectionRuntime);
        ++this.acceptCount;
    }

    public void removeServerConnectionRuntime(SocketRuntime socketRuntime) {
        ServerConnectionRuntime serverConnectionRuntime = (ServerConnectionRuntime)this.connectedSockets.remove((Object)socketRuntime);
        if (serverConnectionRuntime != null) {
            this.pastBytesReceived += serverConnectionRuntime.getBytesReceivedCount();
            this.pastBytesSent += serverConnectionRuntime.getBytesSentCount();
            this.pastMessagesSent += serverConnectionRuntime.getMessagesSentCount();
            this.pastMessagesReceived += serverConnectionRuntime.getMessagesReceivedCount();
        }
    }

    public ServerConnectionRuntime[] getServerConnectionRuntimes() {
        return this.connectedSockets.values().toArray(new ServerConnectionRuntime[this.connectedSockets.size()]);
    }

    public long getConnectionsCount() {
        return this.connectedSockets.size();
    }

    public long getBytesReceivedCount() {
        long l = this.pastBytesReceived;
        Iterator iterator = this.connectedSockets.values().iterator();
        while (iterator.hasNext()) {
            l += ((ServerConnectionRuntime)iterator.next()).getBytesReceivedCount();
        }
        return l;
    }

    public long getAcceptCount() {
        return this.acceptCount;
    }

    public long getBytesSentCount() {
        long l = this.pastBytesSent;
        Iterator iterator = this.connectedSockets.values().iterator();
        while (iterator.hasNext()) {
            l += ((ServerConnectionRuntime)iterator.next()).getBytesSentCount();
        }
        return l;
    }

    public String getChannelName() {
        return this.channel.getChannelName();
    }

    public long getMessagesReceivedCount() {
        long l = this.pastMessagesReceived;
        Iterator iterator = this.connectedSockets.values().iterator();
        while (iterator.hasNext()) {
            l += ((ServerConnectionRuntime)iterator.next()).getMessagesReceivedCount();
        }
        return l;
    }

    public long getMessagesSentCount() {
        long l = this.pastMessagesSent;
        Iterator iterator = this.connectedSockets.values().iterator();
        while (iterator.hasNext()) {
            l += ((ServerConnectionRuntime)iterator.next()).getMessagesSentCount();
        }
        return l;
    }

    public String getPublicURL() {
        return this.channel.getProtocolPrefix() + "://" + this.channel.getPublicAddress() + ":" + this.channel.getPublicPort();
    }
}

