/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import weblogic.management.runtime.ServerConnectionRuntime;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.MessageReceiverStatistics;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.server.channels.SocketRuntimeImpl;
import weblogic.utils.Debug;

public class ServerConnectionRuntimeImpl
implements ServerConnectionRuntime {
    private WeakReference sender;
    private final WeakReference receiver;
    private final WeakReference socket;

    public ServerConnectionRuntimeImpl(MessageSenderStatistics messageSenderStatistics, MessageReceiverStatistics messageReceiverStatistics, SocketRuntime socketRuntime) {
        Debug.assertion((messageReceiverStatistics != null ? 1 : 0) != 0);
        this.sender = new WeakReference<MessageSenderStatistics>(messageSenderStatistics);
        this.receiver = new WeakReference<MessageReceiverStatistics>(messageReceiverStatistics);
        this.socket = new WeakReference<SocketRuntime>(socketRuntime);
    }

    public long getBytesReceivedCount() {
        MessageReceiverStatistics messageReceiverStatistics = this.getReceiver();
        return messageReceiverStatistics == null ? 0L : messageReceiverStatistics.getBytesReceivedCount();
    }

    public long getBytesSentCount() {
        MessageSenderStatistics messageSenderStatistics = this.getSender();
        return messageSenderStatistics == null ? 0L : messageSenderStatistics.getBytesSentCount();
    }

    public long getConnectTime() {
        MessageReceiverStatistics messageReceiverStatistics = this.getReceiver();
        return messageReceiverStatistics == null ? 0L : messageReceiverStatistics.getConnectTime();
    }

    public long getMessagesReceivedCount() {
        MessageReceiverStatistics messageReceiverStatistics = this.getReceiver();
        return messageReceiverStatistics == null ? 0L : messageReceiverStatistics.getMessagesReceivedCount();
    }

    public long getMessagesSentCount() {
        MessageSenderStatistics messageSenderStatistics = this.getSender();
        return messageSenderStatistics == null ? 0L : messageSenderStatistics.getMessagesSentCount();
    }

    public void addSender(MessageSenderStatistics messageSenderStatistics) {
        this.sender = new WeakReference<MessageSenderStatistics>(messageSenderStatistics);
    }

    private MessageSenderStatistics getSender() {
        return (MessageSenderStatistics)this.sender.get();
    }

    private MessageReceiverStatistics getReceiver() {
        return (MessageReceiverStatistics)this.receiver.get();
    }

    public SocketRuntime getSocketRuntime() {
        return (SocketRuntime)this.socket.get();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializableConnectionRuntime(this);
    }

    private static class SerializableConnectionRuntime
    implements ServerConnectionRuntime {
        private long bytesIn;
        private long bytesOut;
        private long msgIn;
        private long msgOut;
        private long connect;
        private SocketRuntime sock;

        private SerializableConnectionRuntime(ServerConnectionRuntime serverConnectionRuntime) {
            this.bytesIn = serverConnectionRuntime.getBytesReceivedCount();
            this.bytesOut = serverConnectionRuntime.getBytesSentCount();
            this.msgIn = serverConnectionRuntime.getMessagesReceivedCount();
            this.msgOut = serverConnectionRuntime.getMessagesSentCount();
            this.connect = serverConnectionRuntime.getConnectTime();
            SocketRuntime socketRuntime = serverConnectionRuntime.getSocketRuntime();
            if (socketRuntime != null) {
                this.sock = new SocketRuntimeImpl(socketRuntime);
            }
        }

        public long getBytesReceivedCount() {
            return this.bytesIn;
        }

        public long getBytesSentCount() {
            return this.bytesOut;
        }

        public long getConnectTime() {
            return this.connect;
        }

        public long getMessagesReceivedCount() {
            return this.msgIn;
        }

        public long getMessagesSentCount() {
            return this.msgOut;
        }

        public SocketRuntime getSocketRuntime() {
            return this.sock;
        }
    }
}

