/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.channels;

import java.security.AccessController;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLogger;
import weblogic.utils.concurrent.Semaphore;

public final class ServerThrottle {
    private static final boolean DEBUG = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final Semaphore lock;
    private volatile boolean enabled = false;

    public static ServerThrottle getServerThrottle() {
        return ServerThrottleMaker.SINGLETON;
    }

    private ServerThrottle() {
        int n = this.getMaxOpenSockets();
        this.enabled = n > 0;
        this.lock = new Semaphore(n);
    }

    void changeMaxOpenSockets(int n) {
        this.enabled = n > 0;
        this.lock.changePermits(n);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void acquireSocketPermit() {
        if (!this.lock.tryAcquire()) {
            ServerLogger.logMaxOpenSockets((int)this.getMaxOpenSockets(), (int)this.getMaxOpenSockets());
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            runtimeAccess.getServerRuntime().setHealthState(1, "Max Threshold Reached for Open Sockets.  MaxOpenSockCount can be tuned.");
            this.lock.acquire();
            ServerLogger.logAcceptingConnections();
            runtimeAccess.getServerRuntime().setHealthState(0, "");
        }
    }

    public void decrementOpenSocketCount() {
        this.lock.release();
    }

    private int getMaxOpenSockets() {
        int n = Kernel.getConfig().getMaxOpenSockCount();
        return n;
    }

    private void debug(String string) {
        System.out.println("[ServerThrottle] " + string);
    }

    private static final class ServerThrottleMaker {
        private static final ServerThrottle SINGLETON = new ServerThrottle();

        private ServerThrottleMaker() {
        }
    }
}

