/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.IOException;
import java.security.AccessController;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.WebLogicServletContext;
import weblogic.servlet.internal.WebAppServletContext;

public final class AsyncInitServlet
implements Servlet {
    private static final boolean DEBUG = false;
    String SERVLET_CLASS_NAME = "weblogic.servlet.AsyncInitServlet.servlet-class-name";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Servlet delegate;
    private ServletConfig config;

    private Servlet createDelegate(ServletConfig servletConfig) throws ServletException {
        String string = servletConfig.getInitParameter(this.SERVLET_CLASS_NAME);
        if (string == null) {
            throw new ServletException("Required init-param " + this.SERVLET_CLASS_NAME + " not found");
        }
        try {
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            return (Servlet)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("Can't load " + this.SERVLET_CLASS_NAME + " named " + string, (Throwable)classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ServletException("Can't load " + this.SERVLET_CLASS_NAME + " named " + string, (Throwable)noClassDefFoundError);
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("Servlet class " + string + " does not implement javax.servlet.Servlet");
        }
        catch (InstantiationException instantiationException) {
            throw new ServletException("Exception while creating servlet " + string, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException("Servlet " + string + " does not have a public constructor", (Throwable)illegalAccessException);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        if (DevModeSingleton.isDevMode()) {
            WebLogicServletContext webLogicServletContext = (WebLogicServletContext)servletConfig.getServletContext();
            if (((WebAppServletContext)webLogicServletContext).isOnDemandDisplayRefresh()) {
                this.initDelegate();
            } else {
                webLogicServletContext.addAsyncInitServlet(this);
            }
        } else {
            this.initDelegate();
        }
    }

    private boolean isShuttingDown() {
        return ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown();
    }

    public void initDelegate() throws ServletException {
        if (this.isShuttingDown()) {
            return;
        }
        try {
            this.delegate = this.createDelegate(this.config);
            this.delegate.init(this.config);
        }
        catch (Throwable throwable) {
            if (this.isShuttingDown()) {
                return;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(throwable);
        }
    }

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.delegate.service(servletRequest, servletResponse);
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    static /* synthetic */ AuthenticatedSubject access$000() {
        return kernelId;
    }

    private static class DevModeSingleton {
        private static DevModeSingleton SINGLETON = new DevModeSingleton();
        private final boolean isDevMode = !ManagementService.getRuntimeAccess(AsyncInitServlet.access$000()).getDomain().isProductionModeEnabled();

        private DevModeSingleton() {
        }

        static boolean isDevMode() {
            return DevModeSingleton.SINGLETON.isDevMode;
        }
    }
}

